/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.assetcard;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.BillStatus;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.fa.business.calc.DynamicObjectWrapper;
import kd.fi.fa.business.calc.FinCardCalc;
import kd.fi.fa.business.calc.IObjWrapper;
import kd.fi.fa.business.validator.FinCardValidator;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.opplugin.assetcard.AbstractAssetCardOp;

public class FaAssetCardInitSaveOp
extends AbstractAssetCardOp {
    private static final Log logger = LogFactory.getLog(FaAssetCardInitSaveOp.class);

    @Override
    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator(new AbstractValidator(){

            public void validate() {
                ArrayList<DynamicObject> finCards = new ArrayList<DynamicObject>(this.getDataEntities().length);
                HashMap errInfo = new HashMap(this.getDataEntities().length);
                for (ExtendedDataEntity dataEntity : this.getDataEntities()) {
                    DynamicObject assetCard = dataEntity.getDataEntity();
                    if (!assetCard.getDataEntityState().getFromDatabase()) continue;
                    DynamicObjectCollection finentry = assetCard.getDynamicObjectCollection("finentry");
                    for (DynamicObject entry : finentry) {
                        DynamicObject finCard = entry.getDynamicObject("fincard");
                        finCards.add(finCard);
                    }
                }
                if (!finCards.isEmpty()) {
                    FinCardValidator validator = FinCardValidator.getInstanceForSeparateCard(finCards);
                    errInfo.putAll(validator.validateInitFinCardForDelete());
                    for (int i = 0; i < this.getDataEntities().length; ++i) {
                        ExtendedDataEntity dataEntity;
                        List errMsg = (List)errInfo.get(i);
                        if (errMsg == null || errMsg.isEmpty()) continue;
                        dataEntity = this.getDataEntities()[i];
                        errMsg.forEach(v -> this.addErrorMessage(dataEntity, (String)v));
                    }
                }
            }
        });
    }

    @Override
    protected Function<FinCardValidator, Map<Integer, List<String>>> getFinValidateFunc() {
        return FinCardValidator::validateFinCardForSubmit;
    }

    @Override
    protected void handleFinCardsByBook(DynamicObject[] assetCards, DynamicObject[] finCards) {
        Map<Long, DynamicObject> realCardIdMap = Arrays.stream(assetCards).collect(Collectors.toMap(v -> v.getLong("id"), v -> v));
        for (DynamicObject finCard : finCards) {
            finCard.set("billstatus", (Object)BillStatus.C.name());
            long realCardId = finCard.getLong(Fa.id((String)"realcard"));
            DynamicObject realCard = realCardIdMap.get(realCardId);
            finCard.set("number", (Object)realCard.getString("number"));
            finCard.set("billno", (Object)realCard.getString("billno"));
            finCard.set("assetcat", (Object)realCard.getDynamicObject("assetcat"));
            finCard.set("depredept", (Object)realCard.getDynamicObject("headusedept"));
            Long masterId = realCard.getLong("masterid");
            if (masterId == 0L) {
                masterId = realCardId;
            }
            finCard.set("realcardmasterid", (Object)masterId);
            DynamicObjectWrapper objWrapper = new DynamicObjectWrapper(finCard);
            FinCardCalc.setNetWorth((IObjWrapper)objWrapper);
            FinCardCalc.setNetAmount((IObjWrapper)objWrapper);
            if (finCard.getLong("id") != 0L) continue;
            logger.info("\u4e0d\u80fd\u4fdd\u5b58fid\u4e3a0\u7684\u521d\u59cb\u5316\u8d22\u52a1\u5361\u7247\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u68c0\u67e5\u6570\u636erealcardObj:[{}],------------------------ finCardObj:[{}]", (Object)SerializationUtils.toJsonString((Object)realCard), (Object)SerializationUtils.toJsonString((Object)realCard));
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u80fd\u4fdd\u5b58fid\u4e3a0\u7684\u521d\u59cb\u5316\u8d22\u52a1\u5361\u7247\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u68c0\u67e5\u6570\u636e\u3002", (String)"FaAssetCardInitSaveOp_0", (String)"fi-fa-opplugin", (Object[])new Object[0]));
        }
        SaveServiceHelper.save((DynamicObject[])finCards);
    }
}

