/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.assetcard;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.fa.business.calc.DynamicObjectWrapper;
import kd.fi.fa.business.calc.FinCardCalc;
import kd.fi.fa.business.calc.IObjWrapper;
import kd.fi.fa.business.utils.FaAssetBookDataUpgradeLogUtils;
import kd.fi.fa.business.validator.FinCardValidator;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.opplugin.assetcard.AbstractAssetCardOp;
import kd.fi.fa.opplugin.validator.FaProductLineValidator;

public class FaAssetCardSaveOp
extends AbstractAssetCardOp {
    private static final Log logger = LogFactory.getLog(FaAssetCardSaveOp.class);

    @Override
    protected Function<FinCardValidator, Map<Integer, List<String>>> getFinValidateFunc() {
        return FinCardValidator::validateFinCardForSave;
    }

    @Override
    protected void handleFinCardsByBook(DynamicObject[] assetCards, DynamicObject[] finCards) {
        Map<Long, DynamicObject> realCardIdMap = Arrays.stream(assetCards).collect(Collectors.toMap(v -> v.getLong("id"), v -> v));
        for (DynamicObject finCard : finCards) {
            long realCardId = finCard.getLong(Fa.id((String)"realcard"));
            DynamicObject realCard = realCardIdMap.get(realCardId);
            finCard.set("number", (Object)realCard.getString("number"));
            finCard.set("billno", (Object)realCard.getString("billno"));
            finCard.set("assetcat", (Object)realCard.getDynamicObject("assetcat"));
            finCard.set("depredept", (Object)realCard.getDynamicObject("headusedept"));
            finCard.set("realcardmasterid", (Object)realCard.getLong("masterid"));
            boolean curPeriodSplitEnable = FaAssetBookDataUpgradeLogUtils.enableCurPeriodSplit((Long)finCard.getLong(Fa.id((String)"org")));
            if (curPeriodSplitEnable) {
                finCard.set("isneeddepre", (Object)false);
                finCard.set("originaldata", (Object)true);
            }
            DynamicObjectWrapper objWrapper = new DynamicObjectWrapper(finCard);
            FinCardCalc.setNetWorth((IObjWrapper)objWrapper);
            FinCardCalc.setNetAmount((IObjWrapper)objWrapper);
            if (finCard.getLong("id") != 0L) continue;
            logger.info("\u4e0d\u80fd\u4fdd\u5b58fid\u4e3a0\u7684\u521d\u59cb\u5316\u8d22\u52a1\u5361\u7247\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u68c0\u67e5\u6570\u636erealcardObj:[{}],------------------------ finCardObj:[{}]", (Object)SerializationUtils.toJsonString((Object)realCard), (Object)SerializationUtils.toJsonString((Object)realCard));
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u80fd\u4fdd\u5b58fid\u4e3a0\u7684\u8d22\u52a1\u5361\u7247\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u68c0\u67e5\u6570\u636e\u3002", (String)"FaAssetCardSaveOp_0", (String)"fi-fa-opplugin", (Object[])new Object[0]));
        }
        SaveServiceHelper.save((DynamicObject[])finCards);
    }

    @Override
    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new FaProductLineValidator());
    }
}

