/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.assetcard;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.BillStatus;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.fa.business.utils.FaAssetBookDataUpgradeLogUtils;
import kd.fi.fa.business.validator.FinCardValidator;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.opplugin.DepredAmountValidator;
import kd.fi.fa.opplugin.assetcard.AbstractAssetCardOp;
import kd.fi.fa.opplugin.validator.FaProductLineValidator;

public class FaAssetCardSubmitOp
extends AbstractAssetCardOp {
    @Override
    protected Function<FinCardValidator, Map<Integer, List<String>>> getFinValidateFunc() {
        return FinCardValidator::validateFinCardForSubmit;
    }

    @Override
    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new DepredAmountValidator());
        e.addValidator((AbstractValidator)new FaProductLineValidator());
    }

    @Override
    protected void handleFinCardsByBook(DynamicObject[] assetCards, DynamicObject[] finCards) {
        Map<Long, DynamicObject> realCardIdMap = Arrays.stream(assetCards).collect(Collectors.toMap(v -> v.getLong("id"), v -> v));
        for (DynamicObject finCard : finCards) {
            finCard.set("billstatus", (Object)BillStatus.B.name());
            long realCardId = finCard.getLong(Fa.id((String)"realcard"));
            DynamicObject realCard = realCardIdMap.get(realCardId);
            finCard.set("number", (Object)realCard.getString("number"));
            finCard.set("billno", (Object)realCard.getString("billno"));
            finCard.set("assetcat", (Object)realCard.getDynamicObject("assetcat"));
            finCard.set("depredept", (Object)realCard.getDynamicObject("headusedept"));
            finCard.set("realcardmasterid", (Object)realCard.getLong("masterid"));
            boolean curPeriodSplitEnable = FaAssetBookDataUpgradeLogUtils.enableCurPeriodSplit((Long)finCard.getLong(Fa.id((String)"org")));
            if (curPeriodSplitEnable) {
                finCard.set("isneeddepre", (Object)false);
                finCard.set("originaldata", (Object)true);
                finCard.set("endperiod", finCard.get("period"));
            }
            finCard.set("monthorigvalchg", (Object)finCard.getBigDecimal("originalval"));
            finCard.set("yearorigvalchg", (Object)finCard.getBigDecimal("originalval"));
        }
        SaveServiceHelper.save((DynamicObject[])finCards);
    }
}

