/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.assetcard;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.validate.BillStatus;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.fa.business.utils.FaCardBotpUtil;
import kd.fi.fa.business.validator.FinCardValidator;
import kd.fi.fa.opplugin.FaFinCardOperationPlugin;
import kd.fi.fa.opplugin.assetcard.AbstractAssetCardOp;

public class FaAssetCardUnAuditOp
extends AbstractAssetCardOp {
    @Override
    protected Function<FinCardValidator, Map<Integer, List<String>>> getFinValidateFunc() {
        return FinCardValidator::validateFinCardForUnAudit;
    }

    @Override
    protected void handleFinCardsByBook(DynamicObject[] assetCards, DynamicObject[] finCards) {
        ArrayList<DynamicObject> unAuditFinCards = new ArrayList<DynamicObject>(finCards.length);
        for (DynamicObject assetCard : assetCards) {
            DynamicObjectCollection assetCardFins = assetCard.getDynamicObjectCollection("finentry");
            for (DynamicObject entry : assetCardFins) {
                DynamicObject finCard = entry.getDynamicObject("originalfincard");
                unAuditFinCards.add(finCard);
            }
        }
        HashMap<Long, Long> oriFinId2RealIdMap = new HashMap<Long, Long>(unAuditFinCards.size());
        for (DynamicObject finCard : unAuditFinCards) {
            finCard.set("billstatus", (Object)BillStatus.A.name());
            boolean originalData = finCard.getBoolean("originaldata");
            if (!originalData) continue;
            finCard.set("realcard", (Object)finCard.getLong("realcardmasterid"));
            oriFinId2RealIdMap.put(finCard.getLong("id"), finCard.getLong("realcardmasterid"));
        }
        SaveServiceHelper.save((DynamicObject[])unAuditFinCards.toArray(new DynamicObject[0]));
        FaFinCardOperationPlugin.unaudit(unAuditFinCards);
        FaCardBotpUtil.assetOriFinCardBotpHandler4UnAudit(oriFinId2RealIdMap);
    }
}

