/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.botp;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.exception.KDBizException;
import kd.fi.fa.business.dao.impl.FaDaoOrmImpl;
import kd.fi.fa.business.utils.FaBizUtils;
import kd.fi.fa.common.util.DateUtil;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.utils.FaOpQueryUtils;

public class InvdifferToClearBillPlugin
extends AbstractConvertPlugIn {
    public void afterConvert(AfterConvertEventArgs e) {
        ExtendedDataEntitySet targetExtDataEntitySet = e.getTargetExtDataEntitySet();
        ExtendedDataEntity[] extendedDataEntityArr = targetExtDataEntitySet.FindByEntityKey("fa_clearbill");
        List clearBillObjs = Stream.of(extendedDataEntityArr).map(v -> v.getDataEntity()).collect(Collectors.toList());
        if (clearBillObjs.size() == 0) {
            return;
        }
        DynamicObject clearBill = (DynamicObject)clearBillObjs.get(0);
        Date clearDate = clearBill.getDate("cleardate");
        long orgId = clearBill.getLong("org_id");
        DynamicObject assBook = FaBizUtils.getAsstBookByOrg((Long)orgId);
        Date beginDate = assBook.getDate("begindate");
        Date endDate = assBook.getDate("enddate");
        endDate = DateUtil.stripTime((Date)endDate);
        if (clearDate.getTime() > endDate.getTime()) {
            clearBill.set("cleardate", (Object)endDate);
        }
        if (clearDate.compareTo(beginDate) < 0) {
            clearBill.set("cleardate", (Object)beginDate);
        }
        clearBill.set(Fa.id((String)"clearperiod"), (Object)assBook.getLong("curperiod"));
        DynamicObjectCollection cleardetail_entry = ((DynamicObject)clearBillObjs.get(0)).getDynamicObjectCollection("detail_entry");
        HashSet<Object> realCardPKSet = new HashSet<Object>(16);
        long realcard = ((DynamicObject)cleardetail_entry.get(0)).getLong("realcard_id");
        realCardPKSet.add(realcard);
        Map<Long, List<DynamicObject>> finCardsMap = this.queryFinCardsMap(realCardPKSet);
        if (finCardsMap.size() > 0) {
            List<DynamicObject> fincards = finCardsMap.get(realcard);
            for (int x = 0; x < fincards.size(); ++x) {
                if (x > 0) {
                    this.setEntryRowByCard(cleardetail_entry, fincards.get(x), assBook, x);
                    continue;
                }
                this.setEntryRowByFinCard(cleardetail_entry, fincards.get(x), Boolean.TRUE, assBook);
            }
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u6839\u636e\u76d8\u4e8f\u7684\u5b9e\u7269\u5361\u7247\u65e0\u6cd5\u627e\u5230\u5bf9\u5e94\u671f\u95f4\u8d22\u52a1\u5361\u7247\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u4e3a\u672a\u6765\u671f\u95f4\u5361\u7247\u3002", (String)"InvdifferToClearBillPlugin_0", (String)"fi-fa-opplugin", (Object[])new Object[0]));
        }
    }

    private void setEntryRowByCard(DynamicObjectCollection cleardetail_entry, DynamicObject fincard, DynamicObject assBook, int x) {
        DynamicObject realCardDy = fincard.getDynamicObject("realcard");
        DynamicObject entry = cleardetail_entry.addNew();
        entry.set("realcard", (Object)realCardDy.getLong("id"));
        entry.set("seq", (Object)(x + 1));
        entry.set("number", (Object)realCardDy.getString("number"));
        entry.set("assetname", (Object)realCardDy.getString("assetname"));
        entry.set("number", (Object)realCardDy.getString("number"));
        entry.set("assetname", (Object)realCardDy.getString("assetname"));
        entry.set("depreuse", (Object)fincard.getDynamicObject("depreuse"));
        entry.set("measureunit", (Object)((DynamicObject)cleardetail_entry.get(0)).getDynamicObject("measureunit"));
        entry.set("bizdate", (Object)((DynamicObject)cleardetail_entry.get(0)).getDate("bizdate"));
        entry.set("realcard_id", (Object)realCardDy.getLong("id"));
        entry.set("measureunit_id", (Object)((DynamicObject)cleardetail_entry.get(0)).getDynamicObject("measureunit").getLong("id"));
        int scal = ((DynamicObject)cleardetail_entry.get(0)).getDynamicObject("measureunit").getInt("precision");
        BigDecimal assetQty = realCardDy.getBigDecimal("assetamount");
        BigDecimal clearQty = ((DynamicObject)cleardetail_entry.get(0)).getBigDecimal("clearqty");
        BigDecimal rate = clearQty.divide(assetQty, 15, 4);
        entry.set("assetqty", (Object)assetQty.setScale(scal));
        entry.set("clearqty", (Object)clearQty.setScale(scal));
        DynamicObject baseCurrency = fincard.getDynamicObject(FaDaoOrmImpl.dot((String[])new String[]{"assetbook", "basecurrency"}));
        entry.set("basecurrency", (Object)baseCurrency);
        this.setPartValue(rate, fincard, Boolean.FALSE, entry);
        Date endDate = assBook.getDate("enddate");
        endDate = DateUtil.stripTime((Date)endDate);
        if (((DynamicObject)cleardetail_entry.get(0)).getDate("bizdate").getTime() > endDate.getTime()) {
            entry.set("bizdate", (Object)endDate);
        }
        entry.set("fincard", (Object)fincard);
    }

    private void setEntryRowByFinCard(DynamicObjectCollection cleardetail_entry, DynamicObject fincard, Boolean initCard, DynamicObject assBook) {
        DynamicObject realCardDy = fincard.getDynamicObject("realcard");
        if (initCard.booleanValue()) {
            ((DynamicObject)cleardetail_entry.get(0)).set("realcard", (Object)realCardDy.getLong("id"));
        }
        ((DynamicObject)cleardetail_entry.get(0)).set("number", (Object)realCardDy.getString("number"));
        ((DynamicObject)cleardetail_entry.get(0)).set("assetname", (Object)realCardDy.getString("assetname"));
        ((DynamicObject)cleardetail_entry.get(0)).set("number", (Object)realCardDy.getString("number"));
        ((DynamicObject)cleardetail_entry.get(0)).set("assetname", (Object)realCardDy.getString("assetname"));
        ((DynamicObject)cleardetail_entry.get(0)).set("depreuse", (Object)fincard.getDynamicObject("depreuse"));
        int scal = ((DynamicObject)cleardetail_entry.get(0)).getDynamicObject("measureunit").getInt("precision");
        BigDecimal assetQty = realCardDy.getBigDecimal("assetamount");
        BigDecimal clearQty = ((DynamicObject)cleardetail_entry.get(0)).getBigDecimal("clearqty");
        BigDecimal rate = clearQty.divide(assetQty, 15, 4);
        ((DynamicObject)cleardetail_entry.get(0)).set("assetqty", (Object)assetQty.setScale(scal));
        ((DynamicObject)cleardetail_entry.get(0)).set("clearqty", (Object)clearQty.setScale(scal));
        DynamicObject baseCurrency = fincard.getDynamicObject(FaDaoOrmImpl.dot((String[])new String[]{"assetbook", "basecurrency"}));
        ((DynamicObject)cleardetail_entry.get(0)).set("basecurrency", (Object)baseCurrency);
        this.setPartValue(rate, fincard, Boolean.FALSE, (DynamicObject)cleardetail_entry.get(0));
        Date endDate = assBook.getDate("enddate");
        endDate = DateUtil.stripTime((Date)endDate);
        if (((DynamicObject)cleardetail_entry.get(0)).getDate("bizdate").getTime() > endDate.getTime()) {
            ((DynamicObject)cleardetail_entry.get(0)).set("bizdate", (Object)endDate);
        }
        ((DynamicObject)cleardetail_entry.get(0)).set("fincard", (Object)fincard);
    }

    private Map<Long, List<DynamicObject>> queryFinCardsMap(Set<Object> realCardPKSet) {
        List<DynamicObject> finCardLst = FaOpQueryUtils.queryFinCards(realCardPKSet);
        Map<Long, List<DynamicObject>> result = this.finCardslist2Map(finCardLst);
        return result;
    }

    private Map<Long, List<DynamicObject>> finCardslist2Map(List<DynamicObject> finCards) {
        HashMap<Long, List<DynamicObject>> result = new HashMap<Long, List<DynamicObject>>();
        for (DynamicObject finCard : finCards) {
            Long readCardMasterId = finCard.getLong("realcardmasterid");
            List readCardIdV = (List)result.get(readCardMasterId);
            if (readCardIdV != null) {
                readCardIdV.add(finCard);
                continue;
            }
            ArrayList<DynamicObject> dys = new ArrayList<DynamicObject>();
            dys.add(finCard);
            result.put(readCardMasterId, dys);
        }
        return result;
    }

    void setPartValue(BigDecimal rate, DynamicObject fincard, Boolean assetVlue, DynamicObject entry) {
        entry.set("clearrate", (Object)rate);
        if (assetVlue.booleanValue()) {
            entry.set("isclearall", (Object)(rate.compareTo(BigDecimal.ONE) == 0 ? "1" : "0"));
        } else {
            entry.set("isclearall", (Object)(rate.compareTo(BigDecimal.ONE) == 0 ? "1" : "2"));
        }
        DynamicObject currency = fincard.getDynamicObject("currency");
        if (currency == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0b\u63a8\u6e05\u7406\u5355\u5931\u8d25\uff0c\u8d22\u52a1\u5361\u7247\u672c\u4f4d\u5e01\u4e3a\u7a7a\u3002", (String)"InvdifferToClearBillPlugin_1", (String)"fi-fa-opplugin", (Object[])new Object[0]));
        }
        int amtPrecision = currency.getInt("amtprecision");
        entry.set("assetvalue", (Object)fincard.getBigDecimal("originalval").multiply(rate).setScale(amtPrecision, RoundingMode.HALF_UP));
        entry.set("addupdepre", (Object)fincard.getBigDecimal("accumdepre").multiply(rate).setScale(amtPrecision, RoundingMode.HALF_UP));
        entry.set("decval", (Object)fincard.getBigDecimal("decval").multiply(rate).setScale(amtPrecision, RoundingMode.HALF_UP));
        entry.set("netamount", (Object)fincard.getBigDecimal("netamount").multiply(rate).setScale(amtPrecision, RoundingMode.HALF_UP));
        entry.set("preresidualval", (Object)fincard.getBigDecimal("preresidualval").multiply(rate).setScale(amtPrecision, RoundingMode.HALF_UP));
    }
}

