/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.changebill;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.validate.BillStatus;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.fa.business.coderule.CodeRuleService;
import kd.fi.fa.business.dao.factory.FaChangeBillDaoFactory;
import kd.fi.fa.business.enums.BusyTypeDetailEnum;
import kd.fi.fa.business.periodclose.FutureBizChecker;
import kd.fi.fa.business.utils.FaBizUtils;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.utils.FaOpQueryUtils;

public class AssetChangeDTO {
    private String srcNumber;
    private String alias;
    private String reason;
    private String remark;
    private String sourcetype;
    private DynamicObject org;
    private DynamicObject dept;
    private DynamicObject receiver;
    private DynamicObject storeplace;
    private Map<Long, DynamicObject> storeplaceMap;
    private Map<Long, DynamicObject> deptMap;
    private Long sourceId;
    private DynamicObject creator;
    private DynamicObject auditor;
    private String fromsource;
    private List<ChangeEntryDTO> realEntries = new ArrayList<ChangeEntryDTO>();
    private List<ChangeEntryDTO> finEntries = new ArrayList<ChangeEntryDTO>();
    private List<ChangeEntryDTO> entries = new ArrayList<ChangeEntryDTO>();

    public String getSrcNumber() {
        return this.srcNumber;
    }

    public String getAlias() {
        return this.alias;
    }

    public String getReason() {
        return this.reason;
    }

    public String getRemark() {
        return this.remark;
    }

    public String getSourcetype() {
        return this.sourcetype;
    }

    public DynamicObject getOrg() {
        return this.org;
    }

    public DynamicObject getReceiver() {
        return this.receiver;
    }

    public DynamicObject getDept() {
        return this.dept;
    }

    public void setSrcNumber(String srcNumber) {
        this.srcNumber = srcNumber;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public void setSourcetype(String sourcetype) {
        this.sourcetype = sourcetype;
    }

    public void setOrg(DynamicObject org) {
        this.org = org;
    }

    public void setReceiver(DynamicObject receiver) {
        this.receiver = receiver;
    }

    public void setDept(DynamicObject dept) {
        this.dept = dept;
    }

    public DynamicObject getStoreplace() {
        return this.storeplace;
    }

    public void setStoreplace(DynamicObject storeplace) {
        this.storeplace = storeplace;
    }

    public Map<Long, DynamicObject> getStoreplaceMap() {
        return this.storeplaceMap;
    }

    public void setStoreplaceMap(Map<Long, DynamicObject> storeplaceMap) {
        this.storeplaceMap = storeplaceMap;
    }

    public DynamicObject getCreator() {
        return this.creator;
    }

    public void setCreator(DynamicObject creator) {
        this.creator = creator;
    }

    public DynamicObject getAuditor() {
        return this.auditor;
    }

    public void setAuditor(DynamicObject auditor) {
        this.auditor = auditor;
    }

    public String getFromsource() {
        return this.fromsource;
    }

    public void setFromsource(String fromsource) {
        this.fromsource = fromsource;
    }

    public Long getSourceId() {
        return this.sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }

    public Map<Long, DynamicObject> getDeptMap() {
        return this.deptMap;
    }

    public void setDeptMap(Map<Long, DynamicObject> deptMap) {
        this.deptMap = deptMap;
    }

    public DynamicObject toChangeBill(Date date) {
        Date bizDate = AssetChangeDTO.setDateDifPeriod(this.org, date);
        this.checkCard(bizDate);
        DynamicObject changeBill = FaChangeBillDaoFactory.getInstance().getEmptyDynamicObject();
        changeBill.set("org", (Object)this.org);
        changeBill.set("changedate", (Object)bizDate);
        changeBill.set("appliantid", (Object)this.receiver);
        if (this.remark != null) {
            changeBill.set("remark", (Object)this.remark);
        }
        DynamicObject changetypeDo = BusinessDataServiceHelper.loadSingleFromCache((Object)733953285719123968L, (String)"fa_change_type");
        changeBill.set("changetype", (Object)changetypeDo);
        changeBill.set("billstatus", (Object)BillStatus.A);
        changeBill.set("sourcetype", (Object)this.sourcetype);
        changeBill.set("voucherflag", (Object)"A");
        changeBill.set("sourceid", (Object)this.sourceId);
        changeBill.set("creator", (Object)this.creator);
        changeBill.set("createtime", (Object)new Date());
        changeBill.set("auditor", (Object)this.auditor);
        changeBill.set("auditdate", (Object)new Date());
        this.insertEntry(changeBill, "realentry");
        this.insertEntry(changeBill, "finentry");
        this.insertEntry(changeBill, "fieldentry");
        DynamicObjectCollection fieldentry = changeBill.getDynamicObjectCollection("fieldentry");
        fieldentry.forEach(row -> row.set("bizdate1", (Object)bizDate));
        changeBill.set("billno", (Object)this.genNumber(changeBill));
        return changeBill;
    }

    private void checkCard(Date bizDate) {
        HashSet<Object> realCardSet = new HashSet<Object>(this.entries.size());
        for (ChangeEntryDTO entry : this.entries) {
            if (entry.realCard == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u751f\u6210\u53d8\u66f4\u5355\u65f6\u53d1\u751f\u9519\u8bef\uff1a\u53d8\u66f4\u5206\u5f55\u6ca1\u6709\u5b9e\u7269\u5361\u7247\u4fe1\u606f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"AssetChangeDTO_0", (String)"fi-fa-opplugin", (Object[])new Object[0]));
            }
            realCardSet.add(entry.realCard.getPkValue());
        }
        if (realCardSet.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u751f\u6210\u53d8\u66f4\u5355\u65f6\u53d1\u751f\u9519\u8bef\uff1a\u6ca1\u6709\u53d8\u66f4\u5206\u5f55\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"AssetChangeDTO_1", (String)"fi-fa-opplugin", (Object[])new Object[0]));
        }
        DynamicObject org = this.getOrg();
        Optional checkResult = new FutureBizChecker(null, (Object)org.getLong("id"), realCardSet, bizDate, BusyTypeDetailEnum.REAL_CHG).check();
        if (checkResult.isPresent()) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u751f\u6210\u53d8\u66f4\u5355\u65f6\u53d1\u751f\u9519\u8bef\uff1a\u5361\u7247\u5b58\u5728\u540e\u7eed\u4e1a\u52a1\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c\uff1a%s", (String)"AssetChangeDTO_2", (String)"fi-fa-opplugin", (Object[])new Object[0]), checkResult.get()));
        }
        List<DynamicObject> finCards = FaOpQueryUtils.queryFinCardList(realCardSet, null);
        if (finCards.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u751f\u6210\u53d8\u66f4\u5355\u65f6\u53d1\u751f\u9519\u8bef\uff1a\u5b58\u5728\u672a\u6765\u671f\u95f4\u5361\u7247\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c\u3002", (String)"AssetChangeDTO_3", (String)"fi-fa-opplugin", (Object[])new Object[0]));
        }
    }

    private void insertEntry(DynamicObject changeBill, String entryName) {
        DynamicObjectCollection entries = null;
        if ("finentry".equals(entryName)) {
            DynamicObjectCollection realEntries = changeBill.getDynamicObjectCollection("realentry");
            realEntries.stream().forEach(realEntry -> {
                DynamicObjectCollection finEntries = realEntry.getDynamicObjectCollection("finentry");
                DynamicObject realCard = realEntry.getDynamicObject("realcard");
                DynamicObjectType finEntryType = finEntries.getDynamicObjectType();
                finEntries.addAll(this.genChangeEntries(finEntryType, realCard, "finentry"));
            });
        } else {
            entries = changeBill.getDynamicObjectCollection(entryName);
            DynamicObjectType entryType = entries.getDynamicObjectType();
            entries.addAll(this.genChangeEntries(entryType, null, entryName));
        }
    }

    private String genNumber(DynamicObject changeBill) {
        CodeRuleService instance = CodeRuleService.getInstance((DynamicObject)changeBill, (String)this.org.getPkValue().toString());
        String number = String.format(ResManager.loadKDString((String)"\u6765\u81ea%1$s\u3010%2$s\u3011", (String)"AssetChangeDTO_4", (String)"fi-fa-opplugin", (Object[])new Object[0]), this.alias, this.srcNumber);
        if (instance.isExistRule()) {
            number = instance.getNumber();
            while (this.validateDuplicate(number)) {
                number = instance.getNumber();
            }
        }
        return number;
    }

    private boolean validateDuplicate(String number) {
        return FaChangeBillDaoFactory.getInstance().isExist(new QFilter("billno", "=", (Object)number));
    }

    private List<DynamicObject> genChangeEntries(DynamicObjectType entryType, DynamicObject realCard, String entryName) {
        switch (entryName) {
            case "realentry": {
                LinkedList<DynamicObject> realEntrys = new LinkedList<DynamicObject>();
                this.realEntries.stream().forEach(changeEntryDTO -> realEntrys.addAll(this.cardToRealEntry((ChangeEntryDTO)changeEntryDTO, entryType)));
                return realEntrys;
            }
            case "finentry": {
                LinkedList<DynamicObject> finEntrys = new LinkedList<DynamicObject>();
                this.finEntries.stream().forEach(changeEntryDTO -> {
                    if (realCard.getPkValue().equals(((ChangeEntryDTO)changeEntryDTO).realCard.getPkValue())) {
                        finEntrys.addAll(this.cardToFinEntry((ChangeEntryDTO)changeEntryDTO, entryType));
                    }
                });
                return finEntrys;
            }
            case "fieldentry": {
                LinkedList<DynamicObject> changeEntrys = new LinkedList<DynamicObject>();
                this.entries.stream().forEach(changeEntryDTO -> changeEntrys.addAll(this.cardToChangeEntry((ChangeEntryDTO)changeEntryDTO, entryType)));
                return changeEntrys;
            }
        }
        return null;
    }

    private List<DynamicObject> cardToChangeEntry(ChangeEntryDTO changeEntryDTO, DynamicObjectType entryType) {
        LinkedList<DynamicObject> changeEntrys = new LinkedList<DynamicObject>();
        DynamicObject realCard = changeEntryDTO.realCard;
        DynamicObject finCard = changeEntryDTO.finCard;
        String changeReason = String.format(ResManager.loadKDString((String)"\u6765\u81ea%1$s\u3010%2$s\u3011", (String)"AssetChangeDTO_4", (String)"fi-fa-opplugin", (Object[])new Object[0]), this.alias, this.srcNumber);
        DynamicObject useDeptEntry = this.buildEntry("headusedept", entryType, realCard, finCard, changeReason);
        Object befVal1 = useDeptEntry.get("beforevalue");
        Object aftVal1 = useDeptEntry.get("aftervalue");
        if (befVal1 != null && !befVal1.equals(aftVal1)) {
            changeEntrys.add(useDeptEntry);
        }
        DynamicObject usePersonEntry = this.buildEntry("headuseperson", entryType, realCard, finCard, changeReason);
        Object befVal2 = usePersonEntry.get("beforevalue");
        Object aftVal2 = usePersonEntry.get("aftervalue");
        if (befVal2 != null && !befVal2.equals(aftVal2)) {
            changeEntrys.add(usePersonEntry);
        }
        DynamicObject storePlaceEntry = this.buildEntry("storeplace", entryType, realCard, finCard, changeReason);
        Object befVal3 = storePlaceEntry.get("beforevalue");
        Object aftVal3 = storePlaceEntry.get("aftervalue");
        if (befVal3 != null && !befVal3.equals(aftVal3)) {
            changeEntrys.add(storePlaceEntry);
        }
        if (changeEntrys.isEmpty()) {
            changeEntrys.add(useDeptEntry);
            changeEntrys.add(usePersonEntry);
            changeEntrys.add(storePlaceEntry);
        }
        return changeEntrys;
    }

    private DynamicObject buildEntry(String name, DynamicObjectType entryType, DynamicObject realCard, DynamicObject finCard, String reason) {
        String field = Fa.dot((String[])new String[]{"fa_card_real", name});
        DynamicObject changeEntry = new DynamicObject(entryType);
        DynamicObject beforeValue = realCard.getDynamicObject(name);
        DynamicObject afterValue = null;
        switch (name) {
            case "headusedept": {
                if (this.getDeptMap() != null) {
                    Long pkValue = (Long)realCard.getPkValue();
                    afterValue = this.getDeptMap().get(pkValue);
                    break;
                }
                afterValue = this.dept;
                break;
            }
            case "headuseperson": {
                afterValue = this.receiver;
                break;
            }
            case "storeplace": {
                if (this.storeplace != null) {
                    afterValue = this.storeplace;
                    break;
                }
                Long pkValue = (Long)realCard.getPkValue();
                if (!this.storeplaceMap.containsKey(pkValue)) break;
                afterValue = this.storeplaceMap.get(pkValue);
                break;
            }
        }
        changeEntry.set("realcard1", (Object)realCard);
        changeEntry.set("field", (Object)field);
        changeEntry.set("beforevalue", beforeValue == null ? "" : beforeValue.getPkValue());
        changeEntry.set("aftervalue", afterValue == null ? "" : afterValue.getPkValue());
        changeEntry.set("reason", (Object)reason);
        changeEntry.set("isadjustdepre1", (Object)false);
        if (finCard != null) {
            changeEntry.set("fincard1", (Object)finCard);
            changeEntry.set("depreuse1", (Object)finCard.getDynamicObject("depreuse"));
            changeEntry.set("currency1", (Object)finCard.getDynamicObject("currency"));
            changeEntry.set("basecurrency1", (Object)finCard.getDynamicObject("basecurrency"));
        }
        return changeEntry;
    }

    private List<DynamicObject> cardToRealEntry(ChangeEntryDTO changeEntryDTO, DynamicObjectType entryType) {
        LinkedList<DynamicObject> changeEntrys = new LinkedList<DynamicObject>();
        DynamicObject changeEntry1 = new DynamicObject(entryType);
        DynamicObject realCard = changeEntryDTO.realCard;
        changeEntry1.set("realcard", (Object)realCard);
        changeEntrys.add(changeEntry1);
        return changeEntrys;
    }

    private List<DynamicObject> cardToFinEntry(ChangeEntryDTO changeEntryDTO, DynamicObjectType entryType) {
        LinkedList<DynamicObject> changeEntrys = new LinkedList<DynamicObject>();
        DynamicObject changeEntry1 = new DynamicObject(entryType);
        DynamicObject finCard = changeEntryDTO.finCard;
        changeEntry1.set("fincard", (Object)finCard);
        changeEntry1.set("depreuse", finCard.getDynamicObject("depreuse").getPkValue());
        changeEntry1.set("currency", finCard.getDynamicObject("currency").getPkValue());
        changeEntrys.add(changeEntry1);
        return changeEntrys;
    }

    public void addRealEntry(DynamicObject realCard) {
        this.realEntries.add(new ChangeEntryDTO(realCard, null));
    }

    public void addFinEntry(DynamicObject realCard, DynamicObject finCard) {
        this.finEntries.add(new ChangeEntryDTO(realCard, finCard));
    }

    public void addEntry(DynamicObject realCard, DynamicObject finCard) {
        this.entries.add(new ChangeEntryDTO(realCard, finCard));
    }

    private static Date setDateDifPeriod(DynamicObject org, Date date) {
        Date now = new Date();
        if (org == null) {
            return now;
        }
        DynamicObject mainBook = FaBizUtils.getAsstBookByOrg((Long)org.getLong("id"));
        if (mainBook != null) {
            Date begindate = (Date)mainBook.get("begindate");
            Date enddate = (Date)mainBook.get("enddate");
            if (begindate == null) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u8d26\u7c3f\u7684\u5f00\u59cb\u671f\u95f4", (String)"AssetChangeDTO_5", (String)"fi-fa-opplugin", (Object[])new Object[0]), new Object[0]));
            }
            if (enddate == null) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u8d26\u7c3f\u7684\u7ed3\u675f\u671f\u95f4", (String)"AssetChangeDTO_6", (String)"fi-fa-opplugin", (Object[])new Object[0]), new Object[0]));
            }
            if (date.after(begindate) && date.before(enddate)) {
                return date;
            }
            if (date.before(begindate)) {
                return begindate;
            }
            if (date.after(enddate)) {
                return date;
            }
        } else {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u672a\u8bbe\u7f6e\u4e3b\u8d26\u7c3f\u3002", (String)"AssetChangeDTO_7", (String)"fi-fa-opplugin", (Object[])new Object[0]), org.getString("name")));
        }
        return date;
    }

    public List<ChangeEntryDTO> getEntries() {
        return this.entries;
    }

    private static class ChangeEntryDTO {
        private DynamicObject realCard;
        private DynamicObject finCard;

        public ChangeEntryDTO(DynamicObject realCard, DynamicObject finCard) {
            this.realCard = realCard;
            this.finCard = finCard;
        }

        public String toString() {
            return "ChangeEntryDTO [realCard=" + this.realCard + ", finCard=" + this.finCard + "]";
        }
    }
}

