/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.changebill;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.fa.business.busyrecord.AbstractBusyRecordServicePlugin;
import kd.fi.fa.business.utils.FaCardInitFieldUtil;
import kd.fi.fa.business.utils.FaChangeBillUtil;
import kd.fi.fa.business.utils.FaChangeTypeUtils;
import kd.fi.fa.cache.CacheHelper;
import kd.fi.fa.cache.CacheModule;
import kd.fi.fa.cache.DistributeCache;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.opplugin.changebill.FaChangeBillAuditValidator;
import kd.fi.fa.opplugin.changebill.FaChangeBillFeatureValidator;
import kd.fi.fa.opplugin.changebill.FaChangeBillSubmitCompFieldValidator;
import kd.fi.fa.opplugin.changebill.dto.ChangeInfo;
import kd.fi.fa.utils.FaOpUtils;

public class FaChangeBillAuditOp
extends AbstractBusyRecordServicePlugin {
    private static Log log = LogFactory.getLog(FaChangeBillAuditOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("org");
        fieldKeys.add("changedate");
        fieldKeys.add("changetype");
        fieldKeys.add("chtypedetail");
        fieldKeys.add("fieldentry");
        fieldKeys.add("depreuse1");
        fieldKeys.add("bizdate1");
        fieldKeys.add("realcard1");
        fieldKeys.add("fincard1");
        fieldKeys.add("field");
        fieldKeys.add("beforevalue");
        fieldKeys.add("aftervalue");
        fieldKeys.add("aftervalue");
        fieldKeys.add("changemode");
        fieldKeys.add("deletemode");
        fieldKeys.add("addmode");
        fieldKeys.add("realentry");
        fieldKeys.add(Fa.dot((String[])new String[]{"realentry", "realcard"}));
        fieldKeys.add("finentry");
        fieldKeys.add("realcard");
        fieldKeys.add(Fa.dot((String[])new String[]{"fincard", "id"}));
        fieldKeys.add(Fa.dot((String[])new String[]{"fincard", "finaccountdate"}));
        fieldKeys.add("bizdate");
        fieldKeys.add("isadjustdepre");
        fieldKeys.add(Fa.dot((String[])new String[]{"fieldentry", "isadjustdepre1"}));
        fieldKeys.add(Fa.dot((String[])new String[]{"fieldentry", "realcardmasterid"}));
        fieldKeys.add("changeitem");
        fieldKeys.add("basecurrency1");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new FaChangeBillFeatureValidator());
        e.addValidator((AbstractValidator)new FaChangeBillAuditValidator());
        e.addValidator((AbstractValidator)new FaChangeBillSubmitCompFieldValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        long start = System.currentTimeMillis();
        super.beginOperationTransaction(e);
        this.handleAddNewPeriodChange(e.getDataEntities());
        FaOpUtils.doOp(e, this.getEntityName());
        long cost = System.currentTimeMillis() - start;
        log.info("beginOperationTransaction cost [{}] ms", (Object)cost);
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        long start = System.currentTimeMillis();
        super.endOperationTransaction(e);
        DistributeCache distributeCache = CacheHelper.getDistributeCache((CacheModule)CacheModule.haschangeitem);
        String dci = distributeCache.get("deprechangeitems");
        DynamicObjectCollection depreChangeItems = new DynamicObjectCollection((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"fa_change_item"), null);
        if (dci != null) {
            depreChangeItems = (DynamicObjectCollection)SerializationUtils.deSerializeFromBase64((String)dci);
        }
        Set depreChgItemIds = depreChangeItems.stream().map(v -> v.get("id")).collect(Collectors.toSet());
        Set depreChgItemStr = depreChangeItems.stream().map(v -> v.getString("topic") + "." + v.getString("number")).collect(Collectors.toSet());
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"fa_card_dynamic");
        HashSet<String> dynamicCardSet = new HashSet<String>();
        ArrayList<DynamicObject> dynamicCards = new ArrayList<DynamicObject>();
        for (DynamicObject bill : e.getDataEntities()) {
            DynamicObjectCollection books = QueryServiceHelper.query((String)"fa_assetbook", (String)"id,depreuse", (QFilter[])new QFilter("org", "=", bill.get("org_id")).toArray());
            Map<Object, Object> bookMap = books.stream().collect(Collectors.toMap(v -> v.get("depreuse"), v -> v.get("id")));
            DynamicObjectCollection changeItems = QueryServiceHelper.query((String)"fa_change_type", (String)"changetypeentry.changeitem changeitem", (QFilter[])new QFilter("id", "=", bill.get("changetype_id")).toArray());
            Set chgItemIds = changeItems.stream().map(v -> v.get("changeitem")).collect(Collectors.toSet());
            HashSet depreChgItemCopy = new HashSet(depreChgItemIds);
            depreChgItemCopy.retainAll(chgItemIds);
            if (depreChgItemCopy.isEmpty()) continue;
            DynamicObjectCollection fieldEntries = bill.getDynamicObjectCollection("fieldentry");
            HashSet<Object> masterIdSet = new HashSet<Object>();
            for (DynamicObject fieldEntry : fieldEntries) {
                masterIdSet.add(fieldEntry.get("realcard1.masterid"));
            }
            DynamicObjectCollection alreadyDynamic = QueryServiceHelper.query((String)"fa_card_dynamic", (String)String.join((CharSequence)",", "realcard", "depreuse"), (QFilter[])new QFilter("realcard", "in", masterIdSet).toArray());
            for (DynamicObject fieldEntry : fieldEntries) {
                String dynamicKey;
                String fullField = fieldEntry.getString("field");
                boolean dynamic = fieldEntry.getBoolean("isadjustdepre1");
                if (!dynamic || !depreChgItemStr.contains(fullField)) continue;
                Object realCardId = fieldEntry.get("realcard1.masterid");
                Object depreUseId = fieldEntry.get("depreuse1_id");
                boolean exist = alreadyDynamic.stream().anyMatch(v -> v.get("realcard").equals(realCardId) && v.get("depreuse").equals(depreUseId));
                if (exist || !dynamicCardSet.add(dynamicKey = StringUtils.join((Object[])new String[]{realCardId.toString(), depreUseId.toString(), bill.getPkValue().toString()}, (String)":"))) continue;
                DynamicObject dynamicCard = new DynamicObject((DynamicObjectType)type);
                dynamicCard.set("realcard", realCardId);
                dynamicCard.set("assetbook", bookMap.get(depreUseId));
                dynamicCard.set("depreuse", depreUseId);
                dynamicCard.set("date", (Object)fieldEntry.getDate("bizdate1"));
                dynamicCard.set("entityname", (Object)"fa_change_dept");
                dynamicCard.set("changebillid", bill.getPkValue());
                dynamicCards.add(dynamicCard);
            }
        }
        if (!dynamicCards.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])dynamicCards.toArray(new DynamicObject[0]));
        }
        this.updateFinCardNeedDepre4WorkloadChg(e.getDataEntities());
        long cost = System.currentTimeMillis() - start;
        log.info("endOperationTransaction cost [{}] ms", (Object)cost);
    }

    private String getEntityName() {
        return "fa_change_dept";
    }

    private void handleAddNewPeriodChange(DynamicObject[] dataEntities) {
        String changeItemFields = Fa.comma((String[])new String[]{"topic", "number", "backfield"});
        QFilter[] changeItemFilters = new QFilter[]{new QFilter("isgenvoucher", "=", (Object)Boolean.TRUE), new QFilter("ischange", "=", (Object)Boolean.TRUE)};
        DynamicObjectCollection changeItems = QueryServiceHelper.query((String)"fa_change_item", (String)changeItemFields, (QFilter[])changeItemFilters);
        Map<String, String> changeItemMap = changeItems.stream().collect(Collectors.toMap(v -> Fa.dot((String[])new String[]{v.getString("topic"), v.getString("number")}), v -> v.getString("backfield")));
        for (DynamicObject entity : dataEntities) {
            Set<ChangeInfo> changeInfoSet = this.getChangeInfo(entity, changeItemMap);
            this.updateInitFields(entity, changeItemMap, changeInfoSet);
        }
    }

    private Set<ChangeInfo> getChangeInfo(DynamicObject entity, Map<String, String> changeItemMap) {
        Date changeDate = entity.getDate("changedate");
        DynamicObjectCollection fieldEntry = entity.getDynamicObjectCollection("fieldentry");
        Set periodIds = fieldEntry.stream().map(v -> v.getDynamicObject(Fa.dot((String[])new String[]{"fincard1", "period"}))).filter(Objects::nonNull).map(v -> v.getLong("id")).collect(Collectors.toSet());
        DynamicObjectCollection periods = QueryServiceHelper.query((String)"bd_period", (String)"id, begindate, enddate", (QFilter[])new QFilter("id", "in", periodIds).toArray());
        Map<Long, DynamicObject> periodMap = periods.stream().collect(Collectors.toMap(v -> v.getLong("id"), v -> v));
        HashSet<ChangeInfo> changeInfoSet = new HashSet<ChangeInfo>(fieldEntry.size());
        for (DynamicObject row : fieldEntry) {
            boolean firstChange;
            String field;
            DynamicObject finCard = row.getDynamicObject("fincard1");
            DynamicObject period = finCard.getDynamicObject("period");
            if (period == null) continue;
            period = periodMap.get(period.getLong("id"));
            Date beginDate = period.getDate("begindate");
            Date endDate = period.getDate("enddate");
            if (changeDate.compareTo(beginDate) < 0 || changeDate.compareTo(endDate) > 0 || !changeItemMap.containsKey(field = row.getString("field"))) continue;
            DynamicObject realCard = row.getDynamicObject("realcard1");
            String[] split = field.split("\\.");
            DynamicObject card = "fa_card_real".equals(split[0]) ? realCard : finCard;
            DynamicProperty prop = card.getDynamicObjectType().getProperty(split[1]);
            String initBackField = changeItemMap.get(field);
            log.info("getChangeInfo: queryOne -> entityName\uff1a{}; selectFields:{}; filters:{}", new Object[]{split[0], initBackField, JSON.toJSONString((Object)new QFilter("id", "=", card.getPkValue()))});
            card = QueryServiceHelper.queryOne((String)split[0], (String)initBackField, (QFilter[])new QFilter("id", "=", card.getPkValue()).toArray());
            if (prop instanceof DecimalProp) {
                BigDecimal init = card.getBigDecimal(initBackField);
                firstChange = FaCardInitFieldUtil.INIT_DECIMAL_VAL.compareTo(init) == 0;
            } else {
                if (!(prop instanceof BasedataProp)) continue;
                long init = card.getLong(initBackField);
                boolean bl = firstChange = init == -1L;
            }
            if (!firstChange) continue;
            long realCardId = realCard.getLong("id");
            long finCardId = finCard.getLong("id");
            changeInfoSet.add(new ChangeInfo(realCardId, finCardId, field));
        }
        return changeInfoSet;
    }

    private void updateInitFields(DynamicObject entity, Map<String, String> changeItemMap, Set<ChangeInfo> changeInfoSet) {
        HashSet<Long> realCardIds = new HashSet<Long>(changeInfoSet.size());
        HashSet<Long> finCardIds = new HashSet<Long>(changeInfoSet.size());
        for (ChangeInfo changeInfo : changeInfoSet) {
            String field = changeInfo.getField();
            String[] splitField = field.split("\\.");
            if ("fa_card_real".equals(splitField[0])) {
                realCardIds.add(changeInfo.getRealCardId());
                continue;
            }
            finCardIds.add(changeInfo.getFinCardId());
        }
        DynamicObject[] realCards = BusinessDataServiceHelper.load((Object[])realCardIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"fa_card_real"));
        Map<Long, DynamicObject> realCard4Update = Arrays.stream(realCards).collect(Collectors.toMap(v -> v.getLong("id"), v -> v));
        DynamicObject[] finCards = BusinessDataServiceHelper.load((Object[])finCardIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"fa_card_fin"));
        Map<Long, DynamicObject> finCard4Update = Arrays.stream(finCards).collect(Collectors.toMap(v -> v.getLong("id"), v -> v));
        DynamicObjectCollection fieldEntry = entity.getDynamicObjectCollection("fieldentry");
        for (DynamicObject row : fieldEntry) {
            String field;
            long finCardId;
            long realCardId = row.getLong(Fa.id((String)"realcard1"));
            ChangeInfo changeInfo = new ChangeInfo(realCardId, finCardId = row.getLong(Fa.id((String)"fincard1")), field = row.getString("field"));
            if (!changeInfoSet.contains(changeInfo)) continue;
            String[] split = field.split("\\.");
            DynamicObject card = "fa_card_real".equals(split[0]) ? realCard4Update.get(realCardId) : finCard4Update.get(finCardId);
            String beforeValueStr = row.getString("beforevalue");
            Object beforeValue = FaChangeBillUtil.parseValue((DynamicObjectType)card.getDynamicObjectType(), (String)split[1], (String)beforeValueStr);
            String initBackField = changeItemMap.get(field);
            card.set(initBackField, beforeValue);
        }
        if (!realCard4Update.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])realCard4Update.values().toArray(new DynamicObject[0]));
        }
        if (!finCard4Update.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])finCard4Update.values().toArray(new DynamicObject[0]));
        }
    }

    private void updateFinCardNeedDepre4WorkloadChg(DynamicObject[] changeBills) {
        HashSet<Long> workloadChgFinIds = new HashSet<Long>(16);
        for (DynamicObject changeBill : changeBills) {
            DynamicObject changeType = changeBill.getDynamicObject("changetype");
            boolean isSysPreDepreMethod4Workload = FaChangeTypeUtils.isSystemPreDepreMethodChg4Workload((DynamicObject)changeType);
            if (!isSysPreDepreMethod4Workload) continue;
            DynamicObjectCollection realEntries = changeBill.getDynamicObjectCollection("realentry");
            for (DynamicObject realEntry : realEntries) {
                DynamicObjectCollection finEntries = realEntry.getDynamicObjectCollection("finentry");
                for (DynamicObject finEntry : finEntries) {
                    DynamicObject finCard = finEntry.getDynamicObject("fincard");
                    if (finCard == null) continue;
                    workloadChgFinIds.add(finCard.getLong("id"));
                }
            }
        }
        if (CollectionUtils.isNotEmpty(workloadChgFinIds)) {
            SqlBuilder updateSql = new SqlBuilder();
            updateSql.append("update t_fa_card_fin set fisneeddepre = '1' where ", new Object[0]);
            updateSql.appendIn(" fid ", (Object[])workloadChgFinIds.toArray(new Long[0]));
            DB.execute((DBRoute)DBRoute.of((String)"fa"), (SqlBuilder)updateSql);
        }
    }
}

