/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.changebill;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.fa.business.depreciation.ChangeBillStrategy;
import kd.fi.fa.business.enums.BusyTypeDetailEnum;
import kd.fi.fa.business.utils.FaChangeBillUtil;
import kd.fi.fa.business.utils.FaDepreUtil;
import kd.fi.fa.business.utils.PeriodUtil;
import kd.fi.fa.business.utils.SystemParamHelper;
import kd.fi.fa.cache.CacheHelper;
import kd.fi.fa.cache.CacheModule;
import kd.fi.fa.cache.DistributeCache;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.utils.FaOpUtils;

public class FaChangeBillAuditValidator
extends AbstractValidator {
    private static final Log log = LogFactory.getLog(FaChangeBillAuditValidator.class);

    public void validate() {
        HashSet<Long> affectDepreOrgIds = new HashSet<Long>(16);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject bill = dataEntity.getDataEntity();
            affectDepreOrgIds.add(bill.getLong("org.id"));
        }
        HashMap<String, Long> orgIdDepreUseIdCurPeriodId = new HashMap<String, Long>(16);
        QFilter orgFilter = new QFilter("org", "in", affectDepreOrgIds);
        DynamicObjectCollection assetBookList = QueryServiceHelper.query((String)"fa_assetbook", (String)"org,depreuse,curperiod", (QFilter[])new QFilter[]{orgFilter});
        for (ExtendedDataEntity[] assetBook : assetBookList) {
            orgIdDepreUseIdCurPeriodId.put(assetBook.getLong("org") + "_" + assetBook.getLong("depreuse"), assetBook.getLong("curperiod"));
        }
        HashMap<String, Boolean> orgIdDepreUseIdPeriodId2haVoucher = new HashMap<String, Boolean>(16);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            try {
                DynamicObject bill = dataEntity.getDataEntity();
                DynamicObjectCollection changeFieldEntry = bill.getDynamicObjectCollection("fieldentry");
                BusyTypeDetailEnum changeTypeDetail = FaChangeBillUtil.getChangeTypeDetail((DynamicObjectCollection)changeFieldEntry);
                FaOpUtils.checkDoOperable(dataEntity.getDataEntity(), "realentry", "realcard.masterid", "fa_change_dept", changeTypeDetail);
                long orgId = ((DynamicObject)dataEntity.getValue("org")).getLong("id");
                OperateOption option = this.getOption();
                Date changeDate = (Date)dataEntity.getValue("changedate");
                for (DynamicObject bf : changeFieldEntry) {
                    Object sourceflag = bf.getDynamicObject("realcard1").get("sourceflag");
                    long depreuseId = bf.getDynamicObject("fincard1").getLong("depreuse.id");
                    if (sourceflag == null || !"DISPATCH".equals(sourceflag)) continue;
                    Date bizdata = bf.getDate("bizdate1");
                    long bizPeriod = PeriodUtil.getBizPeriodPK((Object)orgId, (Date)bizdata, (Long)depreuseId);
                    DynamicObject fincard = bf.getDynamicObject("fincard1");
                    Date date = fincard.getDate("finaccountdate");
                    long finaccountdatePeriod = PeriodUtil.getBizPeriodPK((Object)orgId, (Date)date, (Long)depreuseId);
                    if (bizPeriod >= finaccountdatePeriod) continue;
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8c03\u62e8\u751f\u6210\u7684\u5361\u7247\u505a\u672a\u6765\u9002\u7528\u53d8\u66f4\u65f6\uff0c\u4e1a\u52a1\u65e5\u671f\u5bf9\u5e94\u671f\u95f4\u4e0d\u5f97\u65e9\u4e8e\u8d22\u52a1\u5165\u8d26\u65e5\u671f\u5bf9\u5e94\u671f\u95f4\u3002", (String)"FaChangeBillAuditValidator_0", (String)"fi-fa-opplugin", (Object[])new Object[0]));
                }
                Map<Object, List<DynamicObject>> grp = changeFieldEntry.stream().filter(v -> ChangeBillStrategy.getDepreFieldSet().contains(v.getString("field"))).collect(Collectors.groupingBy(v -> v.get("depreuse1_id")));
                Set<Map.Entry<Object, List<DynamicObject>>> entrySet = grp.entrySet();
                ExtendedDataEntity[] filter = null;
                HashMap realId2NumberMap = new HashMap(16);
                for (Map.Entry<Object, List<DynamicObject>> entry : entrySet) {
                    Object depreuseId = entry.getKey();
                    Set realIds = entry.getValue().stream().map(v -> {
                        DynamicObject realCard = v.getDynamicObject("realcard1");
                        Long realId = realCard.getLong("id");
                        String number = realCard.getString("number");
                        realId2NumberMap.put(realId, number);
                        return realId;
                    }).collect(Collectors.toSet());
                    if (filter == null) {
                        filter = new QFilter("depreuse", "=", depreuseId).and(Fa.dot((String[])new String[]{"entryentity", "realcard"}), "in", realIds);
                        continue;
                    }
                    filter = filter.or(new QFilter("depreuse", "=", depreuseId).and(Fa.dot((String[])new String[]{"entryentity", "realcard"}), "in", realIds));
                }
                if (filter != null) {
                    QFilter[] filters = new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("period.begindate", "<=", (Object)changeDate), new QFilter("period.enddate", ">=", (Object)changeDate), filter};
                    DynamicObjectCollection existDepreAdjustEntities = QueryServiceHelper.query((String)"fa_depreadjustbill", (String)Fa.comma((String[])new String[]{Fa.dot((String[])new String[]{"entryentity", "realcard"})}), (QFilter[])filters);
                    HashSet existDepreAdjustCardNumbers = new HashSet();
                    if (existDepreAdjustEntities != null && !existDepreAdjustEntities.isEmpty()) {
                        for (DynamicObject existEntry : existDepreAdjustEntities) {
                            Long realId = existEntry.getLong(Fa.dot((String[])new String[]{"entryentity", "realcard"}));
                            existDepreAdjustCardNumbers.add(realId2NumberMap.get(realId));
                        }
                    }
                    if (CollectionUtils.isNotEmpty(existDepreAdjustCardNumbers)) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5361\u7247\uff08\u7f16\u7801\uff1a%s\uff09\u672c\u671f\u5df2\u5b58\u5728\u6298\u65e7\u8c03\u6574\uff0c\u4e0d\u5141\u8bb8\u505a\u5f71\u54cd\u6298\u65e7\u7684\u53d8\u66f4\u3002", (String)"FaChangeBillAuditValidator_1", (String)"fi-fa-opplugin", (Object[])new Object[0]), existDepreAdjustCardNumbers.stream().collect(Collectors.joining(","))));
                    }
                }
                HashSet<Long> depreUseIdSet = new HashSet<Long>(3);
                for (DynamicObject bf : changeFieldEntry) {
                    long depreuseId = bf.getDynamicObject("fincard1").getLong("depreuse.id");
                    depreUseIdSet.add(depreuseId);
                }
                for (Long depreUseId : depreUseIdSet) {
                    Long curPeriodId = (Long)orgIdDepreUseIdCurPeriodId.get(orgId + "_" + depreUseId);
                    StringBuilder sb = new StringBuilder();
                    sb.append(orgId).append("_").append(depreUseId).append("_").append(curPeriodId);
                    boolean isHasvoucher = false;
                    if (orgIdDepreUseIdPeriodId2haVoucher.get(sb.toString()) != null) {
                        isHasvoucher = (Boolean)orgIdDepreUseIdPeriodId2haVoucher.get(sb.toString());
                    } else {
                        isHasvoucher = FaDepreUtil.hasVoucher((Long)orgId, (Long)depreUseId, (Long)curPeriodId, (boolean)Boolean.FALSE);
                        orgIdDepreUseIdPeriodId2haVoucher.put(sb.toString(), isHasvoucher);
                    }
                    if (!isHasvoucher) continue;
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u540e\u7eed\u671f\u95f4\u6298\u65e7\u6c47\u603b\u5df2\u751f\u6210\u51ed\u8bc1\uff0c\u64cd\u4f5c\u5931\u8d25\u3002", (String)"FaChangeBillAuditValidator_2", (String)"fi-fa-opplugin", (Object[])new Object[0]));
                }
            }
            catch (Exception e) {
                log.error("\u53d8\u66f4\u5355\u5ba1\u6838\u5b58\u5728\u9519\u8bef\uff1a", (Throwable)e);
                this.addMessage(dataEntity, e.getMessage(), ErrorLevel.Error);
            }
        }
        Boolean hasChange = false;
        DistributeCache distributeCache = CacheHelper.getDistributeCache((CacheModule)CacheModule.haschangeitem);
        QFilter originalvalFilter = new QFilter("number", "=", (Object)"originalval").and(new QFilter("topic", "=", (Object)"fa_card_fin"));
        QFilter preresidualvalFilter = new QFilter("number", "=", (Object)"preresidualval").and(new QFilter("topic", "=", (Object)"fa_card_fin"));
        QFilter preusingamountFilter = new QFilter("number", "=", (Object)"preusingamount").and(new QFilter("topic", "=", (Object)"fa_card_fin"));
        QFilter usestatusFilter = new QFilter("number", "=", (Object)"usestatus").and(new QFilter("topic", "=", (Object)"fa_card_real"));
        QFilter depremethodFilter = new QFilter("number", "=", (Object)"depremethod").and(new QFilter("topic", "=", (Object)"fa_card_fin"));
        QFilter realaccountdateFilter = new QFilter("number", "=", (Object)"realaccountdate").and(new QFilter("topic", "=", (Object)"fa_card_real"));
        QFilter filter = originalvalFilter.or(preresidualvalFilter).or(preusingamountFilter).or(usestatusFilter).or(depremethodFilter).or(realaccountdateFilter);
        DynamicObjectCollection depreChangeItems = QueryServiceHelper.query((String)"fa_change_item", (String)"id,number,topic", (QFilter[])filter.toArray());
        distributeCache.put("deprechangeitems", SerializationUtils.serializeToBase64((Object)depreChangeItems));
        HashMap<Long, Boolean> orgId2SumMutilVou = new HashMap<Long, Boolean>(this.dataEntities.length);
        ArrayList<Long> changeids = new ArrayList<Long>(this.dataEntities.length);
        ArrayList<Long> itemids = new ArrayList<Long>(this.dataEntities.length);
        for (ExtendedDataEntity dataEntry : this.dataEntities) {
            DynamicObject dataEntity = dataEntry.getDataEntity();
            Long orgId = dataEntity.getLong("org.id");
            if (orgId == null) continue;
            boolean enableSumMutilVoucher = false;
            if (orgId2SumMutilVou.get(orgId) != null) {
                enableSumMutilVoucher = (Boolean)orgId2SumMutilVou.get(orgId);
            } else {
                enableSumMutilVoucher = SystemParamHelper.getBooleanParam((String)"enable_sum_mutil_voucher", (long)orgId, (boolean)false);
                orgId2SumMutilVou.put(orgId, enableSumMutilVoucher);
            }
            if (enableSumMutilVoucher) continue;
            long cid = dataEntity.getLong("changetype_id");
            itemids.add(cid);
            Long id = Long.parseLong(dataEntity.getPkValue().toString());
            changeids.add(id);
        }
        if (changeids.size() == 0) {
            return;
        }
        Set depreChgItemIds = depreChangeItems.stream().map(v -> v.get("id")).collect(Collectors.toSet());
        DynamicObjectCollection changeItems = QueryServiceHelper.query((String)"fa_change_type", (String)"changetypeentry.changeitem changeitem", (QFilter[])new QFilter("id", "in", itemids).toArray());
        Set chgItemIds = changeItems.stream().map(v -> v.get("changeitem")).collect(Collectors.toSet());
        HashSet depreChgItemCopy = new HashSet(depreChgItemIds);
        depreChgItemCopy.retainAll(chgItemIds);
        if (!depreChgItemCopy.isEmpty()) {
            hasChange = true;
        }
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"fa_change_dept", (String)"org.id,changedate,fieldentry.depreuse1,fieldentry.isadjustdepre1,fieldentry.realcard1,fieldentry.field,fieldentry.bizdate1", (QFilter[])new QFilter[]{new QFilter("id", "in", changeids)});
        if (hasChange.booleanValue()) {
            ArrayList<String> os = new ArrayList<String>();
            for (DynamicObject cc : load) {
                long orgid = cc.getLong("org.id");
                Date cd = cc.getDate("changedate");
                DynamicObjectCollection main = cc.getDynamicObjectCollection("fieldentry");
                for (DynamicObject cm : main) {
                    String field = cm.getString("field");
                    String[] split = field.split("\\.");
                    if (!split[0].equals("fa_card_real") || split[1].equals("usestatus")) {
                        cd = cm.getDate("bizdate1").before(cd) ? cd : cm.getDate("bizdate1");
                    }
                    long depre = cm.getLong("depreuse1.id");
                    Long period = this.getPeriod(orgid, depre, cd);
                    os.add(orgid + ":" + depre + ":" + period);
                }
            }
            List collect = os.stream().distinct().collect(Collectors.toList());
            collect.stream().forEach(v -> {
                boolean exists;
                DynamicObject cc;
                String[] split = v.split(":");
                if (split.length > 0 && (cc = BusinessDataServiceHelper.loadSingleFromCache((String)"fa_depre_sum", (String)"number,id", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)Long.valueOf(split[0])), new QFilter("depreuse", "=", (Object)Long.valueOf(split[1])), new QFilter("period", "=", (Object)Long.valueOf(split[2]))})) != null && (exists = QueryServiceHelper.exists((String)"ai_daptracker", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "=", (Object)cc.getLong("id"))}))) {
                    this.addErrorMessage(this.dataEntities[0], ResManager.loadKDString((String)"\u5ba1\u6838\u7684\u53d8\u66f4\u5355\u5b58\u5728\u5f53\u671f\u6298\u65e7\u6c47\u603b\u5df2\u751f\u6210\u51ed\u8bc1\uff0c\u4e0d\u5141\u8bb8\u505a\u5f71\u54cd\u6298\u65e7\u4ee5\u53ca\u5206\u644a\u7ef4\u5ea6\u7684\u53d8\u66f4\u3002", (String)"FaChangeBillAuditValidator_3", (String)"fi-fa-opplugin", (Object[])new Object[0]));
                }
            });
        }
    }

    public Long getPeriod(Long orgId, Long depreuseId, Date bizdate) {
        QFilter filterOrg = new QFilter("org", "=", (Object)orgId);
        QFilter filterDepreuse = new QFilter("depreuse", "=", (Object)depreuseId);
        DynamicObject assetbook = BusinessDataServiceHelper.loadSingle((String)"fa_assetbook", (String)"periodtype", (QFilter[])new QFilter[]{filterOrg, filterDepreuse});
        if (assetbook == null) {
            return null;
        }
        QFilter periodtype = new QFilter("periodtype", "=", (Object)assetbook.getLong("periodtype.id"));
        QFilter periodbegin = new QFilter("begindate", "<=", (Object)bizdate);
        QFilter periodend = new QFilter("enddate", ">=", (Object)bizdate);
        DynamicObject periodDate = BusinessDataServiceHelper.loadSingle((String)"bd_period", (String)"id,number", (QFilter[])new QFilter[]{periodtype, periodbegin, periodend});
        if (periodDate == null) {
            return null;
        }
        return Long.parseLong(periodDate.getPkValue().toString());
    }
}

