/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.changebill;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.fi.fa.business.dao.factory.FaAssetBookDaoFactory;
import kd.fi.fa.business.enums.BusyTypeDetailEnum;
import kd.fi.fa.business.enums.FutureChangeTypeEnum;
import kd.fi.fa.business.utils.FaBillParamUtils;
import kd.fi.fa.business.utils.FaBizUtils;
import kd.fi.fa.business.utils.FaChangeBillUtil;
import kd.fi.fa.business.utils.SystemParamHelper;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.utils.FaOpUtils;

public class FaChangeBillFeatureValidator
extends AbstractValidator {
    private static Set<String> excludeItemSet = new HashSet<String>(2, 1.0f);
    private static Set<String> futureParameterSet = new HashSet<String>(2, 1.0f);

    public void validate() {
        String billParamV = FaBillParamUtils.queryOne(null, null, null, (String)"FUTURE_CHANG_TYPE", (String)"1");
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            Set billNumbers;
            DynamicObject changeBill = dataEntity.getDataEntity();
            String bookNames = FaOpUtils.checkAssetBookDate(dataEntity.getDataEntity(), "org", "changedate");
            DynamicObject bill = dataEntity.getDataEntity();
            DynamicObjectCollection changeFieldEntry = bill.getDynamicObjectCollection("fieldentry");
            BusyTypeDetailEnum changeTypeDetail = FaChangeBillUtil.getChangeTypeDetail((DynamicObjectCollection)changeFieldEntry);
            Long orgId2 = changeBill.getDynamicObject("org").getLong("id");
            String fuChSysPara = SystemParamHelper.getStringParam((String)"futurechangesystemparameter", (long)orgId2, (String)"1");
            if (!bookNames.isEmpty()) {
                boolean include;
                if (!changeTypeDetail.name().equals(BusyTypeDetailEnum.REAL_CHG.name()) || changeTypeDetail.name().equals(BusyTypeDetailEnum.REAL_CHG.name()) && fuChSysPara.equals(FutureChangeTypeEnum.ONE.getValue()) && !futureParameterSet.contains(billParamV)) {
                    String msgCaption = ResManager.loadKDString((String)"\u8bb0\u8d26\u65e5\u671f\u4e0d\u5728\u8d26\u7c3f\u5f53\u524d\u671f\u95f4", (String)"FaChangeBillFeatureValidator_0", (String)"fi-fa-opplugin", (Object[])new Object[0]);
                    this.addErrorMessage(dataEntity, String.format("%s:%s", msgCaption, bookNames));
                    continue;
                }
                Long orgId = changeBill.getDynamicObject("org").getLong("id");
                DynamicObject assetBook = FaBizUtils.checkAllBooksCurPeriod((Long)orgId);
                if (assetBook == null) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u5bf9\u5e94\u7684\u8d26\u7c3f\u5f53\u524d\u671f\u95f4\u4e0d\u4e00\u81f4\u3002", (String)"FaChangeBillFeatureValidator_1", (String)"fi-fa-opplugin", (Object[])new Object[0]));
                    continue;
                }
                Date startDate = assetBook.getDate("begindate");
                Date changeDate = changeBill.getDate("changedate");
                if (changeDate != null && changeDate.before(startDate)) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bb0\u8d26\u65e5\u671f\u65e9\u4e8e\u8d26\u7c3f\u5f53\u524d\u671f\u95f4\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c", (String)"FaChangeBillFeatureValidator_2", (String)"fi-fa-opplugin", (Object[])new Object[0]));
                    continue;
                }
                if (fuChSysPara.equals(FutureChangeTypeEnum.ONE.getValue()) && (!futureParameterSet.contains(billParamV) || FaBillParamUtils.queryOne((Long)orgId, (Long)0L, (String)"", (String)"FUTURE_CHANG_ORGIDS") == null)) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bb0\u8d26\u65e5\u671f\u5728\u672a\u6765\u671f\u95f4\uff0c\u7cfb\u7edf\u53c2\u6570\"\u672a\u6765\u5b9e\u7269\u4e1a\u52a1\"\u672a\u5f00\u542f\uff0c\u4e0d\u652f\u6301\u505a\u672a\u6765\u5b9e\u7269\u4e1a\u52a1\u3002", (String)"FaChangeBillFeatureValidator_3", (String)"fi-fa-opplugin", (Object[])new Object[0]));
                    continue;
                }
                if ((fuChSysPara.equals(FutureChangeTypeEnum.ONE.getValue()) && futureParameterSet.contains(billParamV) || futureParameterSet.contains(fuChSysPara)) && (include = FaChangeBillUtil.checkChangeItemIn((DynamicObjectCollection)changeFieldEntry, excludeItemSet))) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u672a\u6765\u5b9e\u7269\u53d8\u66f4\u4e0d\u80fd\u5305\u542b\u542f\u7528\u65e5\u671f\u3001\u4f7f\u7528\u72b6\u6001\u4e24\u4e2a\u53d8\u66f4\u9879\u3002", (String)"FaChangeBillFeatureValidator_4", (String)"fi-fa-opplugin", (Object[])new Object[0]));
                    continue;
                }
            }
            DynamicObject assetBook = FaAssetBookDaoFactory.getInstance().queryMainBookByOrg((Object)orgId2);
            DynamicObject curPeriodDy = assetBook.getDynamicObject("curperiod");
            Date endDate = curPeriodDy.getDate("enddate");
            DynamicObjectCollection fieldEntry = changeBill.getDynamicObjectCollection("fieldentry");
            HashMap<Long, String> realId2numberMap = new HashMap<Long, String>(fieldEntry.size(), 1.0f);
            for (DynamicObject fieldEntryDy : fieldEntry) {
                realId2numberMap.put(fieldEntryDy.getLong(Fa.id((String)"realcard1")), fieldEntryDy.getString("realcard1.number"));
            }
            Set billNos = FaChangeBillUtil.getGenVoucherChangeBillNo((Long)orgId2, (Date)endDate, realId2numberMap.keySet());
            if (billNos != null && billNos.size() > 0) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5361\u7247\u5728\u672a\u6765\u5b9e\u7269\u4e1a\u52a1\u53d8\u66f4\u5355%s\u5df2\u751f\u6210\u51ed\u8bc1\u3002", (String)"FaChangeBillFeatureValidator_5", (String)"fi-fa-opplugin", (Object[])new Object[0]), billNos.toString()));
            }
            if (!changeTypeDetail.name().equals(BusyTypeDetailEnum.FIN_CHG.name()) || (billNumbers = FaChangeBillUtil.checkhaveFutureRealChangeBill((Long)orgId2, (Date)endDate, realId2numberMap)) == null || billNumbers.size() <= 0) continue;
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5361\u7247\u7f16\u7801%s\u5b58\u5728\u672a\u6765\u5b9e\u7269\u4e1a\u52a1\uff0c\u5f00\u542f\"\u672a\u6765\u5b9e\u7269\u4e1a\u52a1\"\u76f8\u5e94\u53c2\u6570\u6216\u5220\u9664\u672a\u6765\u5b9e\u7269\u4e1a\u52a1\u3002", (String)"FaChangeBillFeatureValidator_6", (String)"fi-fa-opplugin", (Object[])new Object[0]), billNumbers.toString()));
        }
    }

    static {
        excludeItemSet.add("realaccountdate");
        excludeItemSet.add("usestatus");
        futureParameterSet.add(FutureChangeTypeEnum.TWO.getValue());
        futureParameterSet.add(FutureChangeTypeEnum.THREE.getValue());
    }
}

