/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.changebill;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.common.util.FaChangeItemUtil;

public class FaChangeBillLeaseCardValidator
extends AbstractValidator {
    private static final List<String> LEASE_FLAG = Arrays.asList("LEASECONTRACT", "INITLEASECONTRACT");

    public void validate() {
        HashSet<String> existsMappingFields = new HashSet<String>(10);
        DynamicObject[] dbChangeItems = null;
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            QFilter qFilter;
            DynamicObject changeBill = dataEntity.getDataEntity();
            String sourceType = changeBill.getString("sourcetype");
            if ("4".equals(sourceType)) continue;
            if (dbChangeItems == null && ((dbChangeItems = BusinessDataServiceHelper.load((String)"fa_change_item", (String)"id,number,topic", (QFilter[])new QFilter[]{qFilter = new QFilter("topic", "in", (Object)new String[]{"fa_card_real", "fa_card_fin"})})) == null || dbChangeItems.length == 0)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u53ef\u53d8\u66f4\u9879\u76ee\u6570\u636e\u5f02\u5e38\u3002", (String)"FaChangeBillLeaseCardValidator_0", (String)"fi-fa-opplugin", (Object[])new Object[0]));
            }
            DynamicObjectCollection fieldEntryColl = changeBill.getDynamicObjectCollection("fieldentry");
            for (DynamicObject fieldEntry : fieldEntryColl) {
                DynamicObject realCard = fieldEntry.getDynamicObject("realcard1");
                String sourceFlag = realCard.getString("sourceflag");
                String field = fieldEntry.getString("field");
                if (!LEASE_FLAG.contains(sourceFlag)) continue;
                if (existsMappingFields.isEmpty()) {
                    DynamicObjectCollection changeItemMaps = QueryServiceHelper.query((String)"fa_change_map", (String)"id,leasechgitem,cardchgitem", (QFilter[])new QFilter[0]);
                    Set cardChangeMapItems = changeItemMaps.stream().map(t -> t.get("cardchgitem")).collect(Collectors.toSet());
                    for (DynamicObject item : dbChangeItems) {
                        String key = item.getString("topic") + "." + item.getString("number");
                        if (!cardChangeMapItems.contains(item.getPkValue())) continue;
                        existsMappingFields.add(key);
                    }
                }
                if (!existsMappingFields.contains(field) && !FaChangeItemUtil.leaseCardChangeItemHide().contains(field)) continue;
                String number = realCard.getString("number");
                String changeFiled = field.split("\\.")[1];
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u8d44\u4ea7\u7f16\u7801\uff1a%1$s\u7684%2$s\u5b57\u6bb5\u53ea\u80fd\u901a\u8fc7\u79df\u8d41\u53d8\u66f4\u8fdb\u884c\u53d8\u66f4\u3002", (String)"FaChangeBillLeaseCardValidator_1", (String)"fi-fa-opplugin", (Object[])new Object[0]), number, changeFiled));
            }
        }
    }
}

