/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.changebill;

import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.fa.business.utils.ChangeBillUtils;

public class FaChangeBillSubmitCompFieldValidator
extends AbstractValidator {
    private static Log log = LogFactory.getLog(FaChangeBillSubmitCompFieldValidator.class);

    public void validate() {
        String kdErrorStr = ResManager.loadKDString((String)"\u8d44\u4ea7\u7f16\u7801[%1$s]\u5c5e\u6027[%2$s]\u53d8\u66f4\u524d\u503c\u4e0e\u5361\u7247\u4e2d\u7684\u503c\u4e0d\u4e00\u81f4\uff0c\u8bf7\u6838\u5bf9\u662f\u5426\u505a\u4e86\u5176\u5b83\u4e1a\u52a1\u3002", (String)"FaChangeBillSubmitCompFieldValidator_0", (String)"fi-fa-opplugin", (Object[])new Object[0]);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            try {
                DynamicObject bill = dataEntity.getDataEntity();
                DynamicObjectCollection changeFieldEntry = bill.getDynamicObjectCollection("fieldentry");
                StringBuilder oneErrMsgBf = new StringBuilder();
                for (DynamicObject bf : changeFieldEntry) {
                    DynamicObject realcard = bf.getDynamicObject("realcard1");
                    DynamicObject fincard = bf.getDynamicObject("fincard1");
                    String field = bf.getString("field");
                    boolean flag = false;
                    if (!ChangeBillUtils.isPresetField((String)field)) continue;
                    String[] split = field.split("\\.");
                    DynamicObject card = "fa_card_real".equals(split[0]) ? realcard : fincard;
                    DynamicProperty prop = card.getDynamicObjectType().getProperty(split[1]);
                    String number = realcard.getString("number");
                    String propDisplayNmae = prop.getDisplayName().getLocaleValue();
                    if (prop instanceof DecimalProp) {
                        int compare = card.getBigDecimal(split[1]).compareTo(bf.getBigDecimal("beforevalue"));
                        if (compare != 0) {
                            flag = true;
                        }
                    } else if (prop instanceof BasedataProp) {
                        if (card.getLong(split[1] + "." + "id") != bf.getLong("beforevalue")) {
                            flag = true;
                        }
                    } else if (prop instanceof DateProp) {
                        Date cardDate = card.getDate(split[1]);
                        Date bfCardDate = bf.getDate("beforevalue");
                        FaChangeBillSubmitCompFieldValidator.resetDateHMS2Zero(cardDate);
                        FaChangeBillSubmitCompFieldValidator.resetDateHMS2Zero(bfCardDate);
                        int compare = cardDate.compareTo(bfCardDate);
                        if (compare != 0) {
                            flag = true;
                        }
                    }
                    if (!flag) continue;
                    oneErrMsgBf.append(String.format(kdErrorStr, number, propDisplayNmae)).append("\n");
                }
                if (!StringUtils.isNotEmpty((CharSequence)oneErrMsgBf)) continue;
                this.addErrorMessage(dataEntity, oneErrMsgBf.toString());
            }
            catch (Exception e) {
                this.addMessage(dataEntity, e.getMessage(), ErrorLevel.Error);
            }
        }
    }

    private static void resetDateHMS2Zero(Date date) {
        date.setHours(0);
        date.setMinutes(0);
        date.setSeconds(0);
    }
}

