/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.changebill;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.business.BizStatusEnum;
import kd.fi.fa.business.dao.factory.FaBaseDaoFactory;
import kd.fi.fa.business.depreciation.ChangeBillStrategy;
import kd.fi.fa.business.merge.impl.FaMergeBillServiceImpl;
import kd.fi.fa.business.utils.AssetPolicyUtil;
import kd.fi.fa.business.utils.FaBizUtils;
import kd.fi.fa.business.utils.FaChangeBillUtil;
import kd.fi.fa.business.utils.FaChangeTypeUtils;
import kd.fi.fa.business.utils.FaPeriodUtils;
import kd.fi.fa.business.utils.FaUtils;
import kd.fi.fa.business.utils.PeriodUtil;
import kd.fi.fa.business.utils.SystemParamHelper;
import kd.fi.fa.common.util.DateUtil;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.common.util.Tuple;
import kd.fi.fa.opplugin.FaMigrateDateValidator;
import kd.fi.fa.opplugin.changebill.FaChangeBillSaveOp;
import kd.fi.fa.opplugin.changebill.FaChangeBillSubmitCompFieldValidator;
import kd.fi.fa.opplugin.changebill.FaChangeBillSubmitValidator;
import kd.fi.fa.opplugin.changebill.validator.FaChangeBillAboutReStartRealBillValidator;
import kd.fi.fa.opplugin.changebill.validator.FaChangeBillAboutSplitBillValidator;
import kd.fi.fa.opplugin.changebill.validator.FaChangeCheckMustValidator;

public class FaChangeBillSubmitOp
extends FaChangeBillSaveOp {
    private static Log log = LogFactory.getLog(FaChangeBillSubmitOp.class);
    private static final SimpleDateFormat DATE_PATTERN = new SimpleDateFormat("yyyy-MM-dd");
    private final List<ChangeBillPOJO> changeBillPojoLst = new ArrayList<ChangeBillPOJO>();
    private static final String[] CAN_IS_ADJUSTDEPRE = new String[]{"preusingamount", "depremethod", "originalval", "preresidualval", "realaccountdate", "usestatus"};

    @Override
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fields = e.getFieldKeys();
        fields.addAll(this.billEntityType.getAllFields().keySet());
        fields.add(Fa.dot((String[])new String[]{"realentry", "finentry", "seq"}));
        fields.add(Fa.dot((String[])new String[]{"fieldentry", "fincard1", "addidepreamount"}));
    }

    @Override
    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new FaMigrateDateValidator());
        e.addValidator((AbstractValidator)new FaChangeBillSubmitValidator());
        e.addValidator(new AbstractValidator(){

            public void validate() {
                Boolean noChangeFalg = false;
                ArrayList<Long> orgIds = new ArrayList<Long>(this.dataEntities.length);
                List orgIdList = Arrays.stream(this.dataEntities).map(v -> v.getDataEntity().getLong(Fa.id((String)"org"))).collect(Collectors.toList());
                Map changeEmptyParam = SystemParamHelper.getChangeEmptyParam(orgIdList);
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    DynamicObject bill = dataEntity.getDataEntity();
                    DynamicObject org = bill.getDynamicObject("org");
                    long orgId = org.getLong("id");
                    orgIds.add(orgId);
                    boolean changeNo = org != null && (Boolean)changeEmptyParam.get(org.getLong("id")) != false;
                    String billStatus = bill.getString("billstatus");
                    if ("C".equals(billStatus)) continue;
                    Map<Long, List<DynamicObject>> changeMap = FaChangeBillSubmitOp.getCardChangeMap(bill);
                    if (changeMap.size() == 0) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u53d8\u66f4\u524d\u540e\u7684\u503c\u6ca1\u6709\u53d8\u5316\u3002", (String)"FaChangeBillSubmitOp_0", (String)"fi-fa-opplugin", (Object[])new Object[0]));
                        noChangeFalg = true;
                    }
                    OperateOption option = this.getOption();
                    boolean ignoreChangeFlag = option.containsVariable("IGNORE_CHANGE");
                    boolean ignoreChange = false;
                    if (ignoreChangeFlag && "true".equalsIgnoreCase(option.getVariableValue("IGNORE_CHANGE"))) {
                        ignoreChange = true;
                    }
                    if (ignoreChange) continue;
                    ArrayList<String> errCard = new ArrayList<String>();
                    for (Map.Entry<Long, List<DynamicObject>> kv : changeMap.entrySet()) {
                        String cardInfo = FaChangeBillSubmitOp.this.checkChangeStatus(kv.getValue(), changeNo);
                        if (cardInfo.isEmpty()) continue;
                        errCard.add(cardInfo);
                        noChangeFalg = true;
                    }
                    if (errCard.size() <= 0) continue;
                    this.addErrorMessage(dataEntity, String.format("%s:%s", ResManager.loadKDString((String)"\u53d8\u66f4\u524d\u540e\u7684\u503c\u6ca1\u6709\u53d8\u5316", (String)"FaChangeBillSubmitOp_1", (String)"fi-fa-opplugin", (Object[])new Object[0]), String.join((CharSequence)",", errCard)));
                }
                if (noChangeFalg.booleanValue()) {
                    return;
                }
                Map orgToCompareDate = FaChangeBillSubmitOp.this.getCompareDate(orgIds);
                Map orgDepreuseId2EnablePeriodBeginDateMap = FaPeriodUtils.getStartPeriodBeginDateByOrgIds(orgIds.stream().collect(Collectors.toSet()));
                HashSet<Long> assetCateIds = new HashSet<Long>(16);
                String selectFields = Fa.comma((String[])new String[]{"topic", "number"});
                QFilter[] changeItemFilters = new QFilter[]{new QFilter("isgenvoucher", "=", (Object)Boolean.TRUE), new QFilter("ischange", "=", (Object)Boolean.FALSE), new QFilter("enable", "=", (Object)Boolean.TRUE)};
                DynamicObjectCollection changeItems = QueryServiceHelper.query((String)"fa_change_item", (String)selectFields, (QFilter[])changeItemFilters);
                Set notAllowedChangeItems = changeItems.stream().map(v -> Fa.dot((String[])new String[]{v.getString("topic"), v.getString("number")})).collect(Collectors.toSet());
                Map mainBookDepreUseMap = FaChangeBillSubmitOp.this.queryDepreUseOfMainBook(orgIds);
                Set allDayDepreIds = FaChangeBillUtil.getAllTypeIsDayDepre();
                String kdErrorStr2 = ResManager.loadKDString((String)"%s\uff1a\u5b9e\u7269\u5361\u7247\u7684\u542f\u7528\u65e5\u671f\u4e0d\u80fd\u53d8\u66f4\u5230\u8d22\u52a1\u5165\u8d26\u65e5\u671f\u4e4b\u540e\u3002", (String)"FaChangeBillSubmitOp_2", (String)"fi-fa-opplugin", (Object[])new Object[0]);
                String kdErrorStr3 = ResManager.loadKDString((String)"\u5f53\u671f\u65b0\u589e\u7684\u5361\u7247\uff08%1$s\uff09\u4e0d\u80fd\u505a\u53c2\u4e0e\u8bb0\u8d26\u7684\u53d8\u66f4\uff0c\u5982\u786e\u9700\u53d8\u66f4\uff0c\u8bf7\u5148\u8bbe\u7f6e\u53ef\u53d8\u66f4\u9879\u76ee\u3002", (String)"FaChangeBillSubmitOp_3", (String)"fi-fa-opplugin", (Object[])new Object[0]);
                String kdErrorStr4 = ResManager.loadKDString((String)"%s\uff1a\u4e1a\u52a1\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a", (String)"FaChangeBillSubmitOp_4", (String)"fi-fa-opplugin", (Object[])new Object[0]);
                String kdErrorStr5 = ResManager.loadKDString((String)"%1$s\uff1a\u6839\u636e\u4e1a\u52a1\u65e5\u671f(%2$s)\u627e\u4e0d\u5230\u671f\u95f4", (String)"FaChangeBillSubmitOp_5", (String)"fi-fa-opplugin", (Object[])new Object[0]);
                String kdErrorStr6 = ResManager.loadKDString((String)"%s\uff1a\u672c\u671f\u5df2\u7ef4\u62a4\u5de5\u4f5c\u91cf\uff0c\u4e0d\u80fd\u53d8\u66f4\u4e3a\u4e0d\u53c2\u4e0e\u8ba1\u63d0\u7684\u4f7f\u7528\u72b6\u6001\u3002", (String)"FaChangeBillSubmitOp_6", (String)"fi-fa-opplugin", (Object[])new Object[0]);
                String kdErrorStr7 = ResManager.loadKDString((String)"%s\uff1a\u4e1a\u52a1\u65e5\u671f\u4e0d\u80fd\u5927\u4e8e\u8bb0\u8d26\u65e5\u671f", (String)"FaChangeBillSubmitOp_7", (String)"fi-fa-opplugin", (Object[])new Object[0]);
                String kdErrorStr8 = ResManager.loadKDString((String)"%1$s\uff1a\u4e1a\u52a1\u65e5\u671f\u4e0d\u80fd\u5c0f\u4e8e\u5b9e\u7269\u542f\u7528\u65e5\u671f(%2$s)", (String)"FaChangeBillSubmitOp_8", (String)"fi-fa-opplugin", (Object[])new Object[0]);
                String kdErrorStr9 = ResManager.loadKDString((String)"%1$s\uff1a\u4e1a\u52a1\u65e5\u671f\u4e0d\u80fd\u5927\u4e8e\u4e0b\u671f\u671f\u95f4\u7ed3\u675f\u65e5\u671f(%2$s)", (String)"FaChangeBillSubmitOp_9", (String)"fi-fa-opplugin", (Object[])new Object[0]);
                String kdErrorStr10 = ResManager.loadKDString((String)"%1$s\uff1a\u6839\u636e\u4e1a\u52a1\u65e5\u671f(%2$s)\u627e\u4e0d\u5230\u671f\u95f4\uff0c\u4e0d\u6ee1\u8db3\u8ba1\u63d0\u6298\u65e7\u6240\u9700\u7684\u6570\u636e\u6761\u4ef6\uff0c\u8bf7\u7ef4\u62a4\u8be5\u65e5\u671f\u5bf9\u5e94\u7684\u671f\u95f4\u6570\u636e", (String)"FaChangeBillSubmitOp_10", (String)"fi-fa-opplugin", (Object[])new Object[0]);
                String kdErrorStr11 = ResManager.loadKDString((String)"%1$s\uff1a\u6839\u636e\u542f\u7528\u65e5\u671f(%2$s)\u627e\u4e0d\u5230\u671f\u95f4\uff0c\u4e0d\u6ee1\u8db3\u8ba1\u63d0\u6298\u65e7\u6240\u9700\u7684\u6570\u636e\u6761\u4ef6\uff0c\u8bf7\u7ef4\u62a4\u8be5\u65e5\u671f\u5bf9\u5e94\u7684\u671f\u95f4\u6570\u636e", (String)"FaChangeBillSubmitOp_11", (String)"fi-fa-opplugin", (Object[])new Object[0]);
                String kdErrorStr12 = ResManager.loadKDString((String)"\u5361\u7247[%s]\u505a\u8fc7\u6e05\u7406\u4e1a\u52a1\uff0c\u4e0d\u80fd\u505a\u8ffd\u6eaf\u8c03\u6574\u6216\u4e1a\u52a1\u65e5\u671f\u5728\u6e05\u7406\u4e4b\u524d\u7684\u672a\u6765\u9002\u7528\u53d8\u66f4", (String)"FaChangeBillSubmitOp_12", (String)"fi-fa-opplugin", (Object[])new Object[0]);
                String kdErrorStr15 = ResManager.loadKDString((String)"%1$s\uff1a\u4e1a\u52a1\u65e5\u671f\u4e0d\u80fd\u5c0f\u4e8e\u8d22\u52a1\u5165\u8d26\u65e5\u671f(%2$s)", (String)"FaChangeBillSubmitOp_13", (String)"fi-fa-opplugin", (Object[])new Object[0]);
                String kdErrorStr16 = ResManager.loadKDString((String)"%1$s\uff1a\u4f7f\u7528\u72b6\u6001[%2$s]\u4e0d\u662f\u660e\u7ec6\u6570\u636e", (String)"FaChangeBillSubmitOp_14", (String)"fi-fa-opplugin", (Object[])new Object[0]);
                String kdErrorStr17 = ResManager.loadKDString((String)"\u5b9e\u7269\u5361\u7247[%s]\u4e0d\u662f\u5c31\u7eea\u72b6\u6001", (String)"FaChangeBillSubmitOp_15", (String)"fi-fa-opplugin", (Object[])new Object[0]);
                String kdErrorStr20 = ResManager.loadKDString((String)"%s\uff1a\u8d44\u4ea7\u6570\u91cf\u4e0d\u80fd\u53d8\u66f4\u4e3a0", (String)"FaChangeBillSubmitOp_16", (String)"fi-fa-opplugin", (Object[])new Object[0]);
                String kdErrorStr24 = ResManager.loadKDString((String)"%s\uff1a\u5b58\u5728\u5361\u7247\u5df2\u4f7f\u7528\u672a\u6765\u9002\u7528\uff0c\u4e0d\u53ef\u4ee5\u8fdb\u884c\u8ffd\u6eaf\u8c03\u6574\u3002", (String)"FaChangeBillSubmitOp_17", (String)"fi-fa-opplugin", (Object[])new Object[0]);
                String kdErrorStr25 = ResManager.loadKDString((String)"%s\uff1a\u5b58\u5728\u5de5\u4f5c\u91cf\u6cd5\u4e0e\u975e\u5de5\u4f5c\u91cf\u6cd5\u76f8\u4e92\u8f6c\u6362\u3002", (String)"FaChangeBillSubmitOp_18", (String)"fi-fa-opplugin", (Object[])new Object[0]);
                String kdErrorStr26 = ResManager.loadKDString((String)"%s\uff1a\u53d8\u66f4\u540e\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u8d26\u7c3f\u9002\u7528\u4f1a\u8ba1\u671f\u95f4\u7c7b\u578b\u4e2d\u6700\u5c0f\u4f1a\u8ba1\u5e74\u5ea6\u7684\u8d77\u59cb\u65e5\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"FaChangeBillSubmitOp_19", (String)"fi-fa-opplugin", (Object[])new Object[0]);
                String kdErrorStr27 = ResManager.loadKDString((String)"%s\uff1a\u53d8\u66f4\u540e\u65e5\u671f\u4e0d\u80fd\u665a\u4e8e\u53d8\u66f4\u5355\u8bb0\u8d26\u65e5\u671f\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"FaChangeBillSubmitOp_20", (String)"fi-fa-opplugin", (Object[])new Object[0]);
                String kdErrorStr28 = ResManager.loadKDString((String)"%s\uff1a\u5b58\u5728\u6309\u65e5\u6298\u65e7\u6cd5\u4e0e\u975e\u6309\u65e5\u6298\u65e7\u6cd5\u76f8\u4e92\u8f6c\u6362\u3002", (String)"FaChangeBillSubmitOp_27", (String)"fi-fa-opplugin", (Object[])new Object[0]);
                String kdErrorStr29 = ResManager.loadKDString((String)"%s\uff1a\u5361\u7247\u65b0\u589e\u5f53\u671f\u5df2\u505a\u5408\u5e76\uff0c\u4e0d\u5141\u8bb8\u505a\u5f71\u54cd\u6298\u65e7\u7684\u53d8\u66f4\u3002", (String)"FaChangeBillSubmitOp_28", (String)"fi-fa-opplugin", (Object[])new Object[0]);
                String kdErrorStr30 = ResManager.loadKDString((String)"%s\uff1a\u5361\u7247\u65b0\u589e\u5f53\u671f\u5df2\u505a\u90e8\u5206\u6e05\u7406\uff0c\u4e0d\u5141\u8bb8\u505a\u5f71\u54cd\u6298\u65e7\u7684\u53d8\u66f4\u3002", (String)"FaChangeBillSubmitOp_29", (String)"fi-fa-opplugin", (Object[])new Object[0]);
                String kdErrorStr31 = ResManager.loadKDString((String)"%1$s\uff1a\u672a\u6765\u9002\u7528\u65f6\u4e1a\u52a1\u65e5\u671f\u4e0d\u80fd\u5c0f\u4e8e\u8d26\u7c3f\u542f\u7528\u671f\u95f4\u7b2c\u4e00\u5929(%2$s)", (String)"FaChangeBillSubmitOp_30", (String)"fi-fa-opplugin", (Object[])new Object[0]);
                String mainRowName = ResManager.loadKDString((String)"\u4e3b\u8d26\u7c3f\u5206\u5f55\u7b2c%s\u884c", (String)"FaChangeBillSubmitOp_21", (String)"fi-fa-opplugin", (Object[])new Object[0]);
                String assistRowName = ResManager.loadKDString((String)"\u8f85\u8d26\u7c3f\u5206\u5f55\u7b2c%s\u884c", (String)"FaChangeBillSubmitOp_22", (String)"fi-fa-opplugin", (Object[])new Object[0]);
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    DynamicObject bill = dataEntity.getDataEntity();
                    DynamicObject changeType = bill.getDynamicObject("changetype");
                    boolean isSystemPreChange4Workload = FaChangeTypeUtils.isSystemPreDepreMethodChg4Workload((DynamicObject)changeType);
                    HashSet<Object> newRealCardId = new HashSet<Object>();
                    Date changeDate = bill.getDate("changedate");
                    DynamicObjectCollection realEntries = bill.getDynamicObjectCollection("realentry");
                    HashSet<Long> periods = new HashSet<Long>();
                    boolean finEntrysEmpty = false;
                    for (DynamicObject realEntry : realEntries) {
                        DynamicObject[] finEntrys = realEntry.getDynamicObjectCollection("finentry");
                        if (!finEntrys.isEmpty()) {
                            DynamicObject finEntry = (DynamicObject)finEntrys.get(0);
                            DynamicObject curPeriod = finEntry.getDynamicObject(Fa.dot((String[])new String[]{"fincard", "period"}));
                            if (curPeriod == null) continue;
                            periods.add(curPeriod.getLong("id"));
                            continue;
                        }
                        finEntrysEmpty = true;
                    }
                    if (finEntrysEmpty) continue;
                    DynamicObject[] lastPeriods = FaBaseDaoFactory.getInstance((String)"bd_period").query(new QFilter[]{new QFilter("id", "in", periods)});
                    HashMap<Long, DynamicObject> periodMap = new HashMap<Long, DynamicObject>(lastPeriods.length);
                    for (DynamicObject dy : lastPeriods) {
                        periodMap.put(dy.getLong("id"), dy);
                    }
                    for (DynamicObject realEntry : realEntries) {
                        DynamicObject finEntry = (DynamicObject)realEntry.getDynamicObjectCollection("finentry").get(0);
                        DynamicObject finPeriod = finEntry.getDynamicObject(Fa.dot((String[])new String[]{"fincard", "period"}));
                        if (finPeriod == null) continue;
                        Long curPeriodId = finPeriod.getLong("id");
                        DynamicObject curPeriod = (DynamicObject)periodMap.get(curPeriodId);
                        Timestamp startDate = new Timestamp(curPeriod.getDate("begindate").getTime());
                        Timestamp endDate = new Timestamp(curPeriod.getDate("enddate").getTime());
                        if (changeDate.before(startDate) || changeDate.after(endDate)) continue;
                        newRealCardId.add(realEntry.get("realcard_id"));
                    }
                    DynamicObjectCollection fieldEntries = bill.getDynamicObjectCollection("fieldentry");
                    long orgId = (Long)bill.get("org_id");
                    Map nextPeriods = FaChangeBillSubmitOp.this.getNextPeriodAssbookByOrg(orgId);
                    DynamicObjectCollection books = QueryServiceHelper.query((String)"fa_assetbook", (String)Fa.comma((String[])new String[]{"id", "periodtype", "depreuse"}), (QFilter[])new QFilter("org", "=", (Object)orgId).toArray());
                    Map<Object, Object> depreUse_PeriodType = books.stream().collect(Collectors.toMap(v -> v.get("depreuse"), v -> v.get("periodtype")));
                    HashMap<Long, HashSet<Long>> periodId2RealMasterIdsMap = new HashMap<Long, HashSet<Long>>(16);
                    HashMap<Long, HashSet<Long>> realCardMap = new HashMap<Long, HashSet<Long>>(fieldEntries.size());
                    for (DynamicObject fieldEntry : fieldEntries) {
                        boolean isAdjustdepre;
                        DynamicObject finCard = fieldEntry.getDynamicObject("fincard1");
                        long periodId = finCard.getLong(Fa.id((String)"period"));
                        long bizPeriodId = finCard.getLong(Fa.id((String)"bizperiod"));
                        DynamicObject finPeriodObj = (DynamicObject)periodMap.get(periodId);
                        if (finPeriodObj != null) {
                            Timestamp startDate = new Timestamp(finPeriodObj.getDate("begindate").getTime());
                            Timestamp endDate = new Timestamp(finPeriodObj.getDate("enddate").getTime());
                            if (periodId == bizPeriodId && periodId != 0L && !changeDate.before(startDate) && !changeDate.after(endDate)) {
                                HashSet<Long> realMasterIds = (HashSet<Long>)periodId2RealMasterIdsMap.get(periodId);
                                if (CollectionUtils.isEmpty((Collection)realMasterIds)) {
                                    realMasterIds = new HashSet<Long>(16);
                                    periodId2RealMasterIdsMap.put(periodId, realMasterIds);
                                }
                                realMasterIds.add(finCard.getLong("realcardmasterid"));
                            }
                        }
                        if (!(isAdjustdepre = fieldEntry.getBoolean("isadjustdepre1"))) continue;
                        long depreuseId = fieldEntry.getLong("depreuse1_id");
                        HashSet<Long> ids = (HashSet<Long>)realCardMap.get(depreuseId);
                        if (ids == null) {
                            ids = new HashSet<Long>(10);
                            realCardMap.put(depreuseId, ids);
                        }
                        ids.add(fieldEntry.getDynamicObject("realcard1").getLong("masterid"));
                    }
                    Set curPeriodHasMergeInRealMasterIds = FaBizUtils.filterHasCurPeriodBizFinIds(periodId2RealMasterIdsMap, (String)"fa_mergebill");
                    Set curPeriodHasPartClrRealMasterIds = FaBizUtils.filterHasCurPeriodBizFinIds(periodId2RealMasterIdsMap, (String)"fa_clearbill");
                    HashMap<Long, HashSet<Long>> initDynCardMap = new HashMap<Long, HashSet<Long>>(fieldEntries.size());
                    for (Map.Entry entry : realCardMap.entrySet()) {
                        DataSet ds = QueryServiceHelper.queryDataSet((String)"", (String)"fa_card_dynamic", (String)"realcard.id realcard, depreuse.id depreuse", (QFilter[])new QFilter[]{new QFilter("entityname", "=", (Object)"fa_card_fin"), new QFilter("depreuse", "=", entry.getKey()), new QFilter("realcard", "in", entry.getValue())}, null);
                        Throwable throwable = null;
                        try {
                            Row row = null;
                            while (ds.hasNext()) {
                                row = ds.next();
                                HashSet<Long> ids = (HashSet<Long>)initDynCardMap.get(row.getLong("realcard"));
                                if (ids == null) {
                                    ids = new HashSet<Long>(10);
                                    initDynCardMap.put(row.getLong("depreuse"), ids);
                                }
                                ids.add(row.getLong("realcard"));
                            }
                        }
                        catch (Throwable row) {
                            throwable = row;
                            throw row;
                        }
                        finally {
                            if (ds == null) continue;
                            if (throwable != null) {
                                try {
                                    ds.close();
                                }
                                catch (Throwable row) {
                                    throwable.addSuppressed(row);
                                }
                                continue;
                            }
                            ds.close();
                        }
                    }
                    HashMap<Object, Date> realIdDateMap = new HashMap<Object, Date>();
                    HashMap<String, Map<String, Object>> depUseIdRCardMasterIdInfoMap = new HashMap<String, Map<String, Object>>(16);
                    HashSet<String> dulpCard = new HashSet<String>();
                    Long mainBookDepreUseId = (Long)mainBookDepreUseMap.get(orgId);
                    long mainCardId = 0L;
                    int mainSeq = 0;
                    long otherCardId = 0L;
                    long otherDepreUseId = 0L;
                    int otherSeq = 0;
                    List sourceMasterIdList = FaChangeBillSubmitOp.this.getMasterIdList(fieldEntries);
                    Map dynamicMap = FaChangeBillUtil.getDynamicMapList((List)sourceMasterIdList);
                    HashSet<String> errorMsgSet = new HashSet<String>(16);
                    for (DynamicObject fieldEntry : fieldEntries) {
                        Comparable<Long> afterDepre;
                        DynamicObject useStatus;
                        String dateStr;
                        String depreMethodType;
                        double assetAmount;
                        String assetAmountStr;
                        boolean isMain;
                        String field = fieldEntry.getString("field");
                        String[] split = field.split("\\.");
                        String cardType = split[0];
                        String propName = split[1];
                        long rCardId = fieldEntry.getLong("realcard1_id");
                        long depreuseId = fieldEntry.getLong("depreuse1_id");
                        boolean bl = isMain = depreuseId == mainBookDepreUseId;
                        if (isMain) {
                            if (rCardId != mainCardId) {
                                mainCardId = rCardId;
                                ++mainSeq;
                            }
                        } else if (rCardId != otherCardId || depreuseId != otherDepreUseId) {
                            otherCardId = rCardId;
                            otherDepreUseId = depreuseId;
                            ++otherSeq;
                        }
                        String rowName = isMain ? String.format(mainRowName, mainSeq) : String.format(assistRowName, otherSeq);
                        Date finDate = fieldEntry.getDynamicObject("fincard1").getDate("finaccountdate");
                        if ("realaccountdate".equalsIgnoreCase(propName)) {
                            String dateStr2 = fieldEntry.getString("aftervalue");
                            try {
                                Date afterDate;
                                if (StringUtils.isNotEmpty((CharSequence)dateStr2) && (afterDate = new SimpleDateFormat("yyyy-MM-dd").parse(dateStr2)).compareTo(finDate) > 0) {
                                    errorMsgSet.add(String.format(kdErrorStr2, rowName));
                                }
                            }
                            catch (ParseException e) {
                                throw new RuntimeException(e);
                            }
                        }
                        if ("assetamount".equalsIgnoreCase(propName) && StringUtils.isNotEmpty((CharSequence)(assetAmountStr = fieldEntry.getString("aftervalue"))) && 0.0 >= (assetAmount = Double.parseDouble(assetAmountStr))) {
                            errorMsgSet.add(String.format(kdErrorStr20, rowName));
                        }
                        if ("fa_card_real".equalsIgnoreCase(cardType) && propName.equalsIgnoreCase("assetcat")) {
                            assetCateIds.add((Long)FaChangeBillUtil.parseValue((String)field, (String)fieldEntry.getString("beforevalue")));
                            assetCateIds.add((Long)FaChangeBillUtil.parseValue((String)field, (String)fieldEntry.getString("aftervalue")));
                        }
                        DynamicObject realCardObj = fieldEntry.getDynamicObject("realcard1");
                        if (newRealCardId.contains(rCardId) && notAllowedChangeItems.contains(field)) {
                            errorMsgSet.add(String.format(kdErrorStr3, realCardObj.getString("number")));
                            continue;
                        }
                        DynamicObject finCard = fieldEntry.getDynamicObject("fincard1");
                        Date bookEnablePeriodBeginDate = (Date)orgDepreuseId2EnablePeriodBeginDateMap.get(orgId + "_" + depreuseId);
                        Date realAccountDate = realCardObj.getDate("realaccountdate");
                        Date bizDate = fieldEntry.getDate("bizdate1");
                        boolean isadjustdepre = fieldEntry.getBoolean("isadjustdepre1");
                        DynamicObject nextPeriod = (DynamicObject)nextPeriods.get(depreuseId);
                        if (bizDate == null) {
                            errorMsgSet.add(String.format(kdErrorStr4, rowName));
                            continue;
                        }
                        String bizstatus = realCardObj.getString("bizstatus");
                        if (!bizstatus.equals(BizStatusEnum.READY.name()) && !bizstatus.equals(BizStatusEnum.CHG.name())) {
                            errorMsgSet.add(String.format(kdErrorStr17, realCardObj.getString("number")));
                            continue;
                        }
                        DynamicObject depreMethod = finCard.getDynamicObject("depremethod");
                        if (depreMethod == null) {
                            depreMethodType = "";
                        } else {
                            depreMethod = BusinessDataServiceHelper.loadSingleFromCache((Object)depreMethod.getPkValue(), (String)"fa_depremethod", (String)"type");
                            depreMethodType = depreMethod.getString("type");
                        }
                        if ("usestatus".equals(propName) && StringUtils.isNotEmpty((CharSequence)(dateStr = fieldEntry.getString("aftervalue"))) && (useStatus = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.parseLong(dateStr), (String)"fa_usestatus", (String)Fa.join((String)",", (String[])new String[]{"number", "isleaf"}))) != null && !useStatus.getBoolean("isleaf")) {
                            errorMsgSet.add(String.format(kdErrorStr16, rowName, useStatus.getString("number")));
                        }
                        if ("usestatus".equals(propName) && "5".equals(depreMethodType)) {
                            Long periodTypeId = (Long)depreUse_PeriodType.get(depreuseId);
                            DynamicObject period = PeriodUtil.getPeriodByDate((Date)bizDate, (String)"id", (long)periodTypeId);
                            if (period == null) {
                                errorMsgSet.add(String.format(kdErrorStr5, rowName, Fa.getDF().format(bizDate)));
                                continue;
                            }
                            QFilter[] filters = new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("depreuse", "=", (Object)depreuseId), new QFilter("period", "=", (Object)period.getLong("id")), new QFilter("realcard", "=", (Object)realCardObj.getLong("masterid"))};
                            boolean exists = QueryServiceHelper.exists((String)"fa_workload", (QFilter[])filters);
                            if (exists) {
                                errorMsgSet.add(String.format(kdErrorStr6, rowName));
                                continue;
                            }
                        }
                        if (ChangeBillStrategy.getDepreFieldSet().contains(field)) {
                            Long realMasterId;
                            String dulpKey = depreuseId + "_" + realCardObj.getLong("masterid");
                            if (isadjustdepre) {
                                boolean exists;
                                if (nextPeriod == null && bizDate.compareTo(changeDate) > 0) {
                                    errorMsgSet.add(String.format(kdErrorStr7, rowName));
                                    continue;
                                }
                                if (dulpCard.add(dulpKey)) {
                                    Date parseFinDate = DateUtil.getCurrentDayStart((Date)finDate);
                                    Date nextEndDate = nextPeriod.getDate("enddate");
                                    if (initDynCardMap.get(depreuseId) != null && ((Set)initDynCardMap.get(depreuseId)).contains(realCardObj.getLong("masterid")) && parseFinDate != null && bizDate.compareTo(parseFinDate) < 0) {
                                        errorMsgSet.add(String.format(kdErrorStr15, rowName, Fa.getDF().format(finDate)));
                                        continue;
                                    }
                                    if (bizDate.compareTo(realAccountDate) < 0) {
                                        String realAccountDateStr = DateUtil.getShortDate().format(realAccountDate);
                                        errorMsgSet.add(String.format(kdErrorStr8, rowName, realAccountDateStr));
                                        continue;
                                    }
                                    if (bizDate.compareTo(nextEndDate) > 0) {
                                        String nextEndDateStr = DateUtil.getShortDate().format(nextEndDate);
                                        errorMsgSet.add(String.format(kdErrorStr9, rowName, nextEndDateStr));
                                        continue;
                                    }
                                    if (bookEnablePeriodBeginDate != null && bizDate.compareTo(bookEnablePeriodBeginDate) < 0) {
                                        String enablePeriodBeginDate = DateUtil.getShortDate().format(bookEnablePeriodBeginDate);
                                        errorMsgSet.add(String.format(kdErrorStr31, rowName, enablePeriodBeginDate));
                                        continue;
                                    }
                                }
                                if (!(exists = QueryServiceHelper.exists((String)"bd_period", (QFilter[])new QFilter[]{new QFilter("periodtype", "=", depreUse_PeriodType.get(depreuseId)), new QFilter("begindate", "<=", (Object)bizDate), new QFilter("enddate", ">=", (Object)bizDate)}))) {
                                    errorMsgSet.add(String.format(kdErrorStr10, rowName, Fa.getDF().format(bizDate)));
                                }
                            } else {
                                boolean exists;
                                Date traceDate = realAccountDate;
                                if ("realaccountdate".equalsIgnoreCase(propName)) {
                                    try {
                                        String dateStr3 = fieldEntry.getString("aftervalue");
                                        if (StringUtils.isNotEmpty((CharSequence)dateStr3)) {
                                            traceDate = Fa.getDF().parse(dateStr3);
                                        }
                                    }
                                    catch (ParseException e) {
                                        throw new RuntimeException(e);
                                    }
                                }
                                if (!(exists = QueryServiceHelper.exists((String)"bd_period", (QFilter[])new QFilter[]{new QFilter("periodtype", "=", depreUse_PeriodType.get(depreuseId)), new QFilter("begindate", "<=", (Object)traceDate), new QFilter("enddate", ">=", (Object)traceDate)}))) {
                                    errorMsgSet.add(String.format(kdErrorStr11, rowName, Fa.getDF().format(traceDate)));
                                }
                            }
                            Date date = realAccountDate;
                            if (isadjustdepre) {
                                date = bizDate;
                                String futureKey = depreuseId + "_" + realCardObj.getLong("masterid");
                                if (!depUseIdRCardMasterIdInfoMap.containsKey(futureKey)) {
                                    HashMap<String, Object> valueMap = new HashMap<String, Object>(2);
                                    valueMap.put("number", realCardObj.getString("number"));
                                    valueMap.put("bizdate1", date);
                                    depUseIdRCardMasterIdInfoMap.put(futureKey, valueMap);
                                }
                            } else if ("realaccountdate".equalsIgnoreCase(propName)) {
                                String dateStr4 = fieldEntry.getString("aftervalue");
                                try {
                                    if (StringUtils.isNotEmpty((CharSequence)dateStr4)) {
                                        date = new SimpleDateFormat("yyyy-MM-dd").parse(dateStr4);
                                    }
                                }
                                catch (ParseException e) {
                                    throw new RuntimeException(e);
                                }
                            }
                            if (!realIdDateMap.containsKey(rCardId) || date.compareTo((Date)realIdDateMap.get(rCardId)) < 0) {
                                realIdDateMap.put(rCardId, date);
                            }
                            if (curPeriodHasMergeInRealMasterIds.contains(realMasterId = Long.valueOf(finCard.getLong("realcardmasterid")))) {
                                errorMsgSet.add(String.format(kdErrorStr29, rowName));
                            }
                            if (curPeriodHasPartClrRealMasterIds.contains(realMasterId)) {
                                errorMsgSet.add(String.format(kdErrorStr30, rowName));
                            }
                        }
                        long masterId = fieldEntry.getDynamicObject("realcard1").getLong("masterid");
                        boolean canAdjust = FaChangeBillUtil.canAdjustDepre((String)propName);
                        boolean isDynamic = FaChangeBillSubmitOp.this.cardIsDynamic(masterId, depreuseId, dynamicMap);
                        if (isDynamic && !isadjustdepre && canAdjust) {
                            errorMsgSet.add(String.format(kdErrorStr24, rowName));
                            break;
                        }
                        if (propName.equals("depremethod") && !isSystemPreChange4Workload) {
                            Long befDepre = fieldEntry.getLong("beforevalue");
                            afterDepre = fieldEntry.getLong("aftervalue");
                            Set allWorkLoad = FaChangeBillUtil.getAllTypeIsWorkLoad();
                            if ((allWorkLoad.contains(befDepre) || allWorkLoad.contains(afterDepre)) && !befDepre.equals(afterDepre)) {
                                errorMsgSet.add(String.format(kdErrorStr25, rowName));
                                break;
                            }
                            if (!befDepre.equals(afterDepre) && (allDayDepreIds.contains(befDepre) && !allDayDepreIds.contains(afterDepre) || !allDayDepreIds.contains(befDepre) && allDayDepreIds.contains(afterDepre))) {
                                errorMsgSet.add(String.format(kdErrorStr28, rowName));
                                break;
                            }
                        }
                        if (!"realaccountdate".equals(propName)) continue;
                        Date compareDate = (Date)orgToCompareDate.get(orgId);
                        afterDepre = new Date();
                        String afterDate = fieldEntry.getString("aftervalue");
                        try {
                            SimpleDateFormat datePattern = new SimpleDateFormat("yyyy-MM-dd");
                            afterDepre = datePattern.parse(afterDate);
                        }
                        catch (ParseException parseException) {
                            // empty catch block
                        }
                        if (((Date)afterDepre).before(compareDate) && StringUtils.isNotEmpty((CharSequence)afterDate)) {
                            errorMsgSet.add(String.format(kdErrorStr26, rowName));
                            break;
                        }
                        if (changeDate.compareTo((Date)afterDepre) >= 0 || !StringUtils.isNotEmpty((CharSequence)afterDate)) continue;
                        errorMsgSet.add(String.format(kdErrorStr27, rowName));
                        break;
                    }
                    this.checkAboutClearBiz(dataEntity, realIdDateMap);
                    this.checkAboutMergeBill4Future(dataEntity, depUseIdRCardMasterIdInfoMap);
                    this.checkAboutReStartBiz(dataEntity, realIdDateMap);
                    if (errorMsgSet.size() <= 0) continue;
                    this.addErrorMessage(dataEntity, String.join((CharSequence)";", errorMsgSet));
                }
                if (assetCateIds.isEmpty()) {
                    return;
                }
                DynamicObjectCollection books = QueryServiceHelper.query((String)"fa_assetbook", (String)Fa.comma((String[])new String[]{"id", "org", "depreuse.id", "depreuse.name", "depresystem.id", "depresystem.name"}), (QFilter[])new QFilter("org", "in", orgIds).toArray());
                Object[] depreSystemIdArr = books.stream().map(v -> v.get("depresystem.id")).toArray();
                Map depreSystemId_assetPolicyInfo = AssetPolicyUtil.getAssetPolicyInfoByDepreSystemIds((Object[])depreSystemIdArr);
                HashMap orgId_assetPolicyEntries = new HashMap();
                for (DynamicObject book : books) {
                    Object orgId = book.get("org");
                    if (!orgId_assetPolicyEntries.containsKey(orgId)) {
                        orgId_assetPolicyEntries.put(orgId, new ArrayList());
                    }
                    List assetPolicyEntryLst = (List)orgId_assetPolicyEntries.get(orgId);
                    List assetPolicyInfo = (List)depreSystemId_assetPolicyInfo.get(book.get("depresystem.id"));
                    AssetPolicyEntry assetPolicyEntry = new AssetPolicyEntry();
                    assetPolicyEntry.assetPolicyInfo = assetPolicyInfo;
                    assetPolicyEntry.depreSystemName = book.getString("depresystem.name");
                    assetPolicyEntry.depreuseName = book.getString("depreuse.name");
                    assetPolicyEntryLst.add(assetPolicyEntry);
                }
                DynamicObject[] assetCates = BusinessDataServiceHelper.load((String)"fa_assetcategory", (String)"id,name,longnumber", (QFilter[])new QFilter("id", "in", assetCateIds).toArray());
                Map<Long, DynamicObject> assetCateMap = Stream.of(assetCates).collect(Collectors.toMap(v -> v.getLong("id"), v -> v));
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    DynamicObject bill = dataEntity.getDataEntity();
                    ChangeBillPOJO assetCatChange = new ChangeBillPOJO();
                    assetCatChange.dataEntity = dataEntity;
                    assetCatChange.assetPolicyEntries = (List)orgId_assetPolicyEntries.get(bill.get("org_id"));
                    DynamicObjectCollection fieldEntries = bill.getDynamicObjectCollection("fieldentry");
                    for (DynamicObject fieldEntry : fieldEntries) {
                        String field = fieldEntry.getString("field");
                        String[] split = field.split("\\.");
                        if (!"fa_card_real".equalsIgnoreCase(split[0]) || !split[1].equalsIgnoreCase("assetcat")) continue;
                        long bfrCatId = (Long)FaChangeBillUtil.parseValue((String)field, (String)fieldEntry.getString("beforevalue"));
                        long aftCatId = (Long)FaChangeBillUtil.parseValue((String)field, (String)fieldEntry.getString("aftervalue"));
                        if (aftCatId <= 0L) continue;
                        AssetCatChangeEntry assetCatChangeEntry = new AssetCatChangeEntry();
                        assetCatChangeEntry.assetName = fieldEntry.getDynamicObject("realcard1").getString("assetname");
                        assetCatChangeEntry.beforeCate = assetCateMap.get(bfrCatId);
                        assetCatChangeEntry.afterCate = assetCateMap.get(aftCatId);
                        assetCatChange.cateEntries.add(assetCatChangeEntry);
                    }
                    FaChangeBillSubmitOp.this.changeBillPojoLst.add(assetCatChange);
                }
                for (ChangeBillPOJO assetCatChange : FaChangeBillSubmitOp.this.changeBillPojoLst) {
                    List<String> msgLst = assetCatChange.validate();
                    if (msgLst.isEmpty()) continue;
                    for (String msg : msgLst) {
                        this.addErrorMessage(assetCatChange.dataEntity, msg);
                    }
                }
            }

            private void checkAboutReStartBiz(ExtendedDataEntity dataEntity, Map<Object, Date> realIdDateMap) {
                QFilter filter;
                String realCardNumberField;
                String realCardIdField = Fa.dot((String[])new String[]{"restartentity", "realcard", "id"});
                String selectFields = Fa.comma((String[])new String[]{"restartdate", realCardIdField, realCardNumberField = Fa.dot((String[])new String[]{"restartentity", "realcard", "number"})});
                DynamicObjectCollection reStartRealBillDynObjCollection = QueryServiceHelper.query((String)"fa_restartrealbill", (String)selectFields, (QFilter[])(filter = new QFilter(Fa.dot((String[])new String[]{"restartentity", "realcard"}), "in", realIdDateMap.keySet())).toArray());
                if (reStartRealBillDynObjCollection.isEmpty()) {
                    return;
                }
                HashSet<String> invalidRealCardNumbers = new HashSet<String>(reStartRealBillDynObjCollection.size());
                for (DynamicObject reStartRealBillDynObj : reStartRealBillDynObjCollection) {
                    Long realCardId = reStartRealBillDynObj.getLong(realCardIdField);
                    Date restartDate = reStartRealBillDynObj.getDate("restartdate");
                    Date bizDate = realIdDateMap.get(realCardId);
                    if (!Objects.nonNull(restartDate) || restartDate.compareTo(bizDate) < 0) continue;
                    invalidRealCardNumbers.add(reStartRealBillDynObj.getString(realCardNumberField));
                }
                if (invalidRealCardNumbers.size() > 0) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5361\u7247[%s]\u505a\u8fc7\u91cd\u542f\u4e1a\u52a1\uff0c\u4e0d\u80fd\u505a\u8ffd\u6eaf\u8c03\u6574\u6216\u4e1a\u52a1\u65e5\u671f\u5728\u91cd\u542f\u4e4b\u524d\u7684\u672a\u6765\u9002\u7528\u53d8\u66f4\u3002", (String)"FaChangeBillSubmitOp_26", (String)"fi-fa-opplugin", (Object[])new Object[0]), String.join((CharSequence)", ", invalidRealCardNumbers)));
                }
            }

            private void checkAboutMergeBill4Future(ExtendedDataEntity dataEntity, Map<String, Map<String, Object>> depUseIdRCardMasterIdInfoMap) {
                HashSet<Long> realCardMasterIds = new HashSet<Long>(depUseIdRCardMasterIdInfoMap.size());
                for (Map.Entry<String, Map<String, Object>> entry : depUseIdRCardMasterIdInfoMap.entrySet()) {
                    String[] splitArray = entry.getKey().split("_");
                    realCardMasterIds.add(Long.valueOf(splitArray[1]));
                }
                FaMergeBillServiceImpl mergeBillService = new FaMergeBillServiceImpl();
                Map mergeBills = mergeBillService.findCardLatestMergedPeriod(realCardMasterIds);
                HashSet<String> nonCompliantCardNumber = new HashSet<String>(16);
                for (Map.Entry<String, Map<String, Object>> entry : depUseIdRCardMasterIdInfoMap.entrySet()) {
                    Date mergeBeginDate;
                    Map<String, Object> valueMap = entry.getValue();
                    Date bizDate = (Date)valueMap.get("bizdate1");
                    String cardNumber = (String)valueMap.get("number");
                    DynamicObject latestMergedPeriod = (DynamicObject)mergeBills.get(entry.getKey());
                    if (latestMergedPeriod == null || bizDate.compareTo(mergeBeginDate = latestMergedPeriod.getDate("begindate")) >= 0) continue;
                    nonCompliantCardNumber.add(cardNumber);
                }
                if (!CollectionUtils.isEmpty(nonCompliantCardNumber)) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5361\u7247[%s]\u505a\u8fc7\u5408\u5e76\u4e1a\u52a1\uff0c\u4e0d\u80fd\u505a\u4e1a\u52a1\u65e5\u671f\u5728\u6700\u8fd1\u4e00\u6b21\u5408\u5e76\u5355\u8bb0\u8d26\u671f\u95f4\u7b2c\u4e00\u5929\u4e4b\u524d\u7684\u672a\u6765\u9002\u7528\u53d8\u66f4\u3002", (String)"FaChangeBillSubmitOp_23", (String)"fi-fa-opplugin", (Object[])new Object[0]), nonCompliantCardNumber.stream().collect(Collectors.joining(", "))));
                }
            }

            private void checkAboutClearBiz(ExtendedDataEntity dataEntity, Map<Object, Date> realIdDateMap) {
                QFilter filter;
                String selectFields = Fa.comma((String[])new String[]{"cleardate", Fa.dot((String[])new String[]{"detail_entry", "realcard", "id"}), Fa.dot((String[])new String[]{"detail_entry", "realcard", "number"})});
                DynamicObjectCollection clearBills = QueryServiceHelper.query((String)"fa_clearbill", (String)selectFields, (QFilter[])(filter = new QFilter(Fa.dot((String[])new String[]{"detail_entry", "realcard"}), "in", realIdDateMap.keySet())).toArray());
                if (!CollectionUtils.isEmpty((Collection)clearBills)) {
                    HashSet<String> invalidRealCardNumbers = new HashSet<String>(realIdDateMap.size());
                    for (DynamicObject clearBill : clearBills) {
                        Long realCardId = clearBill.getLong(Fa.dot((String[])new String[]{"detail_entry", "realcard", "id"}));
                        Date clearDate = clearBill.getDate("cleardate");
                        Date bizDate = realIdDateMap.get(realCardId);
                        if (clearDate == null || clearDate.compareTo(bizDate) < 0) continue;
                        invalidRealCardNumbers.add(clearBill.getString(Fa.dot((String[])new String[]{"detail_entry", "realcard", "number"})));
                    }
                    if (!CollectionUtils.isEmpty(invalidRealCardNumbers)) {
                        String clearCardNumber = invalidRealCardNumbers.stream().collect(Collectors.joining(", "));
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5361\u7247[%s]\u505a\u8fc7\u6e05\u7406\u4e1a\u52a1\uff0c\u4e0d\u80fd\u505a\u8ffd\u6eaf\u8c03\u6574\u6216\u4e1a\u52a1\u65e5\u671f\u5728\u6e05\u7406\u4e4b\u524d\u7684\u672a\u6765\u9002\u7528\u53d8\u66f4", (String)"FaChangeBillSubmitOp_12", (String)"fi-fa-opplugin", (Object[])new Object[0]), clearCardNumber));
                    }
                }
            }
        });
        e.addValidator((AbstractValidator)new FaChangeBillSubmitCompFieldValidator());
        e.addValidator((AbstractValidator)new FaChangeBillAboutSplitBillValidator());
        e.addValidator((AbstractValidator)new FaChangeBillAboutReStartRealBillValidator());
        e.addValidator((AbstractValidator)new FaChangeCheckMustValidator());
    }

    private boolean cardIsDynamic(long masterId, long depreuseId, Map<Long, List<Long>> dynamicMap) {
        if (null == dynamicMap || dynamicMap.isEmpty()) {
            return false;
        }
        List<Long> depreuseIdList = dynamicMap.get(masterId);
        if (CollectionUtils.isEmpty(depreuseIdList)) {
            return false;
        }
        return depreuseIdList.contains(depreuseId);
    }

    private List<Long> getMasterIdList(DynamicObjectCollection fieldEntries) {
        LinkedList<Long> resultList = new LinkedList<Long>();
        if (CollectionUtils.isEmpty((Collection)fieldEntries)) {
            return resultList;
        }
        fieldEntries.stream().forEach(t -> resultList.add(t.getDynamicObject("realcard1").getLong("masterid")));
        return resultList;
    }

    private Map<Long, Date> getCompareDate(List<Long> orgIds) {
        Long orgId;
        List assetBooks;
        HashMap<Long, Date> result = new HashMap<Long, Date>(orgIds.size());
        Map assetBookMap = BusinessDataServiceHelper.loadFromCache((String)"fa_assetbook", (QFilter[])new QFilter[]{new QFilter("org", "in", orgIds)});
        HashMap orgToAssetBook = new HashMap();
        for (DynamicObject assetBook : assetBookMap.values()) {
            Long orgId2 = assetBook.getDynamicObject("org").getLong("id");
            List assetBookList = (List)orgToAssetBook.get(orgId2);
            if (assetBookList == null) {
                assetBooks = new ArrayList<DynamicObject>(4);
                assetBooks.add(assetBook);
                orgToAssetBook.put(orgId2, assetBooks);
                continue;
            }
            assetBookList.add(assetBook);
        }
        HashMap orgToDateList = new HashMap(orgIds.size());
        for (Map.Entry orgToAssetBookObj : orgToAssetBook.entrySet()) {
            orgId = (Long)orgToAssetBookObj.getKey();
            assetBooks = (List)orgToAssetBookObj.getValue();
            ArrayList<Date> periodTypes = new ArrayList<Date>(assetBooks.size());
            for (DynamicObject assetBook : assetBooks) {
                Date compareDate = null;
                QFilter qPeriodType = new QFilter("periodtype", "=", assetBook.getDynamicObject("periodtype").get("id"));
                Map periods = BusinessDataServiceHelper.loadFromCache((String)"bd_period", (String)Fa.comma((String[])new String[]{"id", "begindate"}), (QFilter[])new QFilter[]{qPeriodType});
                for (DynamicObject period : periods.values()) {
                    Date temp = period.getDate("begindate");
                    if (compareDate == null) {
                        compareDate = temp;
                        continue;
                    }
                    if (!temp.before(compareDate)) continue;
                    compareDate = temp;
                }
                periodTypes.add(compareDate);
            }
            orgToDateList.put(orgId, periodTypes);
        }
        for (Map.Entry orgToDate : orgToDateList.entrySet()) {
            orgId = (Long)orgToDate.getKey();
            List periodTypes = (List)orgToDate.getValue();
            Date compareDate = null;
            Iterator iterator = periodTypes.iterator();
            while (iterator.hasNext()) {
                Date date;
                Date temp = date = (Date)iterator.next();
                if (compareDate == null) {
                    compareDate = temp;
                    continue;
                }
                if (!temp.after(compareDate)) continue;
                compareDate = temp;
            }
            result.put(orgId, compareDate);
        }
        return result;
    }

    @Override
    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        this.processMoreAssetBookRealChangeSpecialItem(e);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"fa_change_item", (String)"id,topic,number,isgenvoucher", (QFilter[])new QFilter[]{new QFilter("isgenvoucher", "=", (Object)Boolean.TRUE)});
        ArrayList itemMap = new ArrayList(1);
        query.stream().forEach(v -> itemMap.add(String.format("%s.%s", v.getString("topic"), v.getString("number"))));
        for (DynamicObject bill : e.getDataEntities()) {
            String voucherflag = "A";
            DynamicObjectCollection dynColl = bill.getDynamicObjectCollection("fieldentry");
            for (DynamicObject entryRow : dynColl) {
                Boolean isgenvoucher = itemMap.contains(entryRow.getString("field"));
                if (!isgenvoucher.booleanValue()) continue;
                voucherflag = "B";
                break;
            }
            bill.set("voucherflag", (Object)voucherflag);
        }
    }

    private void processMoreAssetBookRealChangeSpecialItem(BeginOperationTransactionArgs e) {
        DynamicObject[] changeBillEntities = e.getDataEntities();
        HashSet<Long> orgIds = new HashSet<Long>(changeBillEntities.length);
        for (DynamicObject changeBill : changeBillEntities) {
            Long orgId = changeBill.getDynamicObject("org").getLong("id");
            orgIds.add(orgId);
        }
        SqlBuilder sb = new SqlBuilder();
        sb.append("select forgid from t_fa_assetbook where ", new Object[0]);
        sb.appendIn("forgid", orgIds.toArray());
        sb.append(" group by forgid having count(forgid) > 1", new Object[0]);
        Set moreAssetBookOrg = (Set)DB.query((DBRoute)DBRoute.of((String)"fa"), (SqlBuilder)sb, rs -> {
            HashSet<Long> orgId = new HashSet<Long>(orgIds.size());
            while (rs.next()) {
                orgId.add(rs.getLong("forgid"));
            }
            return orgId;
        });
        if (!moreAssetBookOrg.isEmpty()) {
            for (DynamicObject changeBill : changeBillEntities) {
                DynamicObjectCollection changeItems;
                Long orgId = changeBill.getDynamicObject("org").getLong("id");
                if (!moreAssetBookOrg.contains(orgId) || !this.checkChangeItemContainsAssetCat(changeItems = changeBill.getDynamicObjectCollection("changeitem"))) continue;
                this.processRealChangeManyBooksToFinEntry(changeBill);
            }
        }
    }

    private boolean checkChangeItemContainsAssetCat(DynamicObjectCollection changeItems) {
        Set changeItemNumberSet = changeItems.stream().map(v -> v.getDynamicObject("fbasedataid").getString("number")).collect(Collectors.toSet());
        return changeItemNumberSet.contains("assetcat");
    }

    private void processRealChangeManyBooksToFinEntry(DynamicObject changeBill) {
        Long realCardId;
        DynamicObjectCollection realEntry = changeBill.getDynamicObjectCollection("realentry");
        Set realCardIdSet = realEntry.stream().map(v -> v.getDynamicObject("realcard").getLong("id")).collect(Collectors.toSet());
        List finCardList = FaUtils.queryFinCardList(realCardIdSet, null, null, null);
        Map<Object, DynamicObject> finCardMap = finCardList.stream().collect(Collectors.toMap(card -> card.get("id"), card -> card));
        HashMap<Long, HashSet<Object>> realToFinMap = new HashMap<Long, HashSet<Object>>(finCardMap.size());
        for (Map.Entry<Object, DynamicObject> finCard : finCardMap.entrySet()) {
            realCardId = finCard.getValue().getDynamicObject("realcard").getLong("masterid");
            HashSet<Object> finCardSet = (HashSet<Object>)realToFinMap.get(realCardId);
            if (finCardSet == null || finCardSet.isEmpty()) {
                finCardSet = new HashSet<Object>(finCardMap.size());
                realToFinMap.put(realCardId, finCardSet);
            }
            finCardSet.add(finCard.getKey());
        }
        for (DynamicObject real : realEntry) {
            realCardId = real.getDynamicObject("realcard").getLong("masterid");
            Set finCards = (Set)realToFinMap.get(realCardId);
            DynamicObjectCollection finEntry = real.getDynamicObjectCollection("finentry");
            Set finCardIds = finEntry.stream().map(v -> v.getDynamicObject("fincard").getLong("id")).collect(Collectors.toSet());
            for (Object finCardId : finCards) {
                if (finCardIds.contains(finCardId)) continue;
                DynamicObject cloneFin = (DynamicObject)new CloneUtils(false, true).clone((IDataEntityBase)finEntry.get(0));
                DynamicObject finCard = finCardMap.get(finCardId);
                cloneFin.set("seq", (Object)(real.getDynamicObjectCollection("finentry").size() + 1));
                cloneFin.set("depreuse", (Object)finCard.getDynamicObject("depreuse"));
                cloneFin.set("currency", (Object)finCard.getDynamicObject("currency"));
                cloneFin.set("fincard", (Object)finCard);
                finEntry.add((Object)cloneFin);
            }
        }
    }

    protected static Map<Long, List<DynamicObject>> getCardChangeMap(DynamicObject dyBill) {
        HashMap<Long, List<DynamicObject>> result = new HashMap<Long, List<DynamicObject>>();
        DynamicObjectCollection dys = dyBill.getDynamicObjectCollection("fieldentry");
        for (DynamicObject dy : dys) {
            Long cardId = dy.getDynamicObject("realcard1").getLong("id");
            if (result.containsKey(cardId)) {
                ((List)result.get(cardId)).add(dy);
                continue;
            }
            ArrayList<DynamicObject> curDys = new ArrayList<DynamicObject>();
            curDys.add(dy);
            result.put(cardId, curDys);
        }
        return result;
    }

    String checkChangeStatus(List<DynamicObject> fieldDys, boolean changeNo) {
        DynamicObject dy;
        String result = "";
        if (fieldDys.isEmpty()) {
            return result;
        }
        boolean changeStatus = false;
        Iterator<DynamicObject> iterator = fieldDys.iterator();
        while (iterator.hasNext() && !(changeStatus = FaChangeBillUtil.checkChangeStatus((DynamicObject)(dy = iterator.next()), (boolean)changeNo))) {
        }
        if (!changeStatus) {
            result = fieldDys.get(0).getDynamicObject("realcard1").getString("number");
        }
        return result;
    }

    private Map<Long, DynamicObject> getNextPeriodAssbookByOrg(long orgId) {
        HashMap<Long, DynamicObject> result = new HashMap<Long, DynamicObject>();
        DynamicObjectCollection assetBooks = this.getAssetbookByOrg(orgId);
        for (DynamicObject assetbook : assetBooks) {
            Long curperiodId = assetbook.getLong("curperiod");
            DynamicObject curperiod = FaBizUtils.queryNeighborPeriod((Object)curperiodId, (int)1);
            result.put(assetbook.getLong("depreuse"), curperiod);
        }
        return result;
    }

    private DynamicObjectCollection getAssetbookByOrg(long orgId) {
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        String selectFields = "depreuse,curperiod";
        DynamicObjectCollection periods = QueryServiceHelper.query((String)"fa_assetbook", (String)selectFields, (QFilter[])new QFilter[]{orgFilter, enableFilter});
        return periods;
    }

    private Map<Long, Long> queryDepreUseOfMainBook(List<Long> orgIds) {
        QFilter[] filters = new QFilter[]{new QFilter("org", "in", orgIds), new QFilter("ismainbook", "=", (Object)Boolean.TRUE)};
        DynamicObjectCollection assetBooks = QueryServiceHelper.query((String)"fa_assetbook", (String)Fa.comma((String[])new String[]{"org", "depreuse"}), (QFilter[])filters);
        return assetBooks.stream().collect(Collectors.toMap(v -> v.getLong("org"), v -> v.getLong("depreuse")));
    }

    private static class ChangeBillPOJO {
        private ExtendedDataEntity dataEntity;
        private final List<AssetCatChangeEntry> cateEntries = new ArrayList<AssetCatChangeEntry>();
        private List<AssetPolicyEntry> assetPolicyEntries = null;

        private ChangeBillPOJO() {
        }

        public List<String> validate() {
            ArrayList<String> ret = new ArrayList<String>();
            for (AssetCatChangeEntry cateEntry : this.cateEntries) {
                for (AssetPolicyEntry assetPolicyEntry : this.assetPolicyEntries) {
                    String msg = null;
                    DynamicObject beforePolicy = AssetPolicyUtil.getByAssetPolicyInfoAndCateLongNumber((String)cateEntry.beforeCate.getString("longnumber"), (List)assetPolicyEntry.assetPolicyInfo);
                    DynamicObject afterPolicy = AssetPolicyUtil.getByAssetPolicyInfoAndCateLongNumber((String)cateEntry.afterCate.getString("longnumber"), (List)assetPolicyEntry.assetPolicyInfo);
                    if (beforePolicy == null) {
                        msg = String.format(ResManager.loadKDString((String)"\u8d44\u4ea7\u7c7b\u522b\uff1a%1$s \u5728 %2$s \u6240\u5173\u8054\u7684 %3$s \u4e0b\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u6298\u65e7\u653f\u7b56", (String)"FaChangeBillSubmitOp_24", (String)"fi-fa-opplugin", (Object[])new Object[0]), cateEntry.beforeCate.getString("name"), assetPolicyEntry.depreuseName, assetPolicyEntry.depreSystemName);
                        ret.add(msg);
                        continue;
                    }
                    if (afterPolicy == null) {
                        msg = String.format(ResManager.loadKDString((String)"\u8d44\u4ea7\u7c7b\u522b\uff1a%1$s \u5728 %2$s \u6240\u5173\u8054\u7684 %3$s \u4e0b\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u6298\u65e7\u653f\u7b56", (String)"FaChangeBillSubmitOp_24", (String)"fi-fa-opplugin", (Object[])new Object[0]), cateEntry.afterCate.getString("name"), assetPolicyEntry.depreuseName, assetPolicyEntry.depreSystemName);
                        ret.add(msg);
                        continue;
                    }
                    boolean beforeNoDepre = beforePolicy.getBoolean("nodepre");
                    boolean afterNoDepre = afterPolicy.getBoolean("nodepre");
                    if ((!beforeNoDepre || afterNoDepre) && (beforeNoDepre || !afterNoDepre)) continue;
                    msg = String.format(ResManager.loadKDString((String)"\u5361\u7247 %1$s \u6240\u53d8\u66f4\u7684\u8d44\u4ea7\u7c7b\u522b\uff08\u4ece%2$s\u5230%3$s\uff09\u5728 %4$s \u6240\u5173\u8054\u7684 %5$s \u4e0b\uff0c\u201c\u4e0d\u63d0\u6298\u65e7\u201d\u5c5e\u6027\u503c\u4e0d\u4e00\u81f4", (String)"FaChangeBillSubmitOp_25", (String)"fi-fa-opplugin", (Object[])new Object[0]), cateEntry.assetName, cateEntry.beforeCate.getString("name"), cateEntry.afterCate.getString("name"), assetPolicyEntry.depreuseName, assetPolicyEntry.depreSystemName);
                    ret.add(msg);
                }
            }
            return ret;
        }
    }

    private static class AssetPolicyEntry {
        private String depreuseName;
        private String depreSystemName;
        private List<Tuple<String, DynamicObject>> assetPolicyInfo;

        private AssetPolicyEntry() {
        }
    }

    private static class AssetCatChangeEntry {
        private String assetName;
        private DynamicObject beforeCate;
        private DynamicObject afterCate;

        private AssetCatChangeEntry() {
        }
    }
}

