/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.changebill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.util.StringUtils;
import kd.fi.fa.business.validator.changeitem.ChangeItemSelectValidator;

public class FaChangeBillSubmitValidator
extends AbstractValidator {
    private static final Long CHANGE_TYPE_ORI_VALUE = 733956066525898752L;

    public void validate() {
        for (ExtendedDataEntity entity : this.getDataEntities()) {
            List<String> depredMsg;
            List<String> errorInfo = this.validate4OriValueChange(entity.getDataEntity());
            if (!errorInfo.isEmpty()) {
                errorInfo.forEach(v -> this.addErrorMessage(entity, (String)v));
            }
            if ((depredMsg = this.validate4PreusingAmountChange(entity.getDataEntity())).isEmpty()) continue;
            depredMsg.forEach(v -> this.addErrorMessage(entity, (String)v));
        }
    }

    private List<String> validate4OriValueChange(DynamicObject bill) {
        BigDecimal afterOriValue;
        Object depreUsePk;
        Object realCardPk;
        String field;
        ArrayList<String> errorInfo = new ArrayList<String>(2);
        DynamicObjectCollection changeItems = bill.getDynamicObjectCollection("changeitem");
        if (!ChangeItemSelectValidator.hasOriginalChange((DynamicObjectCollection)changeItems)) {
            return errorInfo;
        }
        DynamicObjectCollection fieldEntry = bill.getDynamicObjectCollection("fieldentry");
        HashMap<String, BigDecimal> oriValueMap = new HashMap<String, BigDecimal>(fieldEntry.size());
        for (DynamicObject row : fieldEntry) {
            field = row.getString("field");
            if (!"fa_card_fin.originalval".equals(field)) continue;
            realCardPk = row.getDynamicObject("realcard1").getPkValue();
            depreUsePk = row.getDynamicObject("depreuse1").getPkValue();
            String aftValue = row.getString("aftervalue");
            if (!StringUtils.isNotEmpty((String)aftValue)) continue;
            afterOriValue = new BigDecimal(aftValue);
            oriValueMap.put(realCardPk + "_" + depreUsePk, afterOriValue);
        }
        for (DynamicObject row : fieldEntry) {
            String aftValue;
            field = row.getString("field");
            if (!"fa_card_fin.preresidualval".equals(field)) continue;
            realCardPk = row.getDynamicObject("realcard1").getPkValue();
            depreUsePk = row.getDynamicObject("depreuse1").getPkValue();
            DynamicObject finCard = row.getDynamicObject("fincard1");
            afterOriValue = (BigDecimal)oriValueMap.get(realCardPk + "_" + depreUsePk);
            if (afterOriValue == null) {
                afterOriValue = finCard.getBigDecimal("originalval");
            }
            if (!StringUtils.isNotEmpty((String)(aftValue = row.getString("aftervalue")))) continue;
            BigDecimal afterPreResidualVal = new BigDecimal(aftValue);
            String depreUseName = row.getDynamicObject("depreuse1").getLocaleString("name").toString();
            String number = row.getDynamicObject("realcard1").getString("number");
            if (afterPreResidualVal.compareTo(afterOriValue) <= 0) continue;
            errorInfo.add(String.format(ResManager.loadKDString((String)"\u6298\u65e7\u7528\u9014\u4e3a[%1$s]\u7684\u5361\u7247[%2$s]\uff0c\u53d8\u66f4\u540e\u9884\u8ba1\u51c0\u6b8b\u503c\u4e0d\u80fd\u5927\u4e8e\u8d44\u4ea7\u539f\u503c\u3002", (String)"FaChangeBillSubmitValidator_0", (String)"fi-fa-opplugin", (Object[])new Object[0]), depreUseName, number));
        }
        return errorInfo;
    }

    private List<String> validate4PreusingAmountChange(DynamicObject bill) {
        ArrayList<String> errorInfo = new ArrayList<String>(2);
        DynamicObjectCollection changeItems = bill.getDynamicObjectCollection("changeitem");
        if (!ChangeItemSelectValidator.hasPreUsingAmountChange((DynamicObjectCollection)changeItems)) {
            return errorInfo;
        }
        DynamicObjectCollection fieldEntry = bill.getDynamicObjectCollection("fieldentry");
        for (DynamicObject row : fieldEntry) {
            String field = row.getString("field");
            if (!"fa_card_fin.preusingamount".equals(field)) continue;
            DynamicObject finCard = row.getDynamicObject("fincard1");
            BigDecimal depredAmount = finCard.getBigDecimal("depredamount");
            BigDecimal curPeriodAmount = finCard.getBigDecimal("addidepreamount");
            String aftChangeValueStr = row.getString("aftervalue");
            BigDecimal aftChangeValue = BigDecimal.valueOf(Double.parseDouble(aftChangeValueStr));
            if (aftChangeValue.compareTo(depredAmount.subtract(curPeriodAmount)) >= 0) continue;
            errorInfo.add(ResManager.loadKDString((String)"\u53d8\u66f4\u540e\u9884\u8ba1\u5bff\u547d\u4e0d\u80fd\u5c0f\u4e8e\u5361\u7247\u5f53\u524d\u7684\u5df2\u6298\u65e7\u5bff\u547d", (String)"FaChangeBillSubmitValidator_1", (String)"fi-fa-opplugin", (Object[])new Object[0]));
        }
        return errorInfo;
    }
}

