/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.changebill;

import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.fi.fa.business.busyrecord.AbstractBusyRecordServicePlugin;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.opplugin.FaMigrateDateValidator;
import kd.fi.fa.opplugin.changebill.FaChangeBillFeatureValidator;
import kd.fi.fa.opplugin.changebill.validator.FaChangeBillUnAuditValidator;
import kd.fi.fa.utils.FaOpUtils;

public class FaChangeBillUnAuditOp
extends AbstractBusyRecordServicePlugin {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("sourcetype");
        e.getFieldKeys().add("changedate");
        e.getFieldKeys().add("realcard");
        e.getFieldKeys().add("aftrealcard");
        e.getFieldKeys().add("org");
        e.getFieldKeys().add("auditdate");
        e.getFieldKeys().add("changetype");
        e.getFieldKeys().add("chtypedetail");
        e.getFieldKeys().add("fieldentry");
        e.getFieldKeys().add("fieldentry.realcard1");
        e.getFieldKeys().add("fieldentry.fincard1");
        e.getFieldKeys().add("fieldentry.field");
        e.getFieldKeys().add("fieldentry.beforevalue");
        e.getFieldKeys().add("fieldentry.aftervalue");
        e.getFieldKeys().add(Fa.dot((String[])new String[]{"fieldentry", "depreuse"}));
        e.getFieldKeys().add(Fa.dot((String[])new String[]{"realentry", "realcard"}));
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new FaMigrateDateValidator());
        e.addValidator((AbstractValidator)new FaChangeBillFeatureValidator());
        e.addValidator((AbstractValidator)new FaChangeBillUnAuditValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        HashSet<Object> changeBillIds = new HashSet<Object>(e.getDataEntities().length);
        for (DynamicObject bill : e.getDataEntities()) {
            Object changeBillId = bill.get("id");
            changeBillIds.add(changeBillId);
        }
        QFilter[] filters = new QFilter[]{new QFilter("entityname", "=", (Object)"fa_change_dept"), new QFilter("changebillid", "in", changeBillIds)};
        DeleteServiceHelper.delete((String)"fa_card_dynamic", (QFilter[])filters);
        FaOpUtils.undoOp(e, this.getEntityName());
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
    }

    private String getEntityName() {
        return "fa_change_dept";
    }
}

