/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.changebill.validator;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.fi.fa.business.enums.BusyTypeDetailEnum;
import kd.fi.fa.business.utils.ChangeBillUtils;
import kd.fi.fa.business.utils.FaBizUtils;
import kd.fi.fa.business.utils.FaChangeBillUtil;
import kd.fi.fa.common.util.DateUtil;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.utils.FaOpUtils;

public class AbstractFaChangeBillUnAuditValidator
extends AbstractValidator {
    private static Log log = LogFactory.getLog(AbstractFaChangeBillUnAuditValidator.class);

    public void validate() {
        String kdErrorStr6 = ResManager.loadKDString((String)"\u8d44\u4ea7\u7f16\u7801[%s]\u5b58\u5728\u672a\u5b8c\u6210\u4e1a\u52a1\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\uff0c\u8bf7\u6267\u884c\u5b8c\u672a\u5b8c\u6210\u4e1a\u52a1\u540e\u518d\u8bd5\u3002", (String)"AbstractFaChangeBillUnAuditValidator_0", (String)"fi-fa-opplugin", (Object[])new Object[0]);
        String kdErrorStr8 = ResManager.loadKDString((String)"\u8d44\u4ea7\u7f16\u7801[%s]\u5f53\u671f\u5b58\u5728\u540e\u7eed\u5b9e\u7269\u53d8\u66f4,\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\uff0c\u82e5\u8981\u8fdb\u884c\u53cd\u5ba1\u6838\u8bf7\u5148\u5c06\u540e\u7eed\u5b9e\u7269\u53d8\u66f4\u53cd\u5ba1\u6838\u5e76\u5220\u9664\u540e\u518d\u8bd5\u3002", (String)"AbstractFaChangeBillUnAuditValidator_1", (String)"fi-fa-opplugin", (Object[])new Object[0]);
        String kdErrorStr10 = ResManager.loadKDString((String)"\u8d44\u4ea7\u7f16\u7801[%1$s]\u5c5e\u6027[%2$s]\u53d8\u66f4\u540e\u503c\uff1a%3$s\u4e0e\u5361\u7247\u4e2d\u7684\u503c\uff1a%4$s\u4e0d\u4e00\u81f4\uff0c\u8bf7\u6838\u5bf9\u662f\u5426\u505a\u4e86\u5176\u5b83\u4e1a\u52a1\u3002", (String)"AbstractFaChangeBillUnAuditValidator_2", (String)"fi-fa-opplugin", (Object[])new Object[0]);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            try {
                this.setOperationName(ResManager.loadKDString((String)"\u53cd\u5ba1\u6838", (String)"AbstractFaChangeBillUnAuditValidator_3", (String)"fi-fa-opplugin", (Object[])new Object[0]));
                String sourceType = (String)dataEntity.getValue("sourcetype");
                if (sourceType != null && sourceType.equals("1")) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u53d8\u66f4\u5355\u53cd\u5ba1\u6838\u5931\u8d25\uff0c\u4eba\u4eba\u8d44\u4ea7\u7aef\u751f\u6210\u7684\u53d8\u66f4\u5355\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"AbstractFaChangeBillUnAuditValidator_4", (String)"fi-fa-opplugin", (Object[])new Object[0]));
                    continue;
                }
                OperateOption option = this.getOption();
                if (sourceType != null && sourceType.equals("4") && !option.containsVariable("leaseChangeDeleteAssetChange")) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u79df\u8d41\u53d8\u66f4\u751f\u6210\u7684\u53d8\u66f4\u5355\u4e0d\u5141\u8bb8\u76f4\u63a5\u53cd\u5ba1\u6838\uff0c\u8bf7\u901a\u8fc7\u79df\u8d41\u53d8\u66f4\u5355\u5220\u9664\u3002", (String)"AbstractFaChangeBillUnAuditValidator_5", (String)"fi-fa-opplugin", (Object[])new Object[0]));
                    continue;
                }
                if (sourceType != null && sourceType.equals("5") && !option.containsVariable("IGNORE_API")) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"API\u751f\u6210\u7684\u53d8\u66f4\u5355\u4e0d\u5141\u8bb8\u76f4\u63a5\u53cd\u5ba1\u6838\uff0c\u8bf7\u901a\u8fc7API\u5220\u9664\u3002", (String)"AbstractFaChangeBillUnAuditValidator_6", (String)"fi-fa-opplugin", (Object[])new Object[0]));
                    continue;
                }
                DynamicObject changeBill = dataEntity.getDataEntity();
                DynamicObjectCollection changeFieldEntry = changeBill.getDynamicObjectCollection("fieldentry");
                BusyTypeDetailEnum changeTypeDetail = FaChangeBillUtil.getChangeTypeDetail((DynamicObjectCollection)changeFieldEntry);
                FaOpUtils.checkUndoOperable(dataEntity.getDataEntity(), this.getEntityKey(), "realentry", changeTypeDetail);
                boolean flag = true;
                DynamicObjectCollection realEntries = (DynamicObjectCollection)dataEntity.getValue("realentry");
                HashSet<Long> aftreals = new HashSet<Long>();
                for (DynamicObject entry : realEntries) {
                    long aftReal = entry.getLong("aftrealcard_id");
                    aftreals.add(aftReal);
                }
                long orgId = ((DynamicObject)dataEntity.getValue("org")).getLong("id");
                Date auditDate = (Date)dataEntity.getValue("auditdate");
                boolean existsAfterAuditBill = QueryServiceHelper.exists((String)"fa_change_dept", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("auditdate", ">", (Object)auditDate), new QFilter(Fa.dot((String[])new String[]{"realentry", "realcard"}), "in", aftreals)});
                if (existsAfterAuditBill) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5b58\u5728\u540e\u7eed\u5ba1\u6838\u7684\u53d8\u66f4\u5355\u3002", (String)"AbstractFaChangeBillUnAuditValidator_7", (String)"fi-fa-opplugin", (Object[])new Object[0]));
                    continue;
                }
                String bookNames = FaOpUtils.checkAssetBookDate(dataEntity.getDataEntity(), "org", "changedate");
                if (!bookNames.isEmpty()) {
                    String msgCaption = ResManager.loadKDString((String)"\u8bb0\u8d26\u65e5\u671f\u4e0d\u5728\u8d26\u7c3f\u5f53\u524d\u671f\u95f4\u3002", (String)"AbstractFaChangeBillUnAuditValidator_8", (String)"fi-fa-opplugin", (Object[])new Object[0]);
                    this.addErrorMessage(dataEntity, String.format("%s:%s", msgCaption, bookNames));
                    continue;
                }
                DynamicObject mainBook = FaBizUtils.getAsstBookByOrg((Long)orgId);
                Date maxBeginDate = null;
                Date minEndDate = null;
                Date changeDate = (Date)dataEntity.getValue("changedate");
                maxBeginDate = (Date)mainBook.get("begindate");
                minEndDate = (Date)mainBook.get("enddate");
                if (changeDate.compareTo(maxBeginDate) < 0) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u53d8\u66f4\u5355\u53cd\u5ba1\u6838\u5931\u8d25\uff0c\u8bb0\u8d26\u65e5\u671f\u65e9\u4e8e\u5f53\u524d\u671f\u95f4\u3002", (String)"AbstractFaChangeBillUnAuditValidator_9", (String)"fi-fa-opplugin", (Object[])new Object[0]));
                    flag = false;
                } else if (minEndDate.compareTo(changeDate) < 0) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u53d8\u66f4\u5355\u53cd\u5ba1\u6838\u5931\u8d25\uff0c\u8bb0\u8d26\u65e5\u671f\u665a\u4e8e\u5f53\u524d\u671f\u95f4\u3002", (String)"AbstractFaChangeBillUnAuditValidator_10", (String)"fi-fa-opplugin", (Object[])new Object[0]));
                    flag = false;
                }
                int i = 0;
                if (flag) {
                    Set aftRealCard = realEntries.stream().map(v -> v.getDynamicObject("aftrealcard").getPkValue()).collect(Collectors.toSet());
                    DynamicObjectCollection queryRealCard = QueryServiceHelper.query((String)"fa_card_real", (String)Fa.comma((String[])new String[]{"id", "bizstatus"}), (QFilter[])new QFilter[]{new QFilter("id", "in", aftRealCard)});
                    HashMap<Long, String> cardBizStatusMap = new HashMap<Long, String>(queryRealCard.size());
                    for (DynamicObject realCard : queryRealCard) {
                        cardBizStatusMap.put(realCard.getLong("id"), realCard.getString("bizstatus"));
                    }
                    StringBuilder billErrMsgBf6 = new StringBuilder();
                    StringBuilder billErrMsgBf8 = new StringBuilder();
                    for (DynamicObject changeEntry : realEntries) {
                        ++i;
                        Long realCardId = changeEntry.getDynamicObject("aftrealcard").getLong("id");
                        String realCardNumber = changeEntry.getDynamicObject("aftrealcard").getString("number");
                        String bizstatus = (String)cardBizStatusMap.get(realCardId);
                        boolean isbak = changeEntry.getDynamicObject("aftrealcard").getBoolean("isbak");
                        if (!"READY".equals(bizstatus)) {
                            billErrMsgBf6.append(String.format(kdErrorStr6, realCardNumber));
                            continue;
                        }
                        if (!isbak) continue;
                        billErrMsgBf8.append(String.format(kdErrorStr8, realCardNumber));
                    }
                    if (StringUtils.isNotEmpty((CharSequence)billErrMsgBf6)) {
                        this.addErrorMessage(dataEntity, billErrMsgBf6.toString());
                    }
                    if (StringUtils.isNotEmpty((CharSequence)billErrMsgBf8)) {
                        this.addErrorMessage(dataEntity, billErrMsgBf8.toString());
                    }
                }
                StringBuilder billErrMsgBf10 = new StringBuilder();
                for (DynamicObject bf : changeFieldEntry) {
                    int compare;
                    DynamicObject realcard = bf.getDynamicObject("realcard1");
                    DynamicObject fincard = bf.getDynamicObject("fincard1");
                    String field = bf.getString("field");
                    if (!ChangeBillUtils.isPresetField((String)field)) continue;
                    String[] split = field.split("\\.");
                    DynamicObject card = "fa_card_real".equals(split[0]) ? realcard : fincard;
                    DynamicProperty prop = card.getDynamicObjectType().getProperty(split[1]);
                    String number = realcard.getString("number");
                    String propDisplayNmae = prop.getDisplayName().getLocaleValue();
                    if (prop instanceof DecimalProp) {
                        compare = card.getBigDecimal(split[1]).compareTo(bf.getBigDecimal("aftervalue"));
                        if (compare == 0) continue;
                        billErrMsgBf10.append(String.format(kdErrorStr10, number, propDisplayNmae, bf.getBigDecimal("aftervalue"), card.getBigDecimal(split[1])));
                        continue;
                    }
                    if (prop instanceof BasedataProp) {
                        if (card.getLong(split[1] + "." + "id") == bf.getLong("aftervalue")) continue;
                        billErrMsgBf10.append(String.format(kdErrorStr10, number, propDisplayNmae, bf.getLong("aftervalue"), card.getLong(split[1] + "." + "id")));
                        continue;
                    }
                    if (!(prop instanceof DateProp) || (compare = DateUtil.compareShortDate((Date)card.getDate(split[1]), (Date)bf.getDate("aftervalue"))) == 0) continue;
                    SimpleDateFormat format = DateUtil.getShortDate();
                    billErrMsgBf10.append(String.format(kdErrorStr10, number, propDisplayNmae, format.format(bf.getDate("aftervalue")), format.format(card.getDate(split[1]))));
                }
            }
            catch (Exception e) {
                if (e instanceof KDException) {
                    this.addMessage(dataEntity, e.getMessage(), ErrorLevel.Error);
                    continue;
                }
                this.addMessage(dataEntity, ExceptionUtils.getExceptionStackTraceMessage((Exception)e), ErrorLevel.Error);
            }
        }
    }
}

