/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.changebill.validator;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.util.StringUtils;
import kd.fi.fa.business.utils.FaChangeBillUtil;
import kd.fi.fa.business.utils.SystemParamHelper;
import kd.fi.fa.common.util.Fa;

public class FaChangeApplyCheckMustValidator
extends AbstractValidator {
    public void validate() {
        List orgIdList = Arrays.stream(this.dataEntities).map(v -> v.getDataEntity().getLong(Fa.id((String)"org"))).collect(Collectors.toList());
        List mustFields = FaChangeBillUtil.hasMustField();
        Map changeEmptyParam = SystemParamHelper.getChangeEmptyParam(orgIdList);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject changeBill = dataEntity.getDataEntity();
            DynamicObject org = changeBill.getDynamicObject("org");
            boolean changeNo = org != null && (Boolean)changeEmptyParam.get(org.getLong("id")) != false;
            DynamicObjectCollection entries = changeBill.getDynamicObjectCollection("main_changebillentry");
            DynamicObjectCollection itemEntries = changeBill.getDynamicObjectCollection("changeitem");
            for (DynamicObject entry : entries) {
                StringBuilder sb = new StringBuilder();
                for (DynamicObject itemEntry : itemEntries) {
                    boolean exitMustEmpty;
                    DynamicObject changeItem = itemEntry.getDynamicObject("fbasedataid");
                    String number = changeItem.getString("number");
                    ILocaleString name = changeItem.getLocaleString("name");
                    String value = name.getLocaleValue();
                    if (!entry.containsProperty("bef_" + number)) {
                        number = changeItem.getString("changeapplykey");
                    }
                    Object aftValue = entry.get("aft_" + number);
                    if (!changeNo || !(exitMustEmpty = mustFields.contains(number) && FaChangeBillUtil.checkEmptyField((Object)aftValue) != false)) continue;
                    sb.append(value).append("\u3001");
                }
                String errorMsg = sb.length() == 0 ? "" : sb.substring(0, sb.length() - 1);
                if (!StringUtils.isNotEmpty((String)errorMsg)) continue;
                errorMsg = String.format(ResManager.loadKDString((String)"\u5b58\u5728\u5fc5\u5f55\u5b57\u6bb5%1$s\u53d8\u66f4\u4e3a\u7a7a\uff0c\u6240\u5728\u884c\u53f7\uff1a%2$s\u3002", (String)"FaChangeApplyCheckMustValidator_1", (String)"fi-fa-opplugin", (Object[])new Object[0]), errorMsg, entries.indexOf((Object)entry) + 1);
                this.addErrorMessage(dataEntity, errorMsg);
            }
        }
    }
}

