/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.changebill.validator;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.fi.fa.business.enums.BusyTypeDetailEnum;
import kd.fi.fa.business.utils.FaChangeBillUtil;
import kd.fi.fa.business.utils.FaChangeTypeUtils;
import kd.fi.fa.business.utils.FaUtils;
import kd.fi.fa.common.util.Fa;

public class FaChangeBillBeforeValueValidator
extends AbstractValidator {
    private static final Log log = LogFactory.getLog(FaChangeBillBeforeValueValidator.class);

    public void validate() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject changeBill = dataEntity.getDataEntity();
            DynamicObject changeType = changeBill.getDynamicObject("changetype");
            boolean isSysPreDepreMethod4Workload = FaChangeTypeUtils.isSystemPreDepreMethodChg4Workload((DynamicObject)changeType);
            DynamicObjectCollection fieldEntry = changeBill.getDynamicObjectCollection("fieldentry");
            Set realCardIds = fieldEntry.stream().map(v -> v.getLong(Fa.id((String)"realcard1"))).collect(Collectors.toSet());
            Set finCardIds = fieldEntry.stream().map(v -> v.getLong(Fa.id((String)"fincard1"))).collect(Collectors.toSet());
            BusyTypeDetailEnum changeTypeDetail = FaChangeBillUtil.getChangeTypeDetail((DynamicObjectCollection)fieldEntry);
            Map<Object, Object> realId2Dynamic = new HashMap(FaUtils.getInitialCapacity43((int)realCardIds.size()));
            if (BusyTypeDetailEnum.REAL_CHG == changeTypeDetail || BusyTypeDetailEnum.REAL_FIN_CHG == changeTypeDetail) {
                DynamicObject[] realMap = BusinessDataServiceHelper.load((Object[])realCardIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"fa_card_real"));
                realId2Dynamic = Arrays.stream(realMap).collect(Collectors.toMap(DataEntityBase::getPkValue, v -> v));
            }
            Map<Object, Object> finId2Dynamic = new HashMap(FaUtils.getInitialCapacity43((int)finCardIds.size()));
            if (BusyTypeDetailEnum.FIN_CHG == changeTypeDetail || BusyTypeDetailEnum.REAL_FIN_CHG == changeTypeDetail) {
                DynamicObject[] finMap = BusinessDataServiceHelper.load((Object[])finCardIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"fa_card_fin"));
                finId2Dynamic = Arrays.stream(finMap).collect(Collectors.toMap(DataEntityBase::getPkValue, v -> v));
            }
            HashSet<String> beforeValueHasChangeNumbers = new HashSet<String>(4);
            for (DynamicObject entry : fieldEntry) {
                DynamicObject realCard = entry.getDynamicObject("realcard1");
                long realCardId = realCard.getLong("id");
                long finCardId = entry.getLong(Fa.id((String)"fincard1"));
                String field = entry.getString("field");
                String[] split = field.split("\\.");
                String entryName = split[0];
                String fieldName = split[1];
                try {
                    String beforeValue = entry.getString("beforevalue");
                    if (beforeValue == null || beforeValue.isEmpty()) continue;
                    DynamicObject dy = "fa_card_real".equals(entryName) ? (DynamicObject)realId2Dynamic.get(realCardId) : (DynamicObject)finId2Dynamic.get(finCardId);
                    Object dbData = FaUtils.getValueFromDy((DynamicObject)dy, (String)fieldName);
                    if (dbData instanceof BigDecimal) {
                        if (isSysPreDepreMethod4Workload && "depredamount".equals(fieldName) || new BigDecimal(beforeValue).compareTo((BigDecimal)dbData) == 0) continue;
                        beforeValueHasChangeNumbers.add(realCard.getString("number"));
                        continue;
                    }
                    if (dbData.toString().equals(beforeValue)) continue;
                    beforeValueHasChangeNumbers.add(realCard.getString("number"));
                }
                catch (Exception e) {
                    log.error(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                }
            }
            if (beforeValueHasChangeNumbers.isEmpty()) continue;
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5361\u7247[%s]\u4fe1\u606f\u5df2\u7ecf\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u91cd\u65b0\u5236\u5355\u3002", (String)"FaChangeBillBeforeValueValidator_0", (String)"fi-fa-opplugin", (Object[])new Object[0]), String.join((CharSequence)"\u3001", beforeValueHasChangeNumbers)));
        }
    }
}

