/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.changebill.validator;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.fi.fa.business.po.FaFindPeriodTreeNode;
import kd.fi.fa.business.utils.FaChangeTypeUtils;
import kd.fi.fa.business.utils.FaFindPeriodHelper;
import kd.fi.fa.business.utils.PeriodUtil;
import kd.fi.fa.common.util.DateUtil;
import kd.fi.fa.common.util.Fa;

public class FaChangeBillChange2WorkloadValidator
extends AbstractValidator {
    private static final Log log = LogFactory.getLog(FaChangeBillChange2WorkloadValidator.class);
    private static final String CONNECTOR = "_";
    private static final String OPTYPE_SUBMIT = "submit";
    private static String MSG_SOURCEDEPREMETHOD;
    private static String MSG_AFTDEPREMETHOD;
    private static String MSG_BIZDATEANDFUTURE;
    private static String MSG_DEPREMETHODANDUNIT;
    private static String MSG_DEPREDAMOUNTANDACCUMDEPRE;
    private static String MSG_BIZDATEANDCHANGEDATE;
    private static String MSG_CURPERIODADD;
    private static String MSG_ADJUSTANDFUTUREOTHERPERIOD;
    private static String MSG_DEPREDAMOUNTANDPREUSINGAMOUNT;
    private static String MSG_UNITPRECISION;

    public void validate() {
        this.initMsgs();
        Map<String, DynamicObject> orgBookCurPeriodMap = this.findOrgBookCurPeriodMap();
        HashSet<Long> workloadIds = new HashSet<Long>(16);
        HashSet<Long> dayDepreIds = new HashSet<Long>(16);
        this.findWorkloadAndDayDepreIds(workloadIds, dayDepreIds);
        Map<Long, DynamicObject> workloadChangeFinPeriodMap = this.getWorkloadChangeFinPeriodMap();
        Map<Long, DynamicObject> workloadUnitMap = this.getWorkloadUnitMap();
        ArrayList<ExtendedDataEntity> otherTypeChangeEntityList = new ArrayList<ExtendedDataEntity>(16);
        ArrayList<ExtendedDataEntity> workloadTypeChangeEntityList = new ArrayList<ExtendedDataEntity>(16);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject changeBill = dataEntity.getDataEntity();
            DynamicObject changeType = changeBill.getDynamicObject("changetype");
            DynamicObjectCollection fieldEntries = changeBill.getDynamicObjectCollection("fieldentry");
            if (CollectionUtils.isEmpty((Collection)fieldEntries)) continue;
            if (FaChangeTypeUtils.isSystemPreDepreMethodChg4Workload((DynamicObject)changeType)) {
                workloadTypeChangeEntityList.add(dataEntity);
                this.checkByFinEntries(dataEntity, workloadIds, dayDepreIds, orgBookCurPeriodMap, workloadChangeFinPeriodMap);
                HashSet<String> failedNum4AftDepreMethodCheck = new HashSet<String>(16);
                HashSet<String> failedNum4DepreMethodAndUnitCheck = new HashSet<String>(16);
                HashSet<String> failedNum4DepredAmountAndAccumDepreCheck = new HashSet<String>(16);
                HashSet<String> failedNum4DepredAmountAndPreUsingAmountCheck = new HashSet<String>(16);
                HashSet<String> failedNum4Precision = new HashSet<String>(16);
                HashMap<Long, String> finId2NumberMap = new HashMap<Long, String>(fieldEntries.size());
                HashMap<Long, ArrayList<DynamicObject>> finId2FieldEntryMap = new HashMap<Long, ArrayList<DynamicObject>>(fieldEntries.size());
                for (DynamicObject fieldEntry : fieldEntries) {
                    DynamicObject finCard = fieldEntry.getDynamicObject("fincard1");
                    if (finCard == null) continue;
                    Long finId = finCard.getLong("id");
                    String cardNumber = finCard.getString("number");
                    if (!this.check4AftDepreMethod(fieldEntry, workloadIds)) {
                        failedNum4AftDepreMethodCheck.add(cardNumber);
                    }
                    finId2NumberMap.put(finId, cardNumber);
                    ArrayList<DynamicObject> oneCardFieldEntries = (ArrayList<DynamicObject>)finId2FieldEntryMap.get(finId);
                    if (oneCardFieldEntries == null) {
                        oneCardFieldEntries = new ArrayList<DynamicObject>(4);
                        finId2FieldEntryMap.put(finId, oneCardFieldEntries);
                    }
                    oneCardFieldEntries.add(fieldEntry);
                }
                if (this.isSubmit()) {
                    for (Map.Entry oneCardEntries : finId2FieldEntryMap.entrySet()) {
                        boolean sameChange;
                        Long finId = (Long)oneCardEntries.getKey();
                        String cardNumber = (String)finId2NumberMap.get(finId);
                        List entries = (List)oneCardEntries.getValue();
                        boolean allHasChange = this.checkDepreMethodAndWorkloadUnitAllChange(entries);
                        if (!allHasChange) {
                            failedNum4DepreMethodAndUnitCheck.add(cardNumber);
                        }
                        if (!(sameChange = this.checkAftDepredAmountAndAccumDepre(entries))) {
                            failedNum4DepredAmountAndAccumDepreCheck.add(cardNumber);
                        }
                        this.checkAftDepredAmountAndPreUsingAmount(entries, cardNumber, workloadUnitMap, failedNum4DepredAmountAndPreUsingAmountCheck, failedNum4Precision);
                    }
                }
                if (CollectionUtils.isNotEmpty(failedNum4AftDepreMethodCheck)) {
                    this.addFormatErrorMsg(dataEntity, MSG_AFTDEPREMETHOD, failedNum4AftDepreMethodCheck);
                }
                if (CollectionUtils.isNotEmpty(failedNum4DepreMethodAndUnitCheck)) {
                    this.addFormatErrorMsg(dataEntity, MSG_DEPREMETHODANDUNIT, failedNum4DepreMethodAndUnitCheck);
                }
                if (CollectionUtils.isNotEmpty(failedNum4DepredAmountAndAccumDepreCheck)) {
                    this.addFormatErrorMsg(dataEntity, MSG_DEPREDAMOUNTANDACCUMDEPRE, failedNum4DepredAmountAndAccumDepreCheck);
                }
                if (CollectionUtils.isNotEmpty(failedNum4DepredAmountAndPreUsingAmountCheck)) {
                    this.addFormatErrorMsg(dataEntity, MSG_DEPREDAMOUNTANDPREUSINGAMOUNT, failedNum4DepredAmountAndPreUsingAmountCheck);
                }
                if (!CollectionUtils.isNotEmpty(failedNum4Precision)) continue;
                this.addFormatErrorMsg(dataEntity, MSG_UNITPRECISION, failedNum4Precision);
                continue;
            }
            otherTypeChangeEntityList.add(dataEntity);
        }
        this.checkOtherChangeBills4UnWorkload(otherTypeChangeEntityList);
        if (this.isSubmit()) {
            this.checkOtherChangeBills4Workload(workloadTypeChangeEntityList);
        }
    }

    private void initMsgs() {
        MSG_SOURCEDEPREMETHOD = ResManager.loadKDString((String)"\u6298\u65e7\u65b9\u6cd5\u53d8\u66f4\uff08\u53d8\u66f4\u540e\u5de5\u4f5c\u91cf\u6cd5\uff09\u4e0d\u652f\u6301\u53d8\u66f4\u5de5\u4f5c\u91cf\u6cd5/\u6309\u65e5\u6298\u65e7\u6cd5\u7684\u5361\u7247\u3002\u4e0d\u6ee1\u8db3\u8981\u6c42\u5361\u7247\u8d44\u4ea7\u7f16\u7801\uff1a%s", (String)"FaChangeBillChange2WorkloadValidator_0", (String)"fi-fa-opplugin", (Object[])new Object[0]);
        MSG_AFTDEPREMETHOD = ResManager.loadKDString((String)"\u6298\u65e7\u65b9\u6cd5\u53d8\u66f4\uff08\u53d8\u66f4\u540e\u5de5\u4f5c\u91cf\u6cd5\uff09\u53d8\u66f4\u540e\u6298\u65e7\u65b9\u6cd5\u53ea\u80fd\u9009\u62e9\u5de5\u4f5c\u91cf\u6cd5\u3002\u4e0d\u6ee1\u8db3\u8981\u6c42\u5361\u7247\u8d44\u4ea7\u7f16\u7801\uff1a%s", (String)"FaChangeBillChange2WorkloadValidator_1", (String)"fi-fa-opplugin", (Object[])new Object[0]);
        MSG_BIZDATEANDFUTURE = ResManager.loadKDString((String)"\u6298\u65e7\u65b9\u6cd5\u53d8\u66f4\uff08\u53d8\u66f4\u540e\u5de5\u4f5c\u91cf\u6cd5\uff09\u4e0d\u652f\u6301\u8ffd\u6eaf\u8c03\u6574\uff0c\u8bf7\u6253\u5f00\u672a\u6765\u9002\u7528\uff0c\u4e1a\u52a1\u65e5\u671f\u9009\u62e9\u5f53\u671f\u3002\u4e0d\u6ee1\u8db3\u8981\u6c42\u5361\u7247\u8d44\u4ea7\u7f16\u7801\uff1a%s", (String)"FaChangeBillChange2WorkloadValidator_2", (String)"fi-fa-opplugin", (Object[])new Object[0]);
        MSG_DEPREMETHODANDUNIT = ResManager.loadKDString((String)"\u6298\u65e7\u65b9\u6cd5\u53d8\u66f4\uff08\u53d8\u66f4\u540e\u5de5\u4f5c\u91cf\u6cd5\uff09\u5fc5\u987b\u53d8\u66f4\u6298\u65e7\u65b9\u6cd5\u548c\u5de5\u4f5c\u91cf\u8ba1\u91cf\u5355\u4f4d\u3002\u4e0d\u6ee1\u8db3\u8981\u6c42\u5361\u7247\u8d44\u4ea7\u7f16\u7801\uff1a%s", (String)"FaChangeBillChange2WorkloadValidator_3", (String)"fi-fa-opplugin", (Object[])new Object[0]);
        MSG_DEPREDAMOUNTANDACCUMDEPRE = ResManager.loadKDString((String)"\u6298\u65e7\u65b9\u6cd5\u53d8\u66f4\uff08\u53d8\u66f4\u540e\u5de5\u4f5c\u91cf\u6cd5\uff09\u65f6\uff0c\u53d8\u66f4\u540e\u5df2\u6298\u65e7\u671f\u95f4\u4e0e\u5361\u7247\u7684\u7d2f\u8ba1\u6298\u65e7\u5fc5\u987b\u540c\u65f6\u4e3a0\u6216\u540c\u65f6\u4e0d\u4e3a0\u3002\u4e0d\u6ee1\u8db3\u8981\u6c42\u5361\u7247\u8d44\u4ea7\u7f16\u7801\uff1a%s", (String)"FaChangeBillChange2WorkloadValidator_4", (String)"fi-fa-opplugin", (Object[])new Object[0]);
        MSG_BIZDATEANDCHANGEDATE = ResManager.loadKDString((String)"\u5b58\u5728\u6298\u65e7\u65b9\u6cd5\u53d8\u66f4\u4e3a\u5de5\u4f5c\u91cf\u6cd5\u7684\u53d8\u66f4\u5355\uff0c\u4e1a\u52a1\u65e5\u671f\u4e0d\u53ef\u4ee5\u65e9\u4e8e\u8be5\u53d8\u66f4\u5355\u7684\u8bb0\u8d26\u671f\u95f4\u7684\u7b2c\u4e00\u5929\u3002\u4e0d\u6ee1\u8db3\u8981\u6c42\u5361\u7247\u8d44\u4ea7\u7f16\u7801\uff1a%s", (String)"FaChangeBillChange2WorkloadValidator_5", (String)"fi-fa-opplugin", (Object[])new Object[0]);
        MSG_CURPERIODADD = ResManager.loadKDString((String)"\u6298\u65e7\u65b9\u6cd5\u53d8\u66f4\uff08\u53d8\u66f4\u540e\u5de5\u4f5c\u91cf\u6cd5\uff09\u4e0d\u652f\u6301\u65b0\u589e\u5f53\u671f\u7684\u5361\u7247\u3002\u4e0d\u6ee1\u8db3\u8981\u6c42\u5361\u7247\u8d44\u4ea7\u7f16\u7801\uff1a%s", (String)"FaChangeBillChange2WorkloadValidator_6", (String)"fi-fa-opplugin", (Object[])new Object[0]);
        MSG_ADJUSTANDFUTUREOTHERPERIOD = ResManager.loadKDString((String)"\u5f53\u671f\u5b58\u5728\u8ffd\u6eaf\u8c03\u6574\u6216\u8005\u672a\u6765\u9002\u7528\u5230\u975e\u5f53\u6708\u7684\u53d8\u66f4\u5355\uff0c\u4e0d\u5141\u8bb8\u505a\u8be5\u4e1a\u52a1\u3002\u4e0d\u6ee1\u8db3\u8981\u6c42\u5361\u7247\u8d44\u4ea7\u7f16\u7801\uff1a%s", (String)"FaChangeBillChange2WorkloadValidator_7", (String)"fi-fa-opplugin", (Object[])new Object[0]);
        MSG_DEPREDAMOUNTANDPREUSINGAMOUNT = ResManager.loadKDString((String)"\u53d8\u66f4\u540e\u5df2\u6298\u65e7\u5bff\u547d\u9700\u8981\u5c0f\u4e8e\u7b49\u4e8e\u53d8\u66f4\u540e\u9884\u8ba1\u5bff\u547d\u3002\u4e0d\u6ee1\u8db3\u8981\u6c42\u5361\u7247\u8d44\u4ea7\u7f16\u7801\uff1a%s", (String)"FaChangeBillChange2WorkloadValidator_8", (String)"fi-fa-opplugin", (Object[])new Object[0]);
        MSG_UNITPRECISION = ResManager.loadKDString((String)"\u53d8\u66f4\u540e\u5df2\u6298\u65e7\u5bff\u547d\u3001\u9884\u8ba1\u5bff\u547d\u7cbe\u5ea6\u4e0d\u7b26\u5408\u8981\u6c42\u3002\u4e0d\u6ee1\u8db3\u8981\u6c42\u5361\u7247\u8d44\u4ea7\u7f16\u7801\uff1a%s", (String)"FaChangeBillChange2WorkloadValidator_9", (String)"fi-fa-opplugin", (Object[])new Object[0]);
    }

    private boolean isSubmit() {
        return this.getOperateType().equalsIgnoreCase(OPTYPE_SUBMIT);
    }

    private void findWorkloadAndDayDepreIds(Set<Long> workloadIds, Set<Long> dayDepreIds) {
        QFilter[] qFilters = new QFilter[]{new QFilter("type", "=", (Object)"5").or(new QFilter("type", "=", (Object)"51"))};
        DynamicObjectCollection workloadAndDayDepreMethods = QueryServiceHelper.query((String)"fa_depremethod", (String)Fa.comma((String[])new String[]{"id", "type"}), (QFilter[])qFilters);
        workloadAndDayDepreMethods.stream().forEach(t -> {
            if ("5".equals(t.getString("type"))) {
                workloadIds.add(t.getLong("id"));
            } else {
                dayDepreIds.add(t.getLong("id"));
            }
        });
    }

    private Map<Long, DynamicObject> getWorkloadChangeFinPeriodMap() {
        HashSet<Long> periodIds = new HashSet<Long>(16);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject changeBill = dataEntity.getDataEntity();
            DynamicObjectCollection realEntries = changeBill.getDynamicObjectCollection("realentry");
            for (DynamicObject realEntry : realEntries) {
                DynamicObjectCollection finEntries = realEntry.getDynamicObjectCollection("finentry");
                for (DynamicObject finEntry : finEntries) {
                    DynamicObject finPeriod;
                    DynamicObject finCard = finEntry.getDynamicObject("fincard");
                    if (finCard == null || (finPeriod = finCard.getDynamicObject("period")) == null) continue;
                    Long periodId = finPeriod.getLong("id");
                    periodIds.add(periodId);
                }
            }
        }
        return PeriodUtil.getPeriodMapByIds((String)Fa.comma((String[])new String[]{"id", "begindate", "enddate"}), periodIds);
    }

    private Map<Long, DynamicObject> getWorkloadUnitMap() {
        HashSet<Long> workloadUnitIds = new HashSet<Long>(16);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject changeBill = dataEntity.getDataEntity();
            DynamicObjectCollection fieldEntries = changeBill.getDynamicObjectCollection("fieldentry");
            for (DynamicObject fieldEntry : fieldEntries) {
                String field = fieldEntry.getString("field");
                String aftVal = fieldEntry.getString("aftervalue");
                if (!Fa.dot((String[])new String[]{"fa_card_fin", "workloadunit"}).equals(field)) continue;
                long aftLongVal = StringUtils.isNotEmpty((String)aftVal) ? Long.parseLong(aftVal) : 0L;
                workloadUnitIds.add(aftLongVal);
            }
        }
        DynamicObjectCollection unitObjs = QueryServiceHelper.query((String)"bd_measureunits", (String)Fa.comma((String[])new String[]{"id", "precision"}), (QFilter[])new QFilter[]{new QFilter("id", "in", workloadUnitIds)});
        HashMap<Long, DynamicObject> workloadUnitMap = new HashMap<Long, DynamicObject>(unitObjs.size());
        unitObjs.stream().forEach(t -> workloadUnitMap.put(t.getLong("id"), (DynamicObject)t));
        return workloadUnitMap;
    }

    private Map<String, DynamicObject> findOrgBookCurPeriodMap() {
        DynamicObject[] books;
        HashMap<String, DynamicObject> orgBookCurPeriod = new HashMap<String, DynamicObject>(this.dataEntities.length);
        HashSet<Long> orgIds = new HashSet<Long>(this.dataEntities.length);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject changeBill = dataEntity.getDataEntity();
            orgIds.add(changeBill.getLong(Fa.id((String)"org")));
        }
        for (DynamicObject book : books = BusinessDataServiceHelper.load((String)"fa_assetbook", (String)Fa.comma((String[])new String[]{"org", "depreuse", "curperiod"}), (QFilter[])new QFilter[]{new QFilter("org", "in", orgIds)})) {
            Long orgId = book.getLong(Fa.id((String)"org"));
            Long depreuseId = book.getLong(Fa.id((String)"depreuse"));
            DynamicObject curPeriod = book.getDynamicObject("curperiod");
            orgBookCurPeriod.put(orgId + CONNECTOR + depreuseId, curPeriod);
        }
        return orgBookCurPeriod;
    }

    private void checkByFinEntries(ExtendedDataEntity dataEntity, Set<Long> workloadIds, Set<Long> dayDepreIds, Map<String, DynamicObject> orgBookCurPeriodMap, Map<Long, DynamicObject> workloadChangeFinPeriodMap) {
        HashSet<String> failedNum4SourceDepreMethodCheck = new HashSet<String>(16);
        HashSet<String> failedNum4BizDateAndFutureCheck = new HashSet<String>(16);
        HashSet<String> failedNum4CurPeriodAddCheck = new HashSet<String>(16);
        DynamicObject changeBill = dataEntity.getDataEntity();
        Date changeDate = changeBill.getDate("changedate");
        DynamicObjectCollection realEntries = changeBill.getDynamicObjectCollection("realentry");
        for (DynamicObject realEntry : realEntries) {
            DynamicObjectCollection finEntries = realEntry.getDynamicObjectCollection("finentry");
            for (DynamicObject finEntry : finEntries) {
                long depreMethodId;
                boolean isFuture = finEntry.getBoolean("isadjustdepre");
                Date bizDate = finEntry.getDate("bizdate");
                DynamicObject finCard = finEntry.getDynamicObject("fincard");
                if (finCard == null) continue;
                String cardNumber = finCard.getString("number");
                DynamicObject depreMethod = finCard.getDynamicObject("depremethod");
                long l = depreMethodId = depreMethod == null ? 0L : depreMethod.getLong("id");
                if (workloadIds.contains(depreMethodId) || dayDepreIds.contains(depreMethodId)) {
                    failedNum4SourceDepreMethodCheck.add(cardNumber);
                }
                Long orgId = finCard.getLong(Fa.id((String)"org"));
                Long depreuseId = finCard.getLong(Fa.id((String)"depreuse"));
                DynamicObject bookCurPeriod = orgBookCurPeriodMap.get(orgId + CONNECTOR + depreuseId);
                boolean bizDateIsCorrect = false;
                if (bookCurPeriod != null && bizDate != null) {
                    Date beginDate = bookCurPeriod.getDate("begindate");
                    Date endDate = bookCurPeriod.getDate("enddate");
                    bizDateIsCorrect = DateUtil.compareDate((Date)bizDate, (Date)beginDate) >= 0 && DateUtil.compareDate((Date)bizDate, (Date)endDate) <= 0;
                } else {
                    log.warn("\u8d22\u52a1\u5361\u7247[{}]\u5bf9\u5e94\u7684\u8d26\u7c3f\u5f53\u524d\u671f\u95f4\u4e3a\u7a7a \u6216 \u53d8\u66f4\u5355-\u8d22\u52a1\u5206\u5f55\u4e0a\u8be5\u5361\u7247\u5bf9\u5e94\u7684\u4e1a\u52a1\u65e5\u671f\u4e3a\u7a7a\uff0c\u8bf7\u6838\u5bf9\u53d8\u66f4\u5355\u6570\u636e\uff01", (Object)cardNumber);
                }
                if (!isFuture || !bizDateIsCorrect) {
                    failedNum4BizDateAndFutureCheck.add(cardNumber);
                }
                DynamicObject period = finCard.getDynamicObject("period");
                DynamicObject bizPeriod = finCard.getDynamicObject("bizperiod");
                if (period == null) continue;
                Long periodId = period.getLong("id");
                Long bizPeriodId = bizPeriod.getLong("id");
                DynamicObject finPeriodObj = workloadChangeFinPeriodMap.get(periodId);
                if (finPeriodObj == null) continue;
                Timestamp startDate = new Timestamp(finPeriodObj.getDate("begindate").getTime());
                Timestamp endDate = new Timestamp(finPeriodObj.getDate("enddate").getTime());
                if (periodId.longValue() != bizPeriodId.longValue() || changeDate.before(startDate) || changeDate.after(endDate)) continue;
                failedNum4CurPeriodAddCheck.add(cardNumber);
            }
        }
        if (CollectionUtils.isNotEmpty(failedNum4SourceDepreMethodCheck)) {
            this.addFormatErrorMsg(dataEntity, MSG_SOURCEDEPREMETHOD, failedNum4SourceDepreMethodCheck);
        }
        if (CollectionUtils.isNotEmpty(failedNum4BizDateAndFutureCheck)) {
            this.addFormatErrorMsg(dataEntity, MSG_BIZDATEANDFUTURE, failedNum4BizDateAndFutureCheck);
        }
        if (CollectionUtils.isNotEmpty(failedNum4CurPeriodAddCheck)) {
            this.addFormatErrorMsg(dataEntity, MSG_CURPERIODADD, failedNum4CurPeriodAddCheck);
        }
    }

    private boolean check4AftDepreMethod(DynamicObject fieldEntry, Set<Long> workloadIds) {
        String field = fieldEntry.getString("field");
        if (Fa.dot((String[])new String[]{"fa_card_fin", "depremethod"}).equals(field)) {
            long aftLongVal;
            String aftVal = fieldEntry.getString("aftervalue");
            long l = aftLongVal = StringUtils.isNotEmpty((String)aftVal) ? Long.parseLong(aftVal) : 0L;
            if (!workloadIds.contains(aftLongVal)) {
                return false;
            }
        }
        return true;
    }

    private boolean checkDepreMethodAndWorkloadUnitAllChange(List<DynamicObject> entries) {
        boolean containsDepreMethod = false;
        boolean containsWorkloadUnit = false;
        boolean valHasChange = false;
        for (DynamicObject fieldEntry : entries) {
            String field = fieldEntry.getString("field");
            String befVal = fieldEntry.getString("beforevalue");
            String aftVal = fieldEntry.getString("aftervalue");
            if (!Fa.dot((String[])new String[]{"fa_card_fin", "depremethod"}).equals(field) && !Fa.dot((String[])new String[]{"fa_card_fin", "workloadunit"}).equals(field)) continue;
            if (Fa.dot((String[])new String[]{"fa_card_fin", "depremethod"}).equals(field)) {
                containsDepreMethod = true;
            } else {
                containsWorkloadUnit = true;
            }
            long befLongVal = StringUtils.isNotEmpty((String)befVal) ? Long.parseLong(befVal) : 0L;
            long aftLongVal = StringUtils.isNotEmpty((String)aftVal) ? Long.parseLong(aftVal) : 0L;
            valHasChange = befLongVal != aftLongVal;
        }
        return containsWorkloadUnit && containsDepreMethod && valHasChange;
    }

    private boolean checkAftDepredAmountAndAccumDepre(List<DynamicObject> entries) {
        DynamicObject finCard = entries.get(0).getDynamicObject("fincard1");
        BigDecimal aftDepredAmount = finCard.getBigDecimal("depredamount");
        BigDecimal aftAccumDepre = finCard.getBigDecimal("accumdepre");
        for (DynamicObject fieldEntry : entries) {
            String field = fieldEntry.getString("field");
            String aftVal = fieldEntry.getString("aftervalue");
            if (!Fa.dot((String[])new String[]{"fa_card_fin", "depredamount"}).equals(field)) continue;
            aftDepredAmount = new BigDecimal(aftVal);
        }
        if (aftDepredAmount == null) {
            aftDepredAmount = new BigDecimal("0");
        }
        if (aftAccumDepre == null) {
            aftAccumDepre = new BigDecimal("0");
        }
        return aftDepredAmount.compareTo(BigDecimal.ZERO) == 0 && aftAccumDepre.compareTo(BigDecimal.ZERO) == 0 || aftDepredAmount.compareTo(BigDecimal.ZERO) != 0 && aftAccumDepre.compareTo(BigDecimal.ZERO) != 0;
    }

    private void checkAftDepredAmountAndPreUsingAmount(List<DynamicObject> entries, String cardNumber, Map<Long, DynamicObject> workloadUnitMap, Set<String> failedNums4Compare, Set<String> failedNums4Precision) {
        DynamicObject finCard = entries.get(0).getDynamicObject("fincard1");
        int unitPrecision = 0;
        for (DynamicObject fieldEntry : entries) {
            Long unitId;
            DynamicObject workloadUnitDy;
            String field = fieldEntry.getString("field");
            String aftVal = fieldEntry.getString("aftervalue");
            if (!Fa.dot((String[])new String[]{"fa_card_fin", "workloadunit"}).equals(field) || (workloadUnitDy = workloadUnitMap.get(unitId = Long.valueOf(StringUtils.isEmpty((String)aftVal) ? 0L : Long.parseLong(aftVal)))) == null) continue;
            unitPrecision = workloadUnitDy.getInt("precision");
        }
        BigDecimal aftDepredAmount = finCard.getBigDecimal("depredamount").setScale(unitPrecision);
        BigDecimal aftPreUsingAmount = finCard.getBigDecimal("preusingamount").setScale(unitPrecision);
        for (DynamicObject fieldEntry : entries) {
            Long unitId;
            DynamicObject workloadUnitDy;
            String field = fieldEntry.getString("field");
            String aftVal = fieldEntry.getString("aftervalue");
            if (Fa.dot((String[])new String[]{"fa_card_fin", "depredamount"}).equals(field)) {
                aftDepredAmount = new BigDecimal(aftVal);
            }
            if (Fa.dot((String[])new String[]{"fa_card_fin", "preusingamount"}).equals(field)) {
                aftPreUsingAmount = new BigDecimal(aftVal);
            }
            if (!Fa.dot((String[])new String[]{"fa_card_fin", "workloadunit"}).equals(field) || (workloadUnitDy = workloadUnitMap.get(unitId = Long.valueOf(StringUtils.isEmpty((String)aftVal) ? 0L : Long.parseLong(aftVal)))) == null) continue;
            unitPrecision = workloadUnitDy.getInt("precision");
        }
        if (aftDepredAmount.compareTo(aftPreUsingAmount) > 0) {
            failedNums4Compare.add(cardNumber);
        }
        int aftDepredAmountPrecision = aftDepredAmount.scale();
        int aftPreUsingAmountPrecision = aftPreUsingAmount.scale();
        if (aftDepredAmountPrecision > unitPrecision || aftPreUsingAmountPrecision > unitPrecision) {
            failedNums4Precision.add(cardNumber);
        }
    }

    private void checkOtherChangeBills4UnWorkload(List<ExtendedDataEntity> dataEntityList) {
        if (CollectionUtils.isEmpty(dataEntityList)) {
            return;
        }
        long startTime = System.currentTimeMillis();
        HashMap<Long, CardInfo> finId2CardInfoMap = new HashMap<Long, CardInfo>(16);
        HashMap<Long, FaFindPeriodHelper> periodTypeId2PeriodHelperMap = new HashMap<Long, FaFindPeriodHelper>(4);
        this.handlerFinCardInfoAndPeriodHelperMap(dataEntityList, finId2CardInfoMap, periodTypeId2PeriodHelperMap);
        this.checkBizDate4BefHasWorkloadChange(dataEntityList, finId2CardInfoMap, periodTypeId2PeriodHelperMap);
        log.info("checkOtherChangeBills4UnWorkload for dataEntityList[size: {}] cost [{}] ms", (Object)dataEntityList.size(), (Object)(System.currentTimeMillis() - startTime));
    }

    private void checkOtherChangeBills4Workload(List<ExtendedDataEntity> dataEntityList) {
        if (CollectionUtils.isEmpty(dataEntityList)) {
            return;
        }
        long startTime = System.currentTimeMillis();
        HashMap<Long, CardInfo> finId2CardInfoMap = new HashMap<Long, CardInfo>(16);
        HashMap<Long, FaFindPeriodHelper> periodTypeId2PeriodHelperMap = new HashMap<Long, FaFindPeriodHelper>(4);
        this.handlerFinCardInfoAndPeriodHelperMap(dataEntityList, finId2CardInfoMap, periodTypeId2PeriodHelperMap);
        this.checkAdjustAndFutureNext(dataEntityList, finId2CardInfoMap, periodTypeId2PeriodHelperMap);
        log.info("checkOtherChangeBills4Workload for dataEntityList[size: {}] cost [{}] ms", (Object)dataEntityList.size(), (Object)(System.currentTimeMillis() - startTime));
    }

    private void handlerFinCardInfoAndPeriodHelperMap(List<ExtendedDataEntity> dataEntityList, Map<Long, CardInfo> finId2CardInfoMap, Map<Long, FaFindPeriodHelper> periodTypeId2PeriodHelperMap) {
        long startTime = System.currentTimeMillis();
        HashSet<Long> orgIds = new HashSet<Long>(dataEntityList.size());
        for (ExtendedDataEntity dataEntity : dataEntityList) {
            DynamicObject changeBill = dataEntity.getDataEntity();
            orgIds.add(changeBill.getLong(Fa.id((String)"org")));
        }
        Map<String, Long> orgIdDepreuseId2PeriodTypeIdMap = this.findOrgIdDepreuseId2PeriodTypeIdMap(orgIds);
        for (ExtendedDataEntity dataEntity : dataEntityList) {
            DynamicObject changeBill = dataEntity.getDataEntity();
            Date changeDate = changeBill.getDate("changedate");
            DynamicObjectCollection realEntries = changeBill.getDynamicObjectCollection("realentry");
            for (DynamicObject realEntry : realEntries) {
                DynamicObjectCollection finEntries = realEntry.getDynamicObjectCollection("finentry");
                for (DynamicObject finEntry : finEntries) {
                    DynamicObject finCard = finEntry.getDynamicObject("fincard");
                    DynamicObject bizPeriod = finCard.getDynamicObject("bizperiod");
                    if (bizPeriod == null) continue;
                    Long finId = finCard.getLong("id");
                    Long orgId = finCard.getLong(Fa.id((String)"org"));
                    Long depreuseId = finCard.getLong(Fa.id((String)"depreuse"));
                    String key = orgId + CONNECTOR + depreuseId;
                    Long periodTypeId = orgIdDepreuseId2PeriodTypeIdMap.get(key);
                    String number = finCard.getString("number");
                    Date bizDate = finEntry.getDate("bizdate");
                    finId2CardInfoMap.put(finId, new CardInfo(number, changeDate, bizDate, periodTypeId));
                    periodTypeId2PeriodHelperMap.computeIfAbsent(periodTypeId, v -> new FaFindPeriodHelper(periodTypeId));
                }
            }
        }
        log.info("handlerFinCardInfoAndPeriodHelperMap for dataEntityList[size: {}], cost [{}] ms", (Object)dataEntityList.size(), (Object)(System.currentTimeMillis() - startTime));
    }

    private Map<String, Long> findOrgIdDepreuseId2PeriodTypeIdMap(Set<Long> orgIds) {
        HashMap<String, Long> orgIdDepreuseId2PeriodTypeIdMap = new HashMap<String, Long>(orgIds.size());
        SqlBuilder querySql = new SqlBuilder();
        querySql.append("select forgid orgid,fdepreuse depreuseid,facctperiodtypeid periodtypeid from t_fa_assetbook where ", new Object[0]);
        querySql.appendIn(" forgid ", (Object[])orgIds.toArray(new Long[0]));
        try (DataSet dataSet = DB.queryDataSet((String)"FaChangeBillChange2WorkloadValidator.findOrgIdDepreuseId2PeriodTypeIdMap", (DBRoute)DBRoute.of((String)"fa"), (SqlBuilder)querySql);){
            for (Row row : dataSet) {
                Long orgId = row.getLong("orgid");
                Long depreuseId = row.getLong("depreuseid");
                Long periodTypeId = row.getLong("periodtypeid");
                orgIdDepreuseId2PeriodTypeIdMap.put(orgId + CONNECTOR + depreuseId, periodTypeId);
            }
        }
        return orgIdDepreuseId2PeriodTypeIdMap;
    }

    private Map<Long, Date> findFinId2ChangeDateMap4AdjustAndFutureNext(Set<Long> finIds) {
        HashMap<Long, Date> finId2ChangeDateMap = new HashMap<Long, Date>();
        return finId2ChangeDateMap;
    }

    private void checkAdjustAndFutureNext(List<ExtendedDataEntity> dataEntityList, Map<Long, CardInfo> finId2CardInfoMap, Map<Long, FaFindPeriodHelper> periodTypeId2PeriodHelperMap) {
        Map<Long, List<ChangeInfo>> finChangeInfoMap = this.findFinChangeInfo(finId2CardInfoMap.keySet());
        if (finChangeInfoMap != null && !finChangeInfoMap.isEmpty()) {
            for (ExtendedDataEntity dataEntity : dataEntityList) {
                HashSet<String> failedNumbers = new HashSet<String>(16);
                DynamicObject changeBill = dataEntity.getDataEntity();
                Long changeBillId = changeBill.getLong("id");
                Date curChangeDate = changeBill.getDate("changedate");
                DynamicObjectCollection realEntries = changeBill.getDynamicObjectCollection("realentry");
                for (DynamicObject realEntry : realEntries) {
                    DynamicObjectCollection finEntries = realEntry.getDynamicObjectCollection("finentry");
                    for (DynamicObject finEntry : finEntries) {
                        DynamicObject finCard = finEntry.getDynamicObject("fincard");
                        Long finId = finCard.getLong("id");
                        CardInfo cardInfo = finId2CardInfoMap.get(finId);
                        if (cardInfo == null) continue;
                        Long periodTypeId = cardInfo.getPeriodTypeId();
                        FaFindPeriodHelper periodHelper = periodTypeId2PeriodHelperMap.get(periodTypeId);
                        List<ChangeInfo> changeInfoList = finChangeInfoMap.get(finId);
                        if (!this.checkSamePeriodHasAdjustAndFutureOther(changeBillId, curChangeDate, changeInfoList, periodHelper)) continue;
                        failedNumbers.add(cardInfo.getCardNumber());
                    }
                }
                if (!CollectionUtils.isNotEmpty(failedNumbers)) continue;
                this.addFormatErrorMsg(dataEntity, MSG_ADJUSTANDFUTUREOTHERPERIOD, failedNumbers);
            }
        }
    }

    private void checkBizDate4BefHasWorkloadChange(List<ExtendedDataEntity> dataEntityList, Map<Long, CardInfo> finId2CardInfoMap, Map<Long, FaFindPeriodHelper> periodTypeId2PeriodHelperMap) {
        Map<Long, Date> finId2ChangeDateMap = this.findFinId2ChangeDateMap4WorkloadChange(finId2CardInfoMap.keySet());
        if (finId2ChangeDateMap != null && !finId2ChangeDateMap.isEmpty()) {
            for (ExtendedDataEntity dataEntity : dataEntityList) {
                HashSet<String> failedNumbers = new HashSet<String>(16);
                DynamicObject changeBill = dataEntity.getDataEntity();
                DynamicObjectCollection realEntries = changeBill.getDynamicObjectCollection("realentry");
                for (DynamicObject realEntry : realEntries) {
                    DynamicObjectCollection finEntries = realEntry.getDynamicObjectCollection("finentry");
                    for (DynamicObject finEntry : finEntries) {
                        DynamicObject finCard = finEntry.getDynamicObject("fincard");
                        Long finId = finCard.getLong("id");
                        CardInfo cardInfo = finId2CardInfoMap.get(finId);
                        if (cardInfo == null) continue;
                        Date bizDate = cardInfo.getBizDate();
                        Date workloadChangeDate = finId2ChangeDateMap.get(finId);
                        if (workloadChangeDate == null) continue;
                        Long periodTypeId = cardInfo.getPeriodTypeId();
                        FaFindPeriodHelper periodHelper = periodTypeId2PeriodHelperMap.get(periodTypeId);
                        FaFindPeriodTreeNode periodTreeNode = periodHelper.findPeriodTreeNodeByDate(workloadChangeDate);
                        if (periodTreeNode == null) {
                            failedNumbers.add(cardInfo.getCardNumber());
                            log.warn("\u5361\u7247[{}]\u627e\u5230\u4e86\u5de5\u4f5c\u91cf\u6cd5\u53d8\u66f4\u5355\uff0c\u4f46\u662f\u53d8\u66f4\u65e5\u671f[{}]\u5bf9\u5e94\u7684\u671f\u95f4\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\uff01", (Object)cardInfo.getCardNumber(), (Object)workloadChangeDate);
                            continue;
                        }
                        Date beginDate = periodTreeNode.getBeginDate();
                        if (DateUtil.compareDate((Date)bizDate, (Date)beginDate) >= 0) continue;
                        failedNumbers.add(cardInfo.getCardNumber());
                    }
                }
                if (!CollectionUtils.isNotEmpty(failedNumbers)) continue;
                this.addFormatErrorMsg(dataEntity, MSG_BIZDATEANDCHANGEDATE, failedNumbers);
            }
        }
    }

    private Map<Long, Date> findFinId2ChangeDateMap4WorkloadChange(Set<Long> finIds) {
        HashMap<Long, Date> finId2ChangeDateMap = new HashMap<Long, Date>();
        if (CollectionUtils.isEmpty(finIds)) {
            return finId2ChangeDateMap;
        }
        DynamicObject workloadChangeType = QueryServiceHelper.queryOne((String)"fa_change_type", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"0001")});
        Long workloadChangeTypeId = workloadChangeType.getLong("id");
        SqlBuilder querySql = new SqlBuilder();
        querySql.append("select a.ffincardid finid,c.fchangedate changedate from t_fa_changebillfinentry a inner join t_fa_changebillrealentry b on a.fentryid=b.fentryid inner join t_fa_changebill c on c.fid = b.fid where c.fnewchangetype=? and ", new Object[]{workloadChangeTypeId});
        querySql.appendIn(" a.ffincardid ", (Object[])finIds.toArray(new Long[0]));
        try (DataSet dataSet = DB.queryDataSet((String)"FaChangeBillChange2WorkloadValidator.findFinId2WorkloadChangeDateMap", (DBRoute)DBRoute.of((String)"fa"), (SqlBuilder)querySql);){
            for (Row row : dataSet) {
                Long finId = row.getLong("finid");
                Date changeDate = row.getDate("changedate");
                finId2ChangeDateMap.put(finId, changeDate);
            }
        }
        return finId2ChangeDateMap;
    }

    private Map<Long, List<ChangeInfo>> findFinChangeInfo(Set<Long> finIds) {
        HashMap<Long, List<ChangeInfo>> finIdChangeInfoMap = new HashMap<Long, List<ChangeInfo>>();
        if (CollectionUtils.isEmpty(finIds)) {
            return finIdChangeInfoMap;
        }
        SqlBuilder querySql = new SqlBuilder();
        querySql.append("select a.ffincardid finid,a.fisadjustdepre isfuture,c.fchangedate changedate,a.fbizdate bizdate,c.fid changebillid from t_fa_changebillfinentry a inner join t_fa_changebillrealentry b on a.fentryid=b.fentryid inner join t_fa_changebill c on c.fid = b.fid where", new Object[0]);
        querySql.appendIn(" a.ffincardid ", (Object[])finIds.toArray(new Long[0]));
        try (DataSet dataSet = DB.queryDataSet((String)"FaChangeBillChange2WorkloadValidator.findFinChangeInfo", (DBRoute)DBRoute.of((String)"fa"), (SqlBuilder)querySql);){
            for (Row row : dataSet) {
                Long finId = row.getLong("finid");
                Long changeBillId = row.getLong("changebillid");
                Boolean isFuture = row.getBoolean("isfuture");
                Date changeDate = row.getDate("changedate");
                Date bizDate = row.getDate("bizdate");
                ArrayList<ChangeInfo> changeInfoList = (ArrayList<ChangeInfo>)finIdChangeInfoMap.get(finId);
                if (changeInfoList == null) {
                    changeInfoList = new ArrayList<ChangeInfo>(8);
                    finIdChangeInfoMap.put(finId, changeInfoList);
                }
                changeInfoList.add(new ChangeInfo(changeBillId, isFuture, changeDate, bizDate));
            }
        }
        return finIdChangeInfoMap;
    }

    private boolean checkSamePeriodHasAdjustAndFutureOther(Long curChangeBillId, Date curChangeDate, List<ChangeInfo> changeInfoList, FaFindPeriodHelper periodHelper) {
        if (CollectionUtils.isEmpty(changeInfoList)) {
            return false;
        }
        for (ChangeInfo changeInfo : changeInfoList) {
            Long changeBillId = changeInfo.getChangeBillId();
            Boolean isFuture = changeInfo.getFuture();
            Date changeDate = changeInfo.getChangeDate();
            Date bizDate = changeInfo.getBizDate();
            if (curChangeBillId != null && curChangeBillId.longValue() == changeBillId.longValue()) continue;
            FaFindPeriodTreeNode curChangePeriodNode = periodHelper.findPeriodTreeNodeByDate(curChangeDate);
            FaFindPeriodTreeNode checkChangePeriodNode = periodHelper.findPeriodTreeNodeByDate(changeDate);
            if (curChangePeriodNode == null || checkChangePeriodNode == null || curChangePeriodNode.getPeriodId().longValue() != checkChangePeriodNode.getPeriodId().longValue()) continue;
            if (!isFuture.booleanValue()) {
                return true;
            }
            FaFindPeriodTreeNode bizDatePeriodNode = periodHelper.findPeriodTreeNodeByDate(bizDate);
            if (bizDatePeriodNode == null || bizDatePeriodNode.getPeriodId().longValue() == checkChangePeriodNode.getPeriodId().longValue()) continue;
            return true;
        }
        return false;
    }

    private void addFormatErrorMsg(ExtendedDataEntity dataEntity, String formatStr, Collection<String> cardNumbers) {
        if (CollectionUtils.isEmpty(cardNumbers)) {
            return;
        }
        this.addErrorMessage(dataEntity, String.format(formatStr, cardNumbers.stream().collect(Collectors.joining(","))));
    }

    public static class ChangeInfo {
        private Long changeBillId;
        private Boolean isFuture;
        private Date changeDate;
        private Date bizDate;

        public ChangeInfo(Long changeBillId, Boolean isFuture, Date changeDate, Date bizDate) {
            this.changeBillId = changeBillId;
            this.isFuture = isFuture;
            this.changeDate = changeDate;
            this.bizDate = bizDate;
        }

        public Long getChangeBillId() {
            return this.changeBillId;
        }

        public Boolean getFuture() {
            return this.isFuture;
        }

        public Date getChangeDate() {
            return this.changeDate;
        }

        public Date getBizDate() {
            return this.bizDate;
        }
    }

    public static class CardInfo {
        private String cardNumber;
        private Date changeDate;
        private Date bizDate;
        private Long periodTypeId;

        public CardInfo(String cardNumber, Date changeDate, Date bizDate, Long periodTypeId) {
            this.cardNumber = cardNumber;
            this.changeDate = changeDate;
            this.bizDate = bizDate;
            this.periodTypeId = periodTypeId;
        }

        public String getCardNumber() {
            return this.cardNumber;
        }

        public Date getBizDate() {
            return this.bizDate;
        }

        public Long getPeriodTypeId() {
            return this.periodTypeId;
        }

        public Date getChangeDate() {
            return this.changeDate;
        }
    }
}

