/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.changebill.validator;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.fa.business.utils.FaChangeTypeUtils;
import kd.fi.fa.common.util.Fa;

public class FaChangeBillPreusingAmountValidator
extends AbstractValidator {
    public void validate() {
        Map<Long, DynamicObject> finCardId2DynObjMap = this.getFinCardId2DynObjMap();
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject changeBill = dataEntity.getDataEntity();
            boolean isSysPreDepreMethod4Workload = FaChangeTypeUtils.isSystemPreDepreMethodChg4Workload((DynamicObject)changeBill.getDynamicObject("changetype"));
            if (isSysPreDepreMethod4Workload) continue;
            DynamicObjectCollection fieldEntry = changeBill.getDynamicObjectCollection("fieldentry");
            HashMap<String, Integer> assetNumber2ErrorMsgMap = new HashMap<String, Integer>(16);
            for (DynamicObject entry : fieldEntry) {
                String field = entry.getString("field");
                if (!"fa_card_fin.preusingamount".equals(field)) continue;
                int unitPrecision = 0;
                DynamicObject finCard = entry.getDynamicObject("fincard1");
                if (Objects.isNull(finCard)) continue;
                DynamicObject workLoadUnitDyn = (finCard = finCardId2DynObjMap.get((Long)finCard.getPkValue())).getDynamicObject("workloadunit");
                if (Objects.nonNull(workLoadUnitDyn)) {
                    unitPrecision = workLoadUnitDyn.getInt("precision");
                }
                BigDecimal afterValue = entry.getBigDecimal("aftervalue");
                String assetNumber2 = finCard.getString("number");
                DynamicObject depreMethodDynObj = finCard.getDynamicObject("depremethod");
                if (Objects.isNull(depreMethodDynObj)) {
                    if (BigDecimal.ZERO.compareTo(afterValue) <= 0 && afterValue.setScale(0, RoundingMode.UP).compareTo(afterValue) == 0) continue;
                    assetNumber2ErrorMsgMap.put(assetNumber2, unitPrecision);
                    continue;
                }
                String depreMethodType = depreMethodDynObj.getString("type");
                if ("5".equals(depreMethodType)) {
                    String afterValueStr = afterValue.stripTrailingZeros().toPlainString();
                    int afterValuePrecision = 0;
                    if (afterValueStr.split("\\.").length > 1) {
                        afterValuePrecision = afterValueStr.split("\\.")[1].length();
                    }
                    if (afterValuePrecision <= unitPrecision) continue;
                    assetNumber2ErrorMsgMap.put(assetNumber2, unitPrecision);
                    continue;
                }
                if (BigDecimal.ZERO.compareTo(afterValue) <= 0 && afterValue.setScale(0, RoundingMode.UP).compareTo(afterValue) == 0) continue;
                assetNumber2ErrorMsgMap.put(assetNumber2, unitPrecision);
            }
            assetNumber2ErrorMsgMap.forEach((assetNumber, precision) -> {
                String errorMsg = String.format(ResManager.loadKDString((String)"\u8d44\u4ea7\u7f16\u7801\uff1a%1$s\uff0c\u5f55\u5165\u7684\u53d8\u66f4\u540e\u7684\u503c\u7684\u7cbe\u5ea6\u5e94\u5c0f\u4e8e\u7b49\u4e8e\u5355\u4f4d\u7cbe\u5ea6%2$s\u3002", (String)"FaChangeBillPreusingAmountValidator_0", (String)"fi-fa-opplugin", (Object[])new Object[0]), assetNumber, precision);
                this.addErrorMessage(dataEntity, errorMsg);
            });
        }
    }

    private Map<Long, DynamicObject> getFinCardId2DynObjMap() {
        DynamicObject[] dynamicObjectArray;
        ArrayList<Object> finCardIdList = new ArrayList<Object>(16);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject changeBill = dataEntity.getDataEntity();
            DynamicObjectCollection fieldEntry = changeBill.getDynamicObjectCollection("fieldentry");
            for (DynamicObject dynamicObject : fieldEntry) {
                DynamicObject finCard = dynamicObject.getDynamicObject("fincard1");
                Object pkValue = finCard.getPkValue();
                finCardIdList.add(pkValue);
            }
        }
        HashMap<Long, DynamicObject> map = new HashMap<Long, DynamicObject>(16);
        String selectFields = Fa.comma((String[])new String[]{"id", "depremethod", "workloadunit", "number"});
        QFilter qFilter = new QFilter("id", "in", finCardIdList);
        for (DynamicObject dynamicObject : dynamicObjectArray = BusinessDataServiceHelper.load((String)"fa_card_fin", (String)selectFields, (QFilter[])qFilter.toArray())) {
            long k = dynamicObject.getLong("id");
            map.put(k, dynamicObject);
        }
        return map;
    }
}

