/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.changebill.validator;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.fa.business.utils.AssetPolicyUtil;
import kd.fi.fa.business.utils.FaChangeBillUtil;
import kd.fi.fa.business.utils.SystemParamHelper;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.common.util.Tuple;

public class FaChangeCheckMustValidator
extends AbstractValidator {
    public void validate() {
        List orgIdList = Arrays.stream(this.dataEntities).map(v -> v.getDataEntity().getLong(Fa.id((String)"org"))).collect(Collectors.toList());
        Map changeEmptyParam = SystemParamHelper.getChangeEmptyParam(orgIdList);
        List mustFields = FaChangeBillUtil.hasMustField();
        QFilter[] qFilters = new QFilter[]{new QFilter("org", "in", orgIdList)};
        Map<Long, Long> bookIdAndSystemIdMap = QueryServiceHelper.query((String)"fa_assetbook", (String)Fa.comma((String[])new String[]{"id", "depresystem"}), (QFilter[])qFilters).stream().collect(Collectors.toMap(v -> v.getLong("id"), v -> v.getLong("depresystem")));
        Map policyInfoByBookIds = AssetPolicyUtil.getAssetPolicyInfoByBookIds(new ArrayList<Long>(bookIdAndSystemIdMap.keySet()));
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject changeBill = dataEntity.getDataEntity();
            DynamicObject org = changeBill.getDynamicObject("org");
            boolean changeNo = org != null && (Boolean)changeEmptyParam.get(org.getLong("id")) != false;
            DynamicObjectCollection itemEntries = changeBill.getDynamicObjectCollection("changeitem");
            DynamicObjectCollection mainEntries = changeBill.getDynamicObjectCollection("main_changebillentry");
            String mPrefix = "m_";
            this.checkEntryMustFields(dataEntity, mainEntries, itemEntries, mPrefix, changeNo, mustFields, policyInfoByBookIds, bookIdAndSystemIdMap);
            DynamicObjectCollection otherEntries = changeBill.getDynamicObjectCollection("other_changebillentry");
            String oPrefix = "o_";
            this.checkEntryMustFields(dataEntity, otherEntries, itemEntries, oPrefix, changeNo, mustFields, policyInfoByBookIds, bookIdAndSystemIdMap);
        }
    }

    private void checkEntryMustFields(ExtendedDataEntity dataEntity, DynamicObjectCollection entries, DynamicObjectCollection itemEntries, String prefix, boolean changeNo, List<String> mustFields, Map<Object, List<Tuple<String, DynamicObject>>> policyInfoByBookIds, Map<Long, Long> bookIdAndSystemIdMap) {
        String entryName = entries.getDynamicObjectType().getDisplayName().getLocaleValue();
        for (DynamicObject entry : entries) {
            String errorMsg1;
            String errorMsg;
            StringBuilder sb = new StringBuilder();
            StringBuilder sb1 = new StringBuilder();
            for (DynamicObject itemEntry : itemEntries) {
                BigDecimal preUsingAmount;
                DynamicObject policyEntry;
                List policyEntries;
                DynamicObject finCard;
                boolean exitMustEmpty;
                DynamicObject changeItem = itemEntry.getDynamicObject("fbasedataid");
                String number = changeItem.getString("number");
                ILocaleString name = changeItem.getLocaleString("name");
                Object aftValue = entry.get(prefix + "aft_" + number);
                String value = name.getLocaleValue();
                if (!changeNo) continue;
                boolean bl = exitMustEmpty = mustFields.contains(number) && FaChangeBillUtil.checkEmptyField((Object)aftValue) != false;
                if (exitMustEmpty) {
                    sb.append(value).append("\u3001");
                }
                if ((finCard = entry.getDynamicObject(prefix + "fincard")) == null) continue;
                long assetBookId = finCard.getLong(Fa.id((String)"assetbook"));
                Long depreSystemId = bookIdAndSystemIdMap.get(assetBookId);
                DynamicObject assetCat = finCard.getDynamicObject("assetcat");
                String longnumber = assetCat.getString("longnumber");
                List<Tuple<String, DynamicObject>> tuples = policyInfoByBookIds.get(depreSystemId);
                if (tuples == null || (policyEntries = tuples.stream().filter(v -> ((String)v.item1).equals(longnumber)).map(v -> (DynamicObject)v.item2).collect(Collectors.toList())).isEmpty() || (policyEntry = (DynamicObject)policyEntries.get(0)) == null || policyEntry.getBoolean("nodepre")) continue;
                if ("depremethod".equals(number) && Boolean.TRUE.equals(FaChangeBillUtil.checkEmptyField((Object)aftValue))) {
                    sb1.append(value).append("\u3001");
                }
                if (!"preusingamount".equals(number) || (preUsingAmount = (BigDecimal)aftValue).compareTo(BigDecimal.ZERO) != 0) continue;
                sb1.append(value).append("\u3001");
            }
            String string = errorMsg = sb.length() == 0 ? "" : sb.substring(0, sb.length() - 1);
            if (StringUtils.isNotEmpty((String)errorMsg)) {
                errorMsg = String.format(ResManager.loadKDString((String)"%1$s\u5b58\u5728\u5fc5\u5f55\u5b57\u6bb5%2$s\u53d8\u66f4\u4e3a\u7a7a\uff0c\u6240\u5728\u884c\u53f7\uff1a%3$s\u3002", (String)"FaChangeCheckEmptyMustValidator_1", (String)"fi-fa-opplugin", (Object[])new Object[0]), entryName, errorMsg, entries.indexOf((Object)entry) + 1);
                this.addErrorMessage(dataEntity, errorMsg);
            }
            if (!StringUtils.isNotEmpty((String)(errorMsg1 = sb1.length() == 0 ? "" : sb1.substring(0, sb1.length() - 1)))) continue;
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%1$s\u5361\u7247\u9700\u8ba1\u63d0\uff0c%2$s\u4e0d\u5141\u8bb8\u53d8\u66f4\u4e3a\u7a7a\uff0c\u6240\u5728\u884c\u53f7\uff1a%3$s\u3002", (String)"FaChangeCheckEmptyMustValidator_2", (String)"fi-fa-opplugin", (Object[])new Object[0]), entryName, errorMsg1, entries.indexOf((Object)entry) + 1));
        }
    }
}

