/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.changebill.validator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.param.AppParam;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.fi.fa.business.OriginvalueEnum;

public class FaDispatchBillConfirmValidator
extends AbstractValidator {
    private static final String FA_APP_ID = "83bfebc800001aac";

    public void validate() {
        if (this.dataEntities.length < 1) {
            return;
        }
        ArrayList<Long> inOrgIds = new ArrayList<Long>(8);
        Map<Object, Object> orgIdAndCurrencyIdsMap = new HashMap();
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject dyn = dataEntity.getDataEntity();
            DynamicObject inOrg = dyn.getDynamicObject("inorg");
            if (inOrg == null) continue;
            inOrgIds.add(inOrg.getLong("id"));
        }
        AppParam appParam = new AppParam(FA_APP_ID, "10", Long.valueOf(0L), Long.valueOf(0L));
        Map systemParams = SystemParamServiceHelper.loadBatchAppParameterByOrgFromCache((AppParam)appParam, inOrgIds);
        ArrayList<Long> orgIds = new ArrayList<Long>(8);
        for (Long inOrgId : inOrgIds) {
            Map params = (Map)systemParams.get(inOrgId.toString());
            String originvalue = params.get("originvalue").toString();
            if (!OriginvalueEnum.A.name().equals(originvalue)) continue;
            orgIds.add(inOrgId);
        }
        String selectfields = "id,basecurrency,org";
        DynamicObjectCollection assetBooks = QueryServiceHelper.query((String)"fa_assetbook", (String)selectfields, (QFilter[])new QFilter[]{new QFilter("org", "in", orgIds)});
        orgIdAndCurrencyIdsMap = assetBooks.stream().collect(Collectors.groupingBy(assetBook -> assetBook.getLong("org")));
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject dyn = dataEntity.getDataEntity();
            DynamicObject outCurrency = dyn.getDynamicObject("currency");
            DynamicObject inOrg = dyn.getDynamicObject("inorg");
            long inorgId = inOrg.getLong("id");
            if (!orgIds.contains(inorgId)) continue;
            Boolean existSame = false;
            if (inOrg != null) {
                List orgIdAndCurrencyIds = (List)orgIdAndCurrencyIdsMap.get(inOrg.getLong("id"));
                if (orgIdAndCurrencyIds != null && orgIdAndCurrencyIds.size() > 0) {
                    for (DynamicObject orgIdAndCurrencyId : orgIdAndCurrencyIds) {
                        if (Long.compare(outCurrency.getLong("id"), orgIdAndCurrencyId.getLong("basecurrency")) != 0) continue;
                        existSame = true;
                        break;
                    }
                    if (existSame.booleanValue()) continue;
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u8c03\u5165\u65b9\u6ca1\u6709\u4e0e\u5f53\u524d\u76f8\u540c\u7684\u672c\u4f4d\u5e01\uff0c\u4e0d\u5141\u8bb8\u505a\u539f\u503c\u8c03\u62e8", (String)"FaDispatchBillConfirmValidator_0", (String)"fi-fa-opplugin", (Object[])new Object[0]), new Object[0]));
                    continue;
                }
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u8c03\u5165\u7ec4\u7ec7\u4e0d\u5b58\u5728\u6709\u672c\u4f4d\u5e01\u7684\u8d44\u4ea7\u8d26\u7c3f", (String)"FaDispatchBillConfirmValidator_1", (String)"fi-fa-opplugin", (Object[])new Object[0]), new Object[0]));
                continue;
            }
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u8c03\u5165\u7ec4\u7ec7\u4e3a\u7a7a", (String)"FaDispatchBillConfirmValidator_2", (String)"fi-fa-opplugin", (Object[])new Object[0]), new Object[0]));
        }
    }
}

