/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.changebill.validator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;

public class FaSourceFlagValidator
extends AbstractValidator {
    private String entryName;
    private String realCardFieldName;
    private static final int DEFAULT_SIZE = 16;
    private static final String[] SOURCE_FLAG = new String[]{"LEASECONTRACT", "INITLEASECONTRACT"};
    private static final String IGNORE_SOURCE_FLAG_VALIDATE = "ignoreSourceFlagValidate";

    public FaSourceFlagValidator(String entryName, String realCardFieldName) {
        this.entryName = entryName;
        this.realCardFieldName = realCardFieldName;
    }

    public String getEntryName() {
        return this.entryName;
    }

    public void setEntryName(String entryName) {
        this.entryName = entryName;
    }

    public String getRealCardFieldName() {
        return this.realCardFieldName;
    }

    public void setRealCardFieldName(String realCardFieldName) {
        this.realCardFieldName = realCardFieldName;
    }

    public void validate() {
        QFilter sourceFlagFilter;
        QFilter idFilter;
        String selector;
        DynamicObjectCollection realCardIdCollection;
        Map variables = this.getOption().getVariables();
        if (variables.containsKey(IGNORE_SOURCE_FLAG_VALIDATE) && Boolean.parseBoolean((String)variables.get(IGNORE_SOURCE_FLAG_VALIDATE))) {
            return;
        }
        ArrayList realCardIdList = new ArrayList(16);
        HashMap<ExtendedDataEntity, List> entityMap = new HashMap<ExtendedDataEntity, List>(this.dataEntities.length);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObjectCollection dynamicObjectCollection = dataEntity.getDataEntity().getDynamicObjectCollection(this.entryName);
            ArrayList<Long> realCardIds = new ArrayList<Long>(16);
            for (DynamicObject dynamicObject : dynamicObjectCollection) {
                if (null == dynamicObject.getDynamicObject(this.realCardFieldName)) continue;
                realCardIds.add(dynamicObject.getDynamicObject(this.realCardFieldName).getLong("masterid"));
            }
            entityMap.put(dataEntity, realCardIds);
            realCardIdList.addAll(realCardIds);
        }
        if (!CollectionUtils.isEmpty(realCardIdList) && (realCardIdCollection = QueryServiceHelper.query((String)"fa_card_real", (String)(selector = "id,number"), (QFilter[])new QFilter[]{idFilter = new QFilter("id", "in", realCardIdList), sourceFlagFilter = new QFilter("sourceflag", "in", (Object)SOURCE_FLAG)})) != null && realCardIdCollection.size() > 0) {
            HashMap<Long, DynamicObject> realCardMap = new HashMap<Long, DynamicObject>(realCardIdCollection.size());
            for (DynamicObject dynamicObject : realCardIdCollection) {
                realCardMap.put(Long.parseLong(dynamicObject.get("id").toString()), dynamicObject);
            }
            entityMap.forEach((k, v) -> {
                for (Long realCardId : v) {
                    if (!realCardMap.containsKey(realCardId)) continue;
                    this.addErrorMessage((ExtendedDataEntity)k, String.format(ResManager.loadKDString((String)"\u79df\u8d41\u5408\u540c\u751f\u6210\u7684\u8d44\u4ea7\uff1a%s\uff0c\u4e0d\u53ef\u4ee5\u8fdb\u884c\u8be5\u4e1a\u52a1\u3002", (String)"FaSourceFlagValidator_0", (String)"fi-fa-opplugin", (Object[])new Object[0]), ((DynamicObject)realCardMap.get(realCardId)).get("number").toString()));
                }
            });
        }
    }
}

