/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.clear;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.business.utils.FaDepreUtil;
import kd.fi.fa.business.utils.FaUtils;
import kd.fi.fa.business.utils.SystemParamHelper;
import kd.fi.fa.common.util.Fa;

public class FaClearBillOpUtils {
    public static void clearPeriodValuation(BeforeOperationArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        HashSet<Long> orgIds = new HashSet<Long>(4);
        for (DynamicObject dataEntity : dataEntities) {
            orgIds.add(dataEntity.getLong("org_id"));
        }
        Collection books = FaUtils.getMainBookDyByOrgIds(orgIds);
        HashMap<Long, DynamicObject> orgIdToCurPeriodId = new HashMap<Long, DynamicObject>(4);
        for (DynamicObject book : books) {
            orgIdToCurPeriodId.put(book.getLong(Fa.id((String)"org")), book.getDynamicObject("curperiod"));
        }
        for (DynamicObject dataEntity : dataEntities) {
            dataEntity.set("clearperiod", orgIdToCurPeriodId.get(dataEntity.getLong("org_id")));
        }
    }

    public static String checkDepreSumVouncher(Map<Long, Boolean> orgId2SumMutilVou, DynamicObject clearBill, Map<String, String> orgIdAndPeriodId2SumHasVouMsg) {
        boolean enableSumMutilVoucher;
        String curAndNextPeriodMsg = ResManager.loadKDString((String)"\u5f53\u671f\u6216\u540e\u7eed\u671f\u95f4\u6298\u65e7\u6c47\u603b\u5df2\u751f\u6210\u51ed\u8bc1\uff0c\u64cd\u4f5c\u5931\u8d25\u3002", (String)"FaClearBillAuditOp_1", (String)"fi-fa-opplugin", (Object[])new Object[0]);
        String nextPeriodMsg = ResManager.loadKDString((String)"\u540e\u7eed\u671f\u95f4\u6298\u65e7\u6c47\u603b\u5df2\u751f\u6210\u51ed\u8bc1\uff0c\u64cd\u4f5c\u5931\u8d25\u3002", (String)"FaClearBillAuditOp_2", (String)"fi-fa-opplugin", (Object[])new Object[0]);
        Long orgId = clearBill.getDynamicObject("org").getLong("id");
        if (orgId2SumMutilVou.get(orgId) != null) {
            enableSumMutilVoucher = orgId2SumMutilVou.get(orgId);
        } else {
            enableSumMutilVoucher = SystemParamHelper.getBooleanParam((String)"enable_sum_mutil_voucher", (long)orgId, (boolean)false);
            orgId2SumMutilVou.put(orgId, enableSumMutilVoucher);
        }
        DynamicObject clearPeriod = clearBill.getDynamicObject("clearperiod");
        String key = orgId + "_" + clearPeriod;
        if (orgIdAndPeriodId2SumHasVouMsg.containsKey(key)) {
            return orgIdAndPeriodId2SumHasVouMsg.get(key);
        }
        QFilter q1 = new QFilter("org.id", "=", (Object)orgId);
        QFilter q2 = new QFilter("period.id", ">", (Object)clearBill.getDynamicObject("clearperiod").getLong("id"));
        if (!enableSumMutilVoucher) {
            q2 = new QFilter("period.id", ">=", (Object)clearBill.getDynamicObject("clearperiod").getLong("id"));
        }
        DynamicObjectCollection depreSumList = QueryServiceHelper.query((String)"fa_depre_sum", (String)"id", (QFilter[])new QFilter[]{q1, q2});
        ArrayList<Object> depreSumIdSet = new ArrayList<Object>(16);
        for (DynamicObject depreSum : depreSumList) {
            depreSumIdSet.add(depreSum.get("id"));
        }
        if (FaDepreUtil.hashVouncherV2(depreSumIdSet, (String)"fa_depre_sum")) {
            if (!enableSumMutilVoucher) {
                orgIdAndPeriodId2SumHasVouMsg.put(key, curAndNextPeriodMsg);
                return curAndNextPeriodMsg;
            }
            orgIdAndPeriodId2SumHasVouMsg.put(key, nextPeriodMsg);
            return nextPeriodMsg;
        }
        return null;
    }
}

