/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.dataasset;

import java.text.ParseException;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.db.DBRoute;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.orm.util.StringUtils;
import kd.fi.fa.business.dataasset.DataAssetUtil;
import kd.fi.fa.common.util.DateUtil;

public class DataAssetDetailDisableOp
extends AbstractOperationServicePlugIn {
    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        Map variables = this.getOption().getVariables();
        String dataAssetIdStr = (String)variables.get("dataAssetId");
        String lastModifyTimeStr = (String)variables.get("lastModifyTime");
        if (StringUtils.isEmpty((Object)dataAssetIdStr) || StringUtils.isEmpty((Object)lastModifyTimeStr)) {
            throw new KDBizException("Parameter lost ! dataAssetId or lastModifyTime is empty !");
        }
        Date lastModifyTime = null;
        try {
            lastModifyTime = DateUtil.parseDate((String)lastModifyTimeStr, (String)"yyyy-MM-dd HH:mm:ss", (boolean)true);
        }
        catch (ParseException parseException) {
            throw new KDBizException(parseException.getMessage());
        }
        Set toDisableDetailIds = Arrays.stream(e.getDataEntities()).map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toSet());
        DataAssetUtil.updateDataAsset((DBRoute)DBRoute.of((String)"fa"), (Object)Long.valueOf(dataAssetIdStr), (Date)lastModifyTime, toDisableDetailIds);
    }
}

