/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.dataasset;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterBuildQueryParemeterEventArgs;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.entity.botp.plugin.args.AfterGetSourceDataEventArgs;
import kd.bos.exception.KDBizException;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.fi.fa.business.utils.FaMutexRequireUtil;

public class DataAssetToAssetCardBotpPlugin
extends AbstractConvertPlugIn {
    public void afterBuildQueryParemeter(AfterBuildQueryParemeterEventArgs e) {
        e.addSrcField("billno");
        e.addSrcField("id");
    }

    public void afterGetSourceData(AfterGetSourceDataEventArgs e) {
        String billNo;
        super.afterGetSourceData(e);
        List sourceRows = e.getSourceRows();
        HashSet<Long> allDataAssetIds = new HashSet<Long>(sourceRows.size());
        HashMap<Long, String> dataAssetMap = new HashMap<Long, String>(sourceRows.size());
        for (DynamicObject sourceRow : sourceRows) {
            long id = sourceRow.getLong("id");
            allDataAssetIds.add(id);
            billNo = sourceRow.getString("billno");
            dataAssetMap.put(id, billNo);
        }
        Set locks = FaMutexRequireUtil.requireMutexBatch((String)"fa_dataasset_card", allDataAssetIds, (String)"dataasset_mdf", (String)"detailmodify");
        allDataAssetIds.removeAll(locks);
        String modifyMessage = "";
        if (allDataAssetIds.size() > 0) {
            StringBuilder billNoSb = new StringBuilder();
            for (Long dataAssetId : allDataAssetIds) {
                billNo = (String)dataAssetMap.get(dataAssetId);
                if (billNo == null) continue;
                billNoSb.append(billNo).append(",");
            }
            String billNoStr = billNoSb.substring(0, billNoSb.length() - 1);
            modifyMessage = String.format(ResManager.loadKDString((String)"\u4e0b\u63a8\u5931\u8d25\uff0c\u767b\u8bb0\u7f16\u53f7\u4e3a[%s]\u7684\u6570\u636e\u8d44\u4ea7\u5361\u7247\u6b63\u5728\u4fee\u6539\u3002", (String)"DataAssetToAssetCardBotpPlugin_0", (String)"fi-fa-opplugin", (Object[])new Object[0]), billNoStr);
            this.getOption().setVariableValue("errorMsg", modifyMessage);
        }
        this.getOption().setVariableValue("dataObjIds", SerializationUtils.toJsonString((Object)locks));
    }

    public void afterConvert(AfterConvertEventArgs e) {
        Map variables = this.getOption().getVariables();
        String dataObjIdStr = (String)variables.get("dataObjIds");
        Set dataObjIds = new HashSet(16);
        if (!StringUtils.isEmpty((Object)dataObjIdStr)) {
            dataObjIds = (Set)SerializationUtils.fromJsonString((String)dataObjIdStr, Set.class);
        }
        ExtendedDataEntitySet entitySet = e.getTargetExtDataEntitySet();
        Map extDataEntityMap = entitySet.getExtDataEntityMap();
        for (Map.Entry entry : extDataEntityMap.entrySet()) {
            Iterator iterator = ((List)entry.getValue()).iterator();
            while (iterator.hasNext()) {
                ExtendedDataEntity extendedDataEntity = (ExtendedDataEntity)iterator.next();
                DynamicObject realCard = extendedDataEntity.getDataEntity();
                if (!dataObjIds.contains(realCard.getLong("srcbillid"))) {
                    iterator.remove();
                    continue;
                }
                realCard.set("assetamount", (Object)BigDecimal.ONE);
                realCard.set("isstoraged", (Object)true);
            }
        }
        String errorMsg = (String)variables.get("errorMsg");
        if (!CollectionUtils.isEmpty(dataObjIds)) {
            FaMutexRequireUtil.batchRelease((String)"fa_dataasset_card", dataObjIds, (String)"dataasset_mdf", (String)"detailmodify");
        } else if (!StringUtils.isEmpty((Object)errorMsg)) {
            throw new KDBizException(errorMsg);
        }
    }
}

