/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.depresetup;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.common.util.Fa;

public abstract class AbstractDepreSplitSetupValidator
extends AbstractValidator {
    protected void validateFutureSetup(String errorMsg) {
        HashSet<Long> cardIds = new HashSet<Long>(this.dataEntities.length);
        HashMap<String, List<ExtendedDataEntity>> orgGroupMap = new HashMap<String, List<ExtendedDataEntity>>(4);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject dataModel = dataEntity.getDataEntity();
            long orgId = dataModel.getLong(Fa.id((String)"org"));
            long depreUseId = dataModel.getLong(Fa.id((String)"depreuse"));
            long periodId = dataModel.getLong(Fa.id((String)"beginperiod"));
            List orgDatas = orgGroupMap.computeIfAbsent(orgId + "_" + depreUseId + "_" + periodId, v -> new ArrayList(100));
            orgDatas.add(dataEntity);
            long cardId = dataModel.getLong(Fa.id((String)"realcard"));
            cardIds.add(cardId);
        }
        this.validateFutureSetup(orgGroupMap, cardIds, errorMsg);
    }

    protected void validateFutureSetup(Map<String, List<ExtendedDataEntity>> orgGroupMap, Set<Long> cardIds, String errorMsg) {
        for (Map.Entry<String, List<ExtendedDataEntity>> orgEntry : orgGroupMap.entrySet()) {
            String key = orgEntry.getKey();
            long orgId = Long.parseLong(key.split("_")[0]);
            long depreUseId = Long.parseLong(key.split("_")[1]);
            long periodId = Long.parseLong(key.split("_")[2]);
            DynamicObjectCollection futureSetupCards = QueryServiceHelper.query((String)"fa_depresplitsetup", (String)Fa.comma((String[])new String[]{"org", "depreuse", "realcard"}), (QFilter[])new QFilter[]{new QFilter("realcard", "in", cardIds), new QFilter("org", "=", (Object)orgId), new QFilter("depreuse", "=", (Object)depreUseId), new QFilter("beginperiod", ">", (Object)periodId)});
            if (futureSetupCards.size() == 0) continue;
            Set futureSetupCardIds = futureSetupCards.stream().map(r -> r.getLong("realcard")).collect(Collectors.toSet());
            List<ExtendedDataEntity> orgDatas = orgEntry.getValue();
            for (ExtendedDataEntity dataEntity : orgDatas) {
                DynamicObject dataModel = dataEntity.getDataEntity();
                long cardId = dataModel.getLong(Fa.id((String)"realcard"));
                if (!futureSetupCardIds.contains(cardId)) continue;
                this.addErrorMessage(dataEntity, errorMsg);
            }
        }
    }
}

