/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.depresetup;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.fa.business.depretask.DepreSplitSum;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.opplugin.AbstractDepreSplitSetUpOpPlugin;
import kd.fi.fa.opplugin.DepreSumParam;
import kd.fi.fa.opplugin.depresetup.DepreSplitSetupInvalidValidator;

public class DepreSplitSetupInvalidOp
extends AbstractDepreSplitSetUpOpPlugin {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("org");
        e.getFieldKeys().add("depreuse");
        e.getFieldKeys().add(Fa.id((String)"depreuse"));
        e.getFieldKeys().add("beginperiod");
        e.getFieldKeys().add(Fa.id((String)"beginperiod"));
        e.getFieldKeys().add("realcard");
        e.getFieldKeys().add("realcard.masterid");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new DepreSplitSetupInvalidValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        HashMap<String, DynamicObject> orgBookMap = new HashMap<String, DynamicObject>(4);
        for (DynamicObject dataEntity : e.getDataEntities()) {
            long orgId = dataEntity.getLong(Fa.id((String)"org"));
            long depreUseId = dataEntity.getLong(Fa.id((String)"depreuse"));
            String orgKey = orgId + "_" + depreUseId;
            DynamicObject bookInfo = null;
            if (orgBookMap.containsKey(orgKey)) {
                bookInfo = (DynamicObject)orgBookMap.get(orgKey);
            } else {
                bookInfo = BusinessDataServiceHelper.loadSingleFromCache((String)"fa_assetbook", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("depreuse", "=", (Object)depreUseId)});
                orgBookMap.put(orgKey, bookInfo);
            }
            dataEntity.set("endperiod", bookInfo.get("curperiod"));
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        SaveServiceHelper.save((DynamicObject[])e.getDataEntities());
        DynamicObject[] datas = e.getDataEntities();
        HashMap allparams = new HashMap(datas.length);
        for (DynamicObject data : datas) {
            DepreSumParam param = new DepreSumParam();
            param.setOrgid(data.getLong("org.id"));
            param.setDepreuseid(data.getLong("depreuse.id"));
            param.setPeriodid(data.getLong("endperiod.id"));
            Set<Long> realcardcol = allparams.get(param) != null ? (Set)allparams.get(param) : new HashSet();
            realcardcol.add(data.getLong("realcard_id"));
            allparams.put(param, realcardcol);
        }
        for (Map.Entry next : allparams.entrySet()) {
            DepreSumParam param = (DepreSumParam)next.getKey();
            Set cardIds = (Set)next.getValue();
            new DepreSplitSum().updateDepreSplit4SetUp(Long.valueOf(param.getOrgid()), Long.valueOf(param.getDepreuseid()), Long.valueOf(param.getPeriodid()), Long.valueOf(99999999999L), true, cardIds);
        }
    }
}

