/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.depresetup;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.fa.business.utils.FaDepreUtil;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.opplugin.depresetup.AbstractDepreSplitSetupValidator;

public class DepreSplitSetupInvalidValidator
extends AbstractDepreSplitSetupValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        HashSet<Long> orgPks = new HashSet<Long>(4);
        HashSet<Long> depreUseIds = new HashSet<Long>(2);
        HashSet<Long> cardIds = new HashSet<Long>(dataEntities.length);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject dataModel = dataEntity.getDataEntity();
            long orgId = dataModel.getLong(Fa.id((String)"org"));
            long depreUseId = dataModel.getLong(Fa.id((String)"depreuse"));
            long cardId = dataModel.getLong(Fa.id((String)"realcard"));
            orgPks.add(orgId);
            depreUseIds.add(depreUseId);
            cardIds.add(cardId);
        }
        DynamicObject[] orgBooks = BusinessDataServiceHelper.load((String)"fa_assetbook", (String)Fa.comma((String[])new String[]{"org", "depreuse", "curperiod"}), (QFilter[])new QFilter[]{new QFilter("org", "in", orgPks), new QFilter("depreuse", "in", depreUseIds)});
        Map<String, DynamicObject> orgBookMap = Arrays.stream(orgBooks).collect(Collectors.toMap(book -> book.getLong(Fa.id((String)"org")) + "_" + book.getLong(Fa.id((String)"depreuse")), book -> book));
        HashMap<String, List<ExtendedDataEntity>> orgGroupMap = new HashMap<String, List<ExtendedDataEntity>>(4);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject dataModel = dataEntity.getDataEntity();
            long orgId = dataModel.getLong(Fa.id((String)"org"));
            long depreUseId = dataModel.getLong(Fa.id((String)"depreuse"));
            long periodId = dataModel.getLong(Fa.id((String)"beginperiod"));
            List orgDatas = orgGroupMap.computeIfAbsent(orgId + "_" + depreUseId + "_" + periodId, v -> new ArrayList(100));
            orgDatas.add(dataEntity);
        }
        this.validatePeriod(dataEntities, orgBookMap);
        this.validateFutureSetup(orgGroupMap, cardIds, ResManager.loadKDString((String)"\u5b58\u5728\u540e\u7eed\u671f\u95f4\u7684\u6298\u65e7\u5206\u644a\u8bbe\u7f6e\uff0c\u4e0d\u53ef\u4ee5\u5931\u6548\u3002", (String)"DepreSplitSetupInvalidValidator_0", (String)"fi-fa-opplugin", (Object[])new Object[0]));
        this.validateDepreSum(orgGroupMap, orgBookMap);
    }

    private void validatePeriod(ExtendedDataEntity[] dataEntities, Map<String, DynamicObject> orgBookMap) {
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject bookInfo;
            long currentPeriod;
            DynamicObject dataModel = dataEntity.getDataEntity();
            long orgId = dataModel.getLong(Fa.id((String)"org"));
            long depreUseId = dataModel.getLong(Fa.id((String)"depreuse"));
            long beginPeriod = dataModel.getLong(Fa.id((String)"beginperiod"));
            if (beginPeriod < (currentPeriod = (bookInfo = orgBookMap.get(orgId + "_" + depreUseId)).getLong(Fa.id((String)"curperiod")))) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6298\u65e7\u5206\u644a\u8bbe\u7f6e\u751f\u6548\u671f\u95f4\u5927\u4e8e\u7b49\u4e8e\u8d26\u7c3f\u5f53\u524d\u671f\u95f4\uff0c\u4e0d\u53ef\u4ee5\u5931\u6548\u3002", (String)"DepreSplitSetupInvalidValidator_1", (String)"fi-fa-opplugin", (Object[])new Object[0]));
        }
    }

    private void validateDepreSum(Map<String, List<ExtendedDataEntity>> orgGroupMap, Map<String, DynamicObject> orgBookMap) {
        for (Map.Entry<String, List<ExtendedDataEntity>> orgEntry : orgGroupMap.entrySet()) {
            String key = orgEntry.getKey();
            long orgId = Long.parseLong(key.split("_")[0]);
            long depreUseId = Long.parseLong(key.split("_")[1]);
            String bookKey = orgId + "_" + depreUseId;
            DynamicObject bookInfo = orgBookMap.get(bookKey);
            long currentPeriod = bookInfo.getLong(Fa.id((String)"curperiod"));
            boolean hasVoucher = FaDepreUtil.hasVoucher((Long)orgId, (Long)depreUseId, (Long)currentPeriod, (boolean)true);
            if (!hasVoucher) continue;
            for (ExtendedDataEntity dataEntity : orgEntry.getValue()) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u671f\u6216\u540e\u7eed\u671f\u95f4\u7684\u6298\u65e7\u6c47\u603b\u5df2\u7ecf\u751f\u6210\u51ed\u8bc1\uff0c\u4e0d\u53ef\u4ee5\u5931\u6548\u3002", (String)"DepreSplitSetupInvalidValidator_2", (String)"fi-fa-opplugin", (Object[])new Object[0]));
            }
        }
    }
}

