/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.lease;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Calendar;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.validate.BillStatus;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.fi.fa.business.lease.utils.LeaseUtil;
import kd.fi.fa.common.util.ContextUtil;
import kd.fi.fa.common.util.FaCurrencyUtil;
import kd.fi.fa.opplugin.lease.IFaAmortizeAlgorithm;

public abstract class FaAbstractAmortizeAlgorithm
implements IFaAmortizeAlgorithm {
    private static final Log log = LogFactory.getLog(FaAbstractAmortizeAlgorithm.class);
    DynamicObject leaseContract = null;
    DynamicObjectCollection rentSettleList = null;

    public FaAbstractAmortizeAlgorithm(DynamicObject leaseContract, DynamicObjectCollection rentSettleList) {
        this.leaseContract = leaseContract;
        this.rentSettleList = rentSettleList;
    }

    @Override
    public abstract void generateSettleDateRentList();

    @Override
    public BigDecimal computerIrr() {
        double leaseliab_negate;
        if (this.rentSettleList == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u751f\u6210\u7684\u7ed3\u7b97\u6570\u636e\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u8ba1\u7b97\u5185\u542b\u62a5\u916c\u7387\u3002", (String)"FaAbstractAmortizeAlgorithm_0", (String)"fi-fa-opplugin", (Object[])new Object[0]));
        }
        double[] income = new double[this.rentSettleList.size() + 1];
        income[0] = leaseliab_negate = this.leaseContract.getBigDecimal("leaseliab").negate().doubleValue();
        int incomeIndex = 1;
        for (DynamicObject rentSettle : this.rentSettleList) {
            double rent;
            income[incomeIndex] = rent = rentSettle.getBigDecimal("rent").doubleValue();
            ++incomeIndex;
        }
        double irr = LeaseUtil.irr((double[])income);
        log.info("\u8ba1\u7b97\u5185\u542b\u62a5\u916c\u7387irr\u8ba1\u7b97\u7ed3\u679c\u4e3a:" + irr);
        if (Double.isNaN(irr)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8ba1\u7b97\u5185\u542b\u62a5\u916c\u7387\u4e3a\u975e\u6570\u5b57NaN\uff0c\u65e0\u6cd5\u7ed3\u7b97\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"FaAbstractAmortizeAlgorithm_1", (String)"fi-fa-opplugin", (Object[])new Object[0]));
        }
        return BigDecimal.valueOf(irr).setScale(10, RoundingMode.HALF_UP);
    }

    @Override
    public void pack(BigDecimal irr) {
        String number = this.leaseContract.getString("number");
        Long orgId = this.leaseContract.getLong("org_id");
        Long contractId = (Long)this.leaseContract.getPkValue();
        Long currencyId = this.leaseContract.getLong("currency_id");
        int i = 1;
        BigDecimal previousliab = this.leaseContract.getBigDecimal("leaseliab");
        for (i = 1; i <= this.rentSettleList.size(); ++i) {
            DynamicObject rentSettle = (DynamicObject)this.rentSettleList.get(i - 1);
            rentSettle.set("billstatus", (Object)BillStatus.C.name());
            rentSettle.set("billno", (Object)(number + "_" + i));
            rentSettle.set("org_id", (Object)orgId);
            rentSettle.set("leasecontract_id", (Object)contractId);
            rentSettle.set("irr", (Object)irr.multiply(BigDecimal.valueOf(100L)));
            rentSettle.set("currency_id", (Object)currencyId);
            rentSettle.set("creator", (Object)ContextUtil.getUserId());
            rentSettle.set("createtime", (Object)TimeServiceHelper.now());
            if (i == this.rentSettleList.size()) {
                rentSettle.set("nextsettledate", (Object)rentSettle.getDate("settledate"));
            } else {
                DynamicObject nextRentSettle = (DynamicObject)this.rentSettleList.get(i);
                rentSettle.set("nextsettledate", (Object)nextRentSettle.getDate("settledate"));
            }
            int settledateMonth = this.formatDate(rentSettle.getDate("settledate"));
            rentSettle.set("settledatemonth", (Object)settledateMonth);
            if (i == this.rentSettleList.size()) {
                rentSettle.set("nextsettledatemonth", (Object)this.formatDate(rentSettle.getDate("settledate")));
            } else {
                DynamicObject nextRentSettle = (DynamicObject)this.rentSettleList.get(i);
                rentSettle.set("nextsettledatemonth", (Object)this.formatDate(nextRentSettle.getDate("settledate")));
            }
            BigDecimal rent = rentSettle.getBigDecimal("rent");
            DynamicObject currency = this.leaseContract.getDynamicObject("currency");
            BigDecimal interst = previousliab.multiply(irr);
            interst = FaCurrencyUtil.parseByCurAmtPrecision((DynamicObject)currency, (BigDecimal)interst);
            BigDecimal principal = rent.subtract(interst);
            BigDecimal endleaseliab = previousliab.add(interst).subtract(rent);
            if (i == this.rentSettleList.size()) {
                endleaseliab = BigDecimal.ZERO;
                principal = previousliab;
                interst = rent.subtract(principal);
            }
            rentSettle.set("interest", (Object)interst);
            rentSettle.set("principal", (Object)principal);
            rentSettle.set("endleaseliab", (Object)endleaseliab);
            previousliab = endleaseliab;
        }
    }

    private int formatDate(Date date) {
        Calendar selCal = Calendar.getInstance();
        selCal.setTime(date);
        String selMonth = selCal.get(2) + 1 < 10 ? "0" + (selCal.get(2) + 1) : selCal.get(2) + 1 + "";
        String selYear = selCal.get(1) + "";
        int settledateMonth = Integer.parseInt(selYear + selMonth + "00");
        return settledateMonth;
    }

    @Override
    public void afterPack() {
    }

    @Override
    public void generateSettleData() {
        this.generateSettleDateRentList();
        BigDecimal irr = this.computerIrr();
        this.pack(irr);
        this.afterPack();
    }
}

