/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.lease;

import java.math.BigDecimal;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.fa.business.dao.factory.FaBaseDaoFactory;
import kd.fi.fa.business.lease.utils.LeaseAmortizeSchemeUtil;
import kd.fi.fa.business.lease.utils.LeaseUtil;
import kd.fi.fa.business.utils.SystemParamHelper;
import kd.fi.fa.common.util.DateUtil;
import kd.fi.fa.opplugin.lease.FaAbstractAmortizeAlgorithm;

public class FaAmortizeSchemeThird
extends FaAbstractAmortizeAlgorithm {
    private static final Log log = LogFactory.getLog(FaAmortizeSchemeThird.class);

    public FaAmortizeSchemeThird(DynamicObject leaseContract, DynamicObjectCollection rentSettleList) {
        super(leaseContract, rentSettleList);
    }

    @Override
    public void generateSettleDateRentList() {
        DynamicObjectCollection payPlanList = this.leaseContract.getDynamicObjectCollection("payplanentryentity");
        String payPeriod = this.leaseContract.getString("payperiod");
        Date initConfirmDate = this.leaseContract.getDate("initconfirmdate");
        int periodMonths = LeaseAmortizeSchemeUtil.getPeriodMonths((String)payPeriod);
        Object[] payPlanArray = new DynamicObject[payPlanList.size()];
        payPlanArray = (DynamicObject[])payPlanList.toArray(payPlanArray);
        Object firstPayPlan = payPlanArray[0];
        Date firstPayPlanDate = firstPayPlan.getDate("planpaydate");
        int payPlanArrayIndex = 0;
        Date rangeToDate = DateUtil.addMonth((Date)initConfirmDate, (int)periodMonths);
        if (rangeToDate.compareTo(firstPayPlanDate) <= 0) {
            this.generateRentIsZeroList(initConfirmDate, 1, firstPayPlanDate);
        }
        if (firstPayPlanDate.before(initConfirmDate)) {
            payPlanArrayIndex = LeaseAmortizeSchemeUtil.getPayPlanItemIndexInRange((Date)initConfirmDate, (DynamicObject[])payPlanArray);
        }
        if (payPlanArrayIndex < 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u521d\u59cb\u786e\u8ba4\u65e5\u671f\u5927\u4e8e\u6240\u6709\u7684\u8ba1\u5212\u4ed8\u6b3e\u65e5\u671f\uff0c\u65e0\u6cd5\u505a\u79df\u91d1\u7ed3\u7b97\u3002", (String)"FaAmortizeSchemeThird_0", (String)"fi-fa-opplugin", (Object[])new Object[0]));
        }
        while (payPlanArrayIndex < payPlanArray.length) {
            Object currentPayPlan = payPlanArray[payPlanArrayIndex];
            this.generateSettleDateRent(this.leaseContract, (DynamicObject)currentPayPlan, periodMonths);
            ++payPlanArrayIndex;
        }
    }

    private void generateRentIsZeroList(Date initConfirmDate, int periodMonths, Date firstPayPlanDate) {
        Date rangeFromDate = initConfirmDate;
        Date rangeToDate = DateUtil.addMonth((Date)rangeFromDate, (int)periodMonths);
        while (rangeToDate.compareTo(firstPayPlanDate) <= 0) {
            DynamicObject entry = FaBaseDaoFactory.getInstance((String)"fa_lease_rent_settle").getEmptyDynamicObject();
            entry.set("settledate", (Object)rangeFromDate);
            entry.set("rent", (Object)BigDecimal.ZERO);
            this.rentSettleList.add((Object)entry);
            rangeFromDate = rangeToDate;
            rangeToDate = DateUtil.addMonth((Date)rangeFromDate, (int)periodMonths);
        }
    }

    private void generateSettleDateRent(DynamicObject leaseContract, DynamicObject currentPayPlan, int periodMonths) {
        Date currentPayPlanDate = currentPayPlan.getDate("planpaydate");
        boolean isdeductible = leaseContract.getBoolean("isdeductible");
        Long orgId = leaseContract.getLong("org_id");
        boolean is_deduct_vat_discount = SystemParamHelper.getBooleanParam((String)"is_deduct_vat_discount", (long)orgId, (boolean)false);
        BigDecimal currentSettleRent = LeaseUtil.getSettleRent((DynamicObject)currentPayPlan, (boolean)isdeductible, (boolean)is_deduct_vat_discount);
        log.info("\u751f\u6210\u79df\u91d1\u4fe1\u606f\uff1aisdeductible:" + isdeductible + ",orgId" + orgId + ",is_deduct_vat_discount" + is_deduct_vat_discount + "currentSettleRent," + currentSettleRent);
        DynamicObject currency = leaseContract.getDynamicObject("currency");
        int currencyAmtprecision = currency.getInt("amtprecision");
        BigDecimal monthSettleRent = currentSettleRent.divide(BigDecimal.valueOf(periodMonths), currencyAmtprecision, 4);
        BigDecimal addedSettleRent = BigDecimal.ZERO;
        for (int i = 0; i < periodMonths; ++i) {
            DynamicObject entry = FaBaseDaoFactory.getInstance((String)"fa_lease_rent_settle").getEmptyDynamicObject();
            entry.set("settledate", (Object)currentPayPlanDate);
            if (i < periodMonths - 1) {
                entry.set("rent", (Object)monthSettleRent);
                addedSettleRent = addedSettleRent.add(monthSettleRent);
            } else {
                entry.set("rent", (Object)currentSettleRent.subtract(addedSettleRent));
            }
            this.rentSettleList.add((Object)entry);
            currentPayPlanDate = DateUtil.addMonth((Date)currentPayPlanDate, (int)1);
        }
    }
}

