/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.lease;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.BillStatus;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.fa.business.BizStatusEnum;
import kd.fi.fa.business.enums.lease.LeaseContractSourceType;
import kd.fi.fa.business.validator.changeitem.ChangeItemSelectValidator;
import kd.fi.fa.common.util.DateUtil;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.opplugin.lease.FaLeaseChangeBillPushValidator;

public class FaLeaseChangeBillPushOp
extends AbstractOperationServicePlugIn {
    private static final String IS_ADJUST_DEP_RE_0 = "0";
    private static final String IS_ADJUST_DEP_RE_1 = "1";
    private static final String FA_CARD_REAL = "fa_card_real";
    private static final String M_BEF = "m_bef_";
    private static final String M_AFT = "m_aft_";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("aftcontract");
        fieldKeys.add("befcontract");
        fieldKeys.add("changeitems");
        fieldKeys.add("billno");
        fieldKeys.add("creator");
        fieldKeys.add("remark");
        fieldKeys.add("leasecontract");
        fieldKeys.add("effectivedate");
        fieldKeys.add("auditdate");
        fieldKeys.add("pushstatus");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new FaLeaseChangeBillPushValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] bills;
        super.beginOperationTransaction(e);
        for (DynamicObject bill : bills = e.getDataEntities()) {
            this.pushAssetChangeBill(bill);
            bill.set("pushstatus", (Object)"C");
        }
        SaveServiceHelper.save((DynamicObject[])bills);
    }

    public void pushAssetChangeBill(DynamicObject leaseChangeBill) {
        String leaseChangeBillNo = leaseChangeBill.getString("billno");
        DynamicObjectCollection leaseChangeItemCollection = this.getChangeItemCollection(leaseChangeBill);
        Set<Long> leaseChangeItemSet = leaseChangeItemCollection.stream().map(v -> v.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toSet());
        DynamicObjectCollection changeMappingCollection = FaLeaseChangeBillPushOp.getAssetChangeFieldByLeaseChange(leaseChangeItemSet, leaseChangeBillNo);
        Set<Long> assetChangeItemSet = changeMappingCollection.stream().map(v -> v.getLong("cardchgitem")).collect(Collectors.toSet());
        DynamicObjectCollection changeItemCollection = this.getChangeItemColl(leaseChangeItemSet, assetChangeItemSet);
        FaLeaseChangeBillPushOp.checkAssetChangeBillItem(changeItemCollection);
        Map<Long, String> changeItemMapping = FaLeaseChangeBillPushOp.processChangeItemMapping(changeMappingCollection, changeItemCollection);
        DynamicObjectCollection assetChangeItemColl = this.getAssetChangeItemColl(leaseChangeBillNo, assetChangeItemSet, changeItemCollection);
        Map<String, DynamicObjectCollection> assetChangeItemIsDepMap = FaLeaseChangeBillPushOp.getAssetChangeItemIsDepMap(assetChangeItemColl);
        DynamicObject realCard = this.getRealCard(leaseChangeBill);
        DynamicObject finCard = this.getFinCardByRealCard(leaseChangeBillNo, realCard);
        ArrayList<DynamicObject> changeBillList = new ArrayList<DynamicObject>(4);
        for (Map.Entry<String, DynamicObjectCollection> collectionEntry : assetChangeItemIsDepMap.entrySet()) {
            DynamicObject changeBill = this.generateChangeBillByChangeItems(leaseChangeBill, changeItemMapping, realCard, finCard, collectionEntry);
            FaLeaseChangeBillPushOp.submitAssetChangeBill(changeBill);
            FaLeaseChangeBillPushOp.auditAssetChangeBill(changeBill);
            changeBillList.add(changeBill);
        }
        FaLeaseChangeBillPushOp.updateAuditDateByMoreChangeBill(changeBillList);
    }

    private DynamicObjectCollection getChangeItemCollection(DynamicObject leaseChangeBill) {
        DynamicObjectCollection leaseChangeItemCollection = leaseChangeBill.getDynamicObjectCollection("changeitems");
        Iterator iterator = leaseChangeItemCollection.iterator();
        while (iterator.hasNext()) {
            int aftDepReMonths;
            DynamicObject aftContract;
            DynamicObject befContract;
            DynamicObject leaseChangeItem = (DynamicObject)iterator.next();
            DynamicObject baseData = leaseChangeItem.getDynamicObject("fbasedataid");
            String number = baseData.getString("number");
            if ("payruleentryentity".equals(number)) {
                BigDecimal aftDecimal;
                befContract = leaseChangeBill.getDynamicObject("befcontract");
                aftContract = leaseChangeBill.getDynamicObject("aftcontract");
                BigDecimal befDecimal = befContract.getBigDecimal("leaseassets") == null ? BigDecimal.ZERO : befContract.getBigDecimal("leaseassets");
                if (befDecimal.compareTo(aftDecimal = aftContract.getBigDecimal("leaseassets") == null ? BigDecimal.ZERO : aftContract.getBigDecimal("leaseassets")) != 0) continue;
                iterator.remove();
                continue;
            }
            if (!"leaseenddate".equals(number)) continue;
            befContract = leaseChangeBill.getDynamicObject("befcontract");
            aftContract = leaseChangeBill.getDynamicObject("aftcontract");
            int befDepReMonths = befContract.getInt("depremonths");
            if (befDepReMonths != (aftDepReMonths = aftContract.getInt("depremonths"))) continue;
            iterator.remove();
        }
        if (leaseChangeItemCollection.isEmpty()) {
            String leaseChangeBillNo = leaseChangeBill.getString("billno");
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u79df\u8d41\u53d8\u66f4\u5355\u7f16\u53f7\uff1a%s \u53d8\u66f4\u524d\u540e\u7684\u503c\u672a\u53d1\u751f\u53d8\u5316\uff0c\u4e0d\u80fd\u4e0b\u63a8\u8d44\u4ea7\u53d8\u66f4\u5355", (String)"FaLeaseChangeBillPushOp_0", (String)"fi-fa-opplugin", (Object[])new Object[0]), leaseChangeBillNo));
        }
        return leaseChangeItemCollection;
    }

    private static DynamicObjectCollection getAssetChangeFieldByLeaseChange(Set<Long> leaseChangeItemSet, String leaseChangeBillNo) {
        DynamicObjectCollection changeMappingCollection = QueryServiceHelper.query((String)"fa_change_map", (String)"leasechgitem, cardchgitem", (QFilter[])new QFilter[]{new QFilter("leasechgitem", "in", leaseChangeItemSet)});
        if (changeMappingCollection.isEmpty()) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u79df\u8d41\u53d8\u66f4\u5355\u7f16\u53f7\uff1a%s \u79df\u8d41\u53d8\u66f4\u9879\u5bf9\u5e94\u7684\u8d44\u4ea7\u53d8\u66f4\u9879\u4e0d\u5b58\u5728\uff0c\u4e0d\u80fd\u4e0b\u63a8\u8d44\u4ea7\u53d8\u66f4\u5355", (String)"FaLeaseChangeBillPushOp_1", (String)"fi-fa-opplugin", (Object[])new Object[0]), leaseChangeBillNo));
        }
        return changeMappingCollection;
    }

    private DynamicObjectCollection getChangeItemColl(Set<Long> leaseChangeItemSet, Set<Long> assetChangeItemSet) {
        HashSet<Long> changeItemSet = new HashSet<Long>(16);
        changeItemSet.addAll(leaseChangeItemSet);
        changeItemSet.addAll(assetChangeItemSet);
        return QueryServiceHelper.query((String)"fa_change_item", (String)Fa.comma((String[])new String[]{"id", "number", "topic"}), (QFilter[])new QFilter[]{new QFilter("id", "in", changeItemSet)});
    }

    private static void checkAssetChangeBillItem(DynamicObjectCollection changeItemCollection) {
        HashMap<String, String> mappingChangeItemMap = new HashMap<String, String>(8);
        for (DynamicObject changeItem : changeItemCollection) {
            if (!FA_CARD_REAL.equals(changeItem.getString("topic")) && !"fa_card_fin".equals(changeItem.getString("topic"))) continue;
            mappingChangeItemMap.put(changeItem.getString("number"), changeItem.getString("topic"));
        }
        Set changeBillFields = ((EntityType)EntityMetadataCache.getDataEntityType((String)"fa_change_dept").getAllEntities().get("main_changebillentry")).getFields().keySet();
        HashSet<String> changeBillLessDataSet = new HashSet<String>(4);
        for (Map.Entry mappingChangeItem : mappingChangeItemMap.entrySet()) {
            String key = (String)mappingChangeItem.getKey();
            String value = (String)mappingChangeItem.getValue();
            if (changeBillFields.contains(M_BEF + key) && changeBillFields.contains(M_AFT + key)) continue;
            changeBillLessDataSet.add(((IDataEntityProperty)((EntityType)EntityMetadataCache.getDataEntityType((String)value).getAllEntities().get(value)).getProperties().get((Object)key)).getDisplayName().toString());
        }
        if (!changeBillLessDataSet.isEmpty()) {
            String changeBillLessData = String.join((CharSequence)", ", changeBillLessDataSet);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%s \u5728\u8d44\u4ea7\u53d8\u66f4\u5355\u4e0a\u4e0d\u5b58\u5728\uff0c\u4e0d\u80fd\u4e0b\u63a8\u8d44\u4ea7\u53d8\u66f4\u5355", (String)"FaLeaseChangeBillPushOp_2", (String)"fi-fa-opplugin", (Object[])new Object[0]), changeBillLessData));
        }
    }

    private static Map<Long, String> processChangeItemMapping(DynamicObjectCollection changeMappingCollection, DynamicObjectCollection changeItemCollection) {
        HashMap<Long, String> mappingMap = new HashMap<Long, String>(8);
        for (DynamicObject changeItem : changeItemCollection) {
            for (DynamicObject changeMapping : changeMappingCollection) {
                if (changeItem.getLong("id") != changeMapping.getLong("leasechgitem")) continue;
                mappingMap.put(changeMapping.getLong("cardchgitem"), changeItem.getString("number"));
            }
        }
        return mappingMap;
    }

    private DynamicObjectCollection getAssetChangeItemColl(String leaseChangeBillNo, Set<Long> assetChangeItemSet, DynamicObjectCollection changeItemCollection) {
        DynamicObjectCollection assetChangeItemColl = new DynamicObjectCollection();
        for (DynamicObject changeItem : changeItemCollection) {
            if (!assetChangeItemSet.contains(changeItem.getLong("id"))) continue;
            assetChangeItemColl.add((Object)changeItem);
        }
        if (assetChangeItemColl.isEmpty()) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u79df\u8d41\u53d8\u66f4\u5355\u7f16\u53f7\uff1a%s \u79df\u8d41\u53d8\u66f4\u9879\u5bf9\u5e94\u7684\u8d44\u4ea7\u53d8\u66f4\u9879\u4e0d\u5b58\u5728\uff0c\u4e0d\u80fd\u4e0b\u63a8\u8d44\u4ea7\u53d8\u66f4\u5355", (String)"FaLeaseChangeBillPushOp_1", (String)"fi-fa-opplugin", (Object[])new Object[0]), leaseChangeBillNo));
        }
        return assetChangeItemColl;
    }

    private static Map<String, DynamicObjectCollection> getAssetChangeItemIsDepMap(DynamicObjectCollection assetChangeItemColl) {
        HashMap<String, DynamicObjectCollection> assetChangeItemIsDepMap = new HashMap<String, DynamicObjectCollection>(8);
        for (DynamicObject changeItem : assetChangeItemColl) {
            boolean isDep = ChangeItemSelectValidator.isDepreChangeItem((DynamicObject)changeItem);
            if (isDep) {
                DynamicObjectCollection impact = (DynamicObjectCollection)assetChangeItemIsDepMap.get(IS_ADJUST_DEP_RE_1);
                if (impact == null || impact.isEmpty()) {
                    impact = new DynamicObjectCollection();
                    assetChangeItemIsDepMap.put(IS_ADJUST_DEP_RE_1, impact);
                }
                impact.add((Object)changeItem);
                continue;
            }
            DynamicObjectCollection noImpact = (DynamicObjectCollection)assetChangeItemIsDepMap.get(IS_ADJUST_DEP_RE_0);
            if (noImpact == null || noImpact.isEmpty()) {
                noImpact = new DynamicObjectCollection();
                assetChangeItemIsDepMap.put(IS_ADJUST_DEP_RE_0, noImpact);
            }
            noImpact.add((Object)changeItem);
        }
        return assetChangeItemIsDepMap;
    }

    private DynamicObject getRealCard(DynamicObject leaseChangeBill) {
        DynamicObject leaseContract = leaseChangeBill.getDynamicObject("leasecontract");
        long leaseContractId = leaseContract.getLong("id");
        String leaseChangeBillNo = leaseChangeBill.getString("billno");
        Map targetBills = BFTrackerServiceHelper.findTargetBills((String)"fa_lease_contract", (Long[])new Long[]{leaseContractId});
        HashSet cardIds = (HashSet)targetBills.get(FA_CARD_REAL);
        if (cardIds == null || cardIds.size() == 0) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u79df\u8d41\u53d8\u66f4\u5355\u7f16\u53f7\uff1a%s \u5bf9\u5e94\u7684\u5408\u540c\u751f\u6210\u7684\u5b9e\u7269\u5361\u7247\u4e0d\u5b58\u5728\uff0c\u4e0d\u80fd\u4e0b\u63a8\u8d44\u4ea7\u53d8\u66f4\u5355", (String)"FaLeaseChangeBillPushOp_3", (String)"fi-fa-opplugin", (Object[])new Object[0]), leaseChangeBillNo));
        }
        QFilter[] readCardFilter = new QFilter[]{new QFilter("id", "in", (Object)cardIds)};
        DynamicObject realCard = BusinessDataServiceHelper.loadSingleFromCache((String)FA_CARD_REAL, (QFilter[])readCardFilter);
        if (realCard == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u79df\u8d41\u53d8\u66f4\u5355\u7f16\u53f7\uff1a%s \u5bf9\u5e94\u7684\u5408\u540c\u751f\u6210\u7684\u5b9e\u7269\u5361\u7247\u4e0d\u5b58\u5728\uff0c\u4e0d\u80fd\u4e0b\u63a8\u8d44\u4ea7\u53d8\u66f4\u5355", (String)"FaLeaseChangeBillPushOp_3", (String)"fi-fa-opplugin", (Object[])new Object[0]), leaseChangeBillNo));
        }
        if (!BizStatusEnum.READY.name().equals(realCard.getString("bizstatus"))) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u79df\u8d41\u53d8\u66f4\u5355\u7f16\u53f7\uff1a%s \u5bf9\u5e94\u7684\u5408\u540c\u751f\u6210\u7684\u5b9e\u7269\u5361\u7247\u4e0d\u662f\u5c31\u7eea\u72b6\u6001\uff0c\u4e0d\u80fd\u4e0b\u63a8\u8d44\u4ea7\u53d8\u66f4\u5355", (String)"FaLeaseChangeBillPushOp_4", (String)"fi-fa-opplugin", (Object[])new Object[0]), leaseChangeBillNo));
        }
        return realCard;
    }

    private DynamicObject getFinCardByRealCard(String leaseChangeBillNo, DynamicObject realCard) {
        QFilter[] finCardFilter = new QFilter[]{new QFilter("realcardmasterid", "=", (Object)realCard.getLong("id")), new QFilter("endperiod", "=", (Object)99999999999L)};
        Map finCardMap = BusinessDataServiceHelper.loadFromCache((String)"fa_card_fin", (QFilter[])finCardFilter);
        if (finCardMap.size() != 1) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u79df\u8d41\u53d8\u66f4\u5355\u7f16\u53f7\uff1a%s \u5bf9\u5e94\u7684\u5408\u540c\u751f\u6210\u7684\u5b9e\u7269\u5361\u7247\u4e0b\u63a8\u8d22\u52a1\u5361\u7247\u4e0d\u552f\u4e00", (String)"FaLeaseChangeBillPushOp_5", (String)"fi-fa-opplugin", (Object[])new Object[0]), leaseChangeBillNo));
        }
        DynamicObject finCard = null;
        for (Map.Entry dynamicObjectEntry : finCardMap.entrySet()) {
            finCard = (DynamicObject)dynamicObjectEntry.getValue();
        }
        if (finCard == null || !BillStatus.C.name().equals(finCard.getString("billstatus"))) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u79df\u8d41\u53d8\u66f4\u5355\u7f16\u53f7\uff1a%s \u5bf9\u5e94\u7684\u5408\u540c\u4e0d\u5b58\u5728\u5173\u8054\u5361\u7247\u6216\u5173\u8054\u5361\u7247\u672a\u5ba1\u6838\uff0c\u4e0d\u9700\u8981\u4e0b\u63a8\u8d44\u4ea7\u53d8\u66f4\u5355", (String)"FaLeaseChangeBillPushOp_6", (String)"fi-fa-opplugin", (Object[])new Object[0]), leaseChangeBillNo));
        }
        return finCard;
    }

    private DynamicObject generateChangeBillByChangeItems(DynamicObject leaseChangeBill, Map<Long, String> changeItemMapping, DynamicObject realCard, DynamicObject finCard, Map.Entry<String, DynamicObjectCollection> collectionEntry) {
        DynamicObject aftContract = leaseChangeBill.getDynamicObject("aftcontract");
        DynamicObject org = aftContract.getDynamicObject("org");
        DynamicObject mainBookByOrg = FaLeaseChangeBillPushOp.getMainBookByOrg(org.getLong("id"));
        Date endDate = mainBookByOrg.getDate(Fa.dot((String[])new String[]{"curperiod", "enddate"}));
        endDate = DateUtil.stripTime((Date)endDate);
        String isAdjustDep = collectionEntry.getKey();
        if (IS_ADJUST_DEP_RE_1.equals(isAdjustDep)) {
            String sourceType = aftContract.getString("sourcetype");
            Date effectiveDate = leaseChangeBill.getDate("effectivedate");
            if (LeaseContractSourceType.A.name().equals(sourceType)) {
                Date initConfirmDate = aftContract.getDate("initconfirmdate");
                Date leaseTermStartDate = aftContract.getDate("leasetermstartdate");
                if (effectiveDate.compareTo(initConfirmDate) == 0 || effectiveDate.compareTo(leaseTermStartDate) == 0) {
                    isAdjustDep = IS_ADJUST_DEP_RE_0;
                }
            } else {
                Date sysSwitchDate = aftContract.getDate("sysswitchdate");
                if (effectiveDate.compareTo(sysSwitchDate) == 0) {
                    isAdjustDep = IS_ADJUST_DEP_RE_0;
                }
            }
        }
        DynamicObjectCollection assetChangeItemColls = collectionEntry.getValue();
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"fa_change_dept");
        DynamicObject changeBill = new DynamicObject((DynamicObjectType)type);
        changeBill.set("org", (Object)org);
        changeBill.set("changedate", (Object)endDate);
        changeBill.set("appliantid", leaseChangeBill.get("creator"));
        changeBill.set("remark", (Object)leaseChangeBill.getString("remark"));
        changeBill.set("billstatus", (Object)BillStatus.A);
        changeBill.set("sourcetype", (Object)Character.valueOf('4'));
        changeBill.set("sourceid", (Object)leaseChangeBill.getLong("id"));
        Set<Long> changItemIdSet = assetChangeItemColls.stream().map(v -> v.getLong("id")).collect(Collectors.toSet());
        Long changeTypeId = FaLeaseChangeBillPushOp.getChangeType4ChangItem(changItemIdSet);
        changeBill.set(Fa.id((String)"changetype"), (Object)changeTypeId);
        DynamicObjectCollection assetChangeItemCollection = changeBill.getDynamicObjectCollection("changeitem");
        for (DynamicObject changeItem : assetChangeItemColls) {
            DynamicObject assetChangeItemObject = assetChangeItemCollection.addNew();
            assetChangeItemObject.set("fbasedataid", (Object)changeItem);
            assetChangeItemObject.set("fbasedataid_id", (Object)changeItem.getLong("id"));
        }
        DynamicObjectCollection fieldEntryCollection = changeBill.getDynamicObjectCollection("fieldentry");
        for (int i = 0; i < assetChangeItemColls.size(); ++i) {
            this.generateChangeBillFieldEntry(leaseChangeBill, changeItemMapping, realCard, finCard, isAdjustDep, assetChangeItemColls, fieldEntryCollection, i);
        }
        DynamicObjectCollection realEntryCollection = changeBill.getDynamicObjectCollection("realentry");
        DynamicObject realEntry = realEntryCollection.addNew();
        realEntry.set("seq", (Object)1);
        realEntry.set("realcard", (Object)realCard);
        DynamicObject realEntryChild = (DynamicObject)realEntryCollection.get(0);
        DynamicObjectCollection finEntry = realEntryChild.getDynamicObjectCollection("finentry");
        DynamicObject fin = finEntry.addNew();
        fin.set("seq", (Object)1);
        fin.set("fincard", (Object)finCard);
        fin.set("currency", (Object)finCard.getDynamicObject("basecurrency"));
        fin.set("depreuse", (Object)finCard.getDynamicObject("depreuse"));
        fin.set("isadjustdepre", (Object)isAdjustDep);
        fin.set("bizdate", (Object)leaseChangeBill.getDate("effectivedate"));
        MainEntityType changeBillType = EntityMetadataCache.getDataEntityType((String)"fa_change_dept");
        DynamicObjectType billHeadType = ((EntryProp)changeBillType.getProperty("billhead_lk")).getDynamicCollectionItemPropertyType();
        Long changeBillTableId = EntityMetadataCache.loadTableDefine((String)"fa_lease_change_bill", (String)"fa_lease_change_bill").getTableId();
        DynamicObjectCollection billHeads = changeBill.getDynamicObjectCollection("billhead_lk");
        DynamicObject billHead = new DynamicObject(billHeadType);
        billHead.set("billhead_lk_stableid", (Object)changeBillTableId);
        billHead.set("billhead_lk_sbillid", leaseChangeBill.getPkValue());
        billHead.set("billhead_lk_sid", leaseChangeBill.getPkValue());
        billHead.set("seq", (Object)1);
        billHeads.add((Object)billHead);
        return changeBill;
    }

    private void generateChangeBillFieldEntry(DynamicObject leaseChangeBill, Map<Long, String> changeItemMapping, DynamicObject realCard, DynamicObject finCard, String isAdjustDep, DynamicObjectCollection assetChangeItemColls, DynamicObjectCollection fieldEntryCollection, int i) {
        boolean isDynamic;
        DynamicObject aftContract = leaseChangeBill.getDynamicObject("aftcontract");
        DynamicObject fieldEntry = fieldEntryCollection.addNew();
        fieldEntry.set("seq", (Object)(i + 1));
        fieldEntry.set("realcard1", (Object)realCard);
        fieldEntry.set("assetnumber", (Object)realCard.getString("number"));
        fieldEntry.set("depreuse1", (Object)finCard.getDynamicObject("depreuse"));
        fieldEntry.set("currency1", (Object)finCard.getDynamicObject("currency"));
        fieldEntry.set("basecurrency1", (Object)finCard.getDynamicObject("basecurrency"));
        fieldEntry.set("fincard1", (Object)finCard);
        DynamicObject changeItem = (DynamicObject)assetChangeItemColls.get(i);
        String field = Fa.dot((String[])new String[]{changeItem.getString("topic"), changeItem.getString("number")});
        fieldEntry.set("field", (Object)field);
        if (FA_CARD_REAL.equals(changeItem.getString("topic"))) {
            isDynamic = ((IDataEntityProperty)realCard.getDataEntityType().getProperties().get((Object)changeItem.getString("number"))).getPropertyType().isAssignableFrom(DynamicObject.class);
            if (isDynamic) {
                fieldEntry.set("beforevalue", realCard.get(Fa.id((String)changeItem.getString("number"))));
            } else {
                fieldEntry.set("beforevalue", realCard.get(changeItem.getString("number")));
            }
        } else {
            isDynamic = ((IDataEntityProperty)finCard.getDataEntityType().getProperties().get((Object)changeItem.getString("number"))).getPropertyType().isAssignableFrom(DynamicObject.class);
            if (isDynamic) {
                fieldEntry.set("beforevalue", finCard.get(Fa.id((String)changeItem.getString("number"))));
            } else {
                fieldEntry.set("beforevalue", finCard.get(changeItem.getString("number")));
            }
        }
        String leaseField = changeItemMapping.get(changeItem.getLong("id"));
        if ("payruleentryentity".equals(leaseField) || "discountrate".equals(leaseField)) {
            fieldEntry.set("aftervalue", aftContract.get("leaseassets"));
        } else if ("leaseenddate".equals(leaseField)) {
            fieldEntry.set("aftervalue", aftContract.get("depremonths"));
        } else if (isDynamic) {
            fieldEntry.set("aftervalue", aftContract.get(Fa.id((String)leaseField)));
        } else {
            fieldEntry.set("aftervalue", aftContract.get(leaseField));
        }
        fieldEntry.set("reason", (Object)leaseChangeBill.getString("remark"));
        fieldEntry.set("isadjustdepre1", (Object)isAdjustDep);
        fieldEntry.set("bizdate1", (Object)leaseChangeBill.getDate("effectivedate"));
    }

    private static void updateAuditDateByMoreChangeBill(List<DynamicObject> changeBillList) {
        if (changeBillList.size() > 1) {
            Long changeBillId = changeBillList.get(1).getLong("id");
            DynamicObject changeBill = BusinessDataServiceHelper.loadSingleFromCache((String)"fa_change_dept", (String)"auditdate", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)changeBillId)});
            Date date = changeBill.getDate("auditdate");
            Calendar c = Calendar.getInstance();
            c.setTime(date);
            c.add(13, 1);
            changeBill.set("auditdate", (Object)c.getTime());
            SaveServiceHelper.update((DynamicObject)changeBill);
        }
    }

    private static void submitAssetChangeBill(DynamicObject changeBill) {
        OperateOption option = OperateOption.create();
        option.setVariableValue("WF", "FALSE");
        option.setVariableValue("ishasright", String.valueOf(true));
        OperationResult saveResult = OperationServiceHelper.executeOperate((String)"submit", (String)"fa_change_dept", (DynamicObject[])new DynamicObject[]{changeBill}, (OperateOption)option);
        if (!saveResult.isSuccess()) {
            List allError = saveResult.getAllErrorOrValidateInfo();
            StringBuilder errorInfo = new StringBuilder();
            if (!CollectionUtils.isEmpty((Collection)allError)) {
                for (IOperateInfo in : allError) {
                    errorInfo.append(in.getMessage());
                }
            }
            String msg = String.format("%s%s-%s", ResManager.loadKDString((String)"\u63d0\u4ea4\u8d44\u4ea7\u53d8\u66f4\u5355\u5931\u8d25\u3002", (String)"FaLeaseChangeBillPushOp_7", (String)"fi-fa-opplugin", (Object[])new Object[0]), saveResult.getMessage(), errorInfo.toString());
            throw new KDBizException(msg);
        }
    }

    public static void auditAssetChangeBill(DynamicObject changeBill) {
        Long changBillId = changeBill.getLong("id");
        HashSet<Long> changBillIds = new HashSet<Long>(2);
        changBillIds.add(changBillId);
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", String.valueOf(true));
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"audit", (String)"fa_change_dept", (Object[])changBillIds.toArray(), (OperateOption)option);
        if (!operationResult.isSuccess()) {
            List allError = operationResult.getAllErrorOrValidateInfo();
            StringBuilder errorInfo = new StringBuilder();
            if (!CollectionUtils.isEmpty((Collection)allError)) {
                for (IOperateInfo in : allError) {
                    errorInfo.append(in.getMessage());
                }
            }
            String msg = String.format("%s%s-%s", ResManager.loadKDString((String)"\u5ba1\u6838\u8d44\u4ea7\u53d8\u66f4\u5355\u5931\u8d25\u3002", (String)"FaLeaseChangeBillPushOp_8", (String)"fi-fa-opplugin", (Object[])new Object[0]), operationResult.getMessage(), errorInfo.toString());
            throw new KDBizException(msg);
        }
    }

    private static Long getChangeType4ChangItem(Set<Long> changItemIdSet) {
        DynamicObject changeType = QueryServiceHelper.queryOne((String)"fa_change_type", (String)"id", (QFilter[])new QFilter[]{new QFilter("changetypeentry.changeitem", "in", changItemIdSet)});
        if (changeType == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u79df\u8d41\u53d8\u66f4\u9879\u76ee\u5728\u8d44\u4ea7\u53d8\u66f4\u7c7b\u578b\u4e2d\u4e0d\u5b58\u5728\uff0c\u4e0d\u80fd\u4e0b\u63a8\u8d44\u4ea7\u53d8\u66f4\u5355", (String)"FaLeaseChangeBillPushOp_9", (String)"fi-fa-opplugin", (Object[])new Object[0]));
        }
        return changeType.getLong("id");
    }

    public static DynamicObject getMainBookByOrg(Long orgId) {
        QFilter mainF = new QFilter("ismainbook", "=", (Object)IS_ADJUST_DEP_RE_1);
        QFilter orgF = new QFilter("org", "=", (Object)orgId);
        return QueryServiceHelper.queryOne((String)"fa_assetbook", (String)Fa.dot((String[])new String[]{"curperiod", "enddate"}), (QFilter[])new QFilter[]{mainF, orgF});
    }
}

