/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.lease;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.form.operate.MutexHelper;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.fa.business.lease.backup.LeaseContractBackupUtils;
import kd.fi.fa.business.lease.backup.RestoreLeaseContractInfo;
import kd.fi.fa.business.pclock.AbstractPcLockOperationServicePlugIn;
import kd.fi.fa.business.pclock.PcLockConfigBillNoConstants;
import kd.fi.fa.opplugin.lease.FaLeaseChangeBillUnAuditValidator;

public class FaLeaseChangeBillUnAuditOp
extends AbstractPcLockOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(FaLeaseChangeBillUnAuditOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("effectivedate");
        fieldKeys.add("befcontract");
        fieldKeys.add("aftcontract");
        fieldKeys.add("leasecontract");
        fieldKeys.add("amortizationdate");
        fieldKeys.add("changeitems");
        fieldKeys.add("pushstatus");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new FaLeaseChangeBillUnAuditValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        this.clearAmortizationDate(e.getDataEntities());
        ArrayList<RestoreLeaseContractInfo> infoList = new ArrayList<RestoreLeaseContractInfo>(e.getDataEntities().length);
        ArrayList<Long> befContractIds = new ArrayList<Long>(e.getDataEntities().length);
        for (DynamicObject bill : e.getDataEntities()) {
            DynamicObject befContract = bill.getDynamicObject("befcontract");
            long befContractId = befContract.getLong("id");
            DynamicObject aftContract = bill.getDynamicObject("aftcontract");
            long aftContractId = aftContract.getLong("id");
            RestoreLeaseContractInfo info = new RestoreLeaseContractInfo();
            info.setBeforeBackupedContrId(Long.valueOf(befContractId));
            info.setAfterBackupedContrId(Long.valueOf(aftContractId));
            infoList.add(info);
            befContractIds.add(befContractId);
            bill.set("befcontract", null);
            bill.set("aftcontract", null);
            bill.set("pushstatus", (Object)"A");
            try {
                MutexHelper.release((String)"fa_lease_contract", (String)"modify", (String)String.valueOf(aftContractId));
            }
            catch (Exception exception) {
                logger.info("\u91ca\u653e\u79df\u8d41\u5408\u540c\u4e92\u65a5\u9501\u5931\u8d25\uff1a" + exception.getMessage());
            }
        }
        SaveServiceHelper.update((DynamicObject[])e.getDataEntities());
        LeaseContractBackupUtils.restore(infoList);
        LeaseContractBackupUtils.deleteFirstBack(befContractIds);
        super.beginOperationTransaction(e);
    }

    protected void setPcLockCofig() {
        this.pcLockCofigBillNoList.add(PcLockConfigBillNoConstants.FA_LEASE_CHANGE_DEFAULT_CONFIG);
    }

    private void clearAmortizationDate(DynamicObject[] dataEntities) {
        for (DynamicObject bill : dataEntities) {
            bill.set("amortizationdate", null);
        }
    }
}

