/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.lease;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.BillStatus;
import kd.bos.exception.KDBizException;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.fa.business.utils.FaUtils;
import kd.fi.fa.opplugin.lease.FaLeaseContractInitPushValidator;

public class FaLeaseContractInitPushOp
extends AbstractOperationServicePlugIn {
    private static final String PUSH_REAL_CARD = "pushrealcard";
    private static final String PUSH_INIT_REAL_CARD = "pushinitrealcard";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("org");
        fieldKeys.add("sysswitchdate");
        fieldKeys.add("isexempt");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new FaLeaseContractInitPushValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        String pushInitRealCardMsg;
        String pushRealCardMsg;
        super.beforeExecuteOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        Set orgIds = Arrays.stream(dataEntities).map(v -> v.getDynamicObject("org").getLong("id")).collect(Collectors.toSet());
        DynamicObjectCollection mainBooks = FaUtils.getMainBookByOrgIds(orgIds);
        Set endInitOrgIds = mainBooks.stream().filter(v -> BillStatus.C.name().equals(v.getString("status"))).map(v -> v.getLong("org")).collect(Collectors.toSet());
        ArrayList<Long> toInitRealCard = new ArrayList<Long>(dataEntities.length);
        ArrayList<Long> toRealCard = new ArrayList<Long>(dataEntities.length);
        for (DynamicObject leaseContractInit : dataEntities) {
            long orgId = leaseContractInit.getDynamicObject("org").getLong("id");
            long id = leaseContractInit.getLong("id");
            if (endInitOrgIds.contains(orgId)) {
                toRealCard.add(id);
                continue;
            }
            toInitRealCard.add(id);
        }
        String msg = "";
        if (!toRealCard.isEmpty() && (pushRealCardMsg = this.pushCardOp(PUSH_REAL_CARD, toRealCard)) != null) {
            msg = msg + pushRealCardMsg;
        }
        if (!toInitRealCard.isEmpty() && (pushInitRealCardMsg = this.pushCardOp(PUSH_INIT_REAL_CARD, toInitRealCard)) != null) {
            msg = msg + pushInitRealCardMsg;
        }
        if (!msg.isEmpty()) {
            throw new KDBizException(msg);
        }
    }

    private String pushCardOp(String operate, List<Long> srcBills) {
        String msg = null;
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)operate, (String)"fa_lease_contract_init", (Object[])srcBills.toArray(), null);
        if (!operationResult.isSuccess()) {
            List allError = operationResult.getAllErrorOrValidateInfo();
            StringBuilder errorInfo = new StringBuilder();
            if (!CollectionUtils.isEmpty((Collection)allError)) {
                for (IOperateInfo in : allError) {
                    errorInfo.append(in.getMessage());
                }
            }
            msg = errorInfo.toString();
        }
        return msg;
    }
}

