/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.lease;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.fi.fa.business.enums.lease.LeaseContractRentSettleStatus;

public class FaLeaseContractUnAuditValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities = this.dataEntities;
        ArrayList<Long> contractIdList = new ArrayList<Long>(dataEntities.length);
        HashMap<Long, Long> planToContractIdMap = new HashMap<Long, Long>(dataEntities.length);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject leaseContract = dataEntity.getDataEntity();
            Long leaseContractId = (Long)leaseContract.getPkValue();
            contractIdList.add(leaseContractId);
            DynamicObjectCollection planEntry = leaseContract.getDynamicObjectCollection("payplanentryentity");
            for (DynamicObject row : planEntry) {
                long entryId = (Long)row.getPkValue();
                planToContractIdMap.put(entryId, leaseContractId);
            }
        }
        List contractBfRows = BFTrackerServiceHelper.loadBillLinkDown((String)"fa_lease_contract", (Long[])contractIdList.toArray(new Long[0]), (boolean)true);
        Set pushedContractIdSet = contractBfRows.stream().map(v -> v.getSId().getBillId()).collect(Collectors.toSet());
        List planBfRows = BFTrackerServiceHelper.loadBillLinkDown((String)"fa_lease_pay_plan", (Long[])planToContractIdMap.keySet().toArray(new Long[0]), (boolean)true);
        List pushedPlanIdList = planBfRows.stream().map(v -> v.getSId().getBillId()).collect(Collectors.toList());
        HashSet<Long> pushedPlanContractIdSet = new HashSet<Long>(dataEntities.length);
        for (Long planId : pushedPlanIdList) {
            Long contractId = (Long)planToContractIdMap.get(planId);
            pushedPlanContractIdSet.add(contractId);
        }
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject leaseContract = dataEntity.getDataEntity();
            Long leaseContractId = (Long)leaseContract.getPkValue();
            if (pushedContractIdSet.contains(leaseContractId)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5b58\u5728\u540e\u7eed\u5b9e\u7269\u5361\u7247\uff0c\u53cd\u5ba1\u6838\u5931\u8d25\u3002", (String)"FaLeaseContractUnAuditValidator_0", (String)"fi-fa-opplugin", (Object[])new Object[0]));
            }
            String rentSettleStatus = leaseContract.getString("rentsettlestatus");
            if (LeaseContractRentSettleStatus.C.name().equals(rentSettleStatus)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5b58\u5728\u540e\u7eed\u644a\u9500\u4e0e\u8ba1\u606f\uff0c\u53cd\u5ba1\u6838\u5931\u8d25\u3002", (String)"FaLeaseContractUnAuditValidator_1", (String)"fi-fa-opplugin", (Object[])new Object[0]));
            }
            if (!pushedPlanContractIdSet.contains(leaseContractId)) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4ed8\u6b3e\u8ba1\u5212\u5b58\u5728\u4e0b\u6e38\u5355\u636e\uff0c\u53cd\u5ba1\u6838\u5931\u8d25\u3002", (String)"FaLeaseContractUnAuditValidator_2", (String)"fi-fa-opplugin", (Object[])new Object[0]));
        }
    }
}

