/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.lease;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.fa.common.util.DateUtil;
import kd.fi.fa.opplugin.lease.FaAmortizeSchemeFactory;
import kd.fi.fa.opplugin.lease.IFaAmortizeAlgorithm;
import kd.fi.fa.opplugin.lease.IFaRentSettle;

public class FaRentSettle
implements IFaRentSettle {
    private static final Log log = LogFactory.getLog(FaRentSettle.class);
    String settlePeriod = null;
    DynamicObject leaseContract = null;
    DynamicObjectCollection rentSettleList = new DynamicObjectCollection();

    public FaRentSettle(String settlePeriod, DynamicObject leaseContract) {
        this.settlePeriod = settlePeriod;
        this.leaseContract = leaseContract;
    }

    @Override
    public void beforeGenerate() {
        if (this.leaseContract == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5408\u540c\u6570\u636e\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u7ee7\u7eed\u505a\u7ed3\u7b97\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"FaRentSettle_0", (String)"fi-fa-opplugin", (Object[])new Object[0]));
        }
    }

    @Override
    public void generateSettleData() {
        IFaAmortizeAlgorithm amortizeAlg = FaAmortizeSchemeFactory.getAmortizeScheme(this.settlePeriod, this.leaseContract, this.rentSettleList);
        amortizeAlg.generateSettleData();
    }

    @Override
    public void afterGenerate() {
        if (this.rentSettleList == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u751f\u6210\u7684\u7ed3\u7b97\u6570\u636e\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"FaRentSettle_1", (String)"fi-fa-opplugin", (Object[])new Object[0]));
        }
        List isNegativeRentSettleList = this.rentSettleList.stream().filter(v -> this.isNegative((DynamicObject)v)).collect(Collectors.toList());
        if (isNegativeRentSettleList.size() > 0) {
            log.error("-leasecontractId,settledate,irr,rent,interst,principal,endleaseliab--\u51fa\u73b0\u8d1f\u6570\u6253\u5370-");
            StringBuilder sb = new StringBuilder();
            for (DynamicObject leaseRentSettle : this.rentSettleList) {
                Long leasecontractid = leaseRentSettle.getLong("leasecontract_id");
                Date settledate = leaseRentSettle.getDate("settledate");
                String settledateStr = DateUtil.getShortDate().format(settledate);
                BigDecimal irr = leaseRentSettle.getBigDecimal("irr");
                BigDecimal rent = leaseRentSettle.getBigDecimal("rent");
                BigDecimal interst = leaseRentSettle.getBigDecimal("interest");
                BigDecimal principal = leaseRentSettle.getBigDecimal("principal");
                BigDecimal endleaseliab = leaseRentSettle.getBigDecimal("endleaseliab");
                sb.append("Id:").append(leasecontractid).append(",");
                sb.append(settledateStr).append(",");
                sb.append(irr).append(",");
                sb.append(rent).append(",");
                sb.append(interst).append(",");
                sb.append(principal).append(",");
                sb.append(endleaseliab).append("\n");
            }
            log.error(sb.toString());
            throw new KDBizException(ResManager.loadKDString((String)"\u79df\u91d1\u3001\u5229\u606f\u8d39\u7528\u3001\u672c\u91d1\u3001\u671f\u672b\u79df\u8d41\u8d1f\u503a\u5b58\u5728\u8d1f\u6570\u60c5\u51b5\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"FaRentSettle_2", (String)"fi-fa-opplugin", (Object[])new Object[0]));
        }
    }

    @Override
    public void insertSettleData() {
        SaveServiceHelper.save((DynamicObject[])((DynamicObject[])this.rentSettleList.toArray((Object[])new DynamicObject[0])));
    }

    @Override
    public void rentSettle() {
        this.beforeGenerate();
        this.generateSettleData();
        this.afterGenerate();
        this.insertSettleData();
    }

    private boolean isNegative(DynamicObject leaseRentSettle) {
        BigDecimal rent = leaseRentSettle.getBigDecimal("rent");
        if (rent.compareTo(BigDecimal.ZERO) < 0) {
            return true;
        }
        BigDecimal interst = leaseRentSettle.getBigDecimal("interest");
        if (interst.compareTo(BigDecimal.ZERO) <= 0) {
            return true;
        }
        BigDecimal endleaseliab = leaseRentSettle.getBigDecimal("endleaseliab");
        return endleaseliab.compareTo(BigDecimal.ZERO) < 0;
    }
}

