/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.lease;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.fa.business.enums.lease.LeaseContractRentSettleStatus;
import kd.fi.fa.business.lease.RentSettleGenerator;
import kd.fi.fa.business.utils.FaMutexRequireUtil;
import kd.fi.fa.opplugin.lease.FaRentSettleValidator;
import kd.fi.fa.po.GenInterestDetailParamPo;

public class FaRentSettleOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("status");
        e.getFieldKeys().add("isexempt");
        e.getFieldKeys().add("payplanentryentity");
        e.getFieldKeys().add("payruleentryentity");
        e.getFieldKeys().add("rule_payitem");
        e.getFieldKeys().add("bizstatus");
        e.getFieldKeys().add("leaseliab");
        e.getFieldKeys().add("rentsettlestatus");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new FaRentSettleValidator());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        try {
            List<Long> leaseContractIds = Stream.of(e.getDataEntities()).map(v -> v.getLong("id")).collect(Collectors.toList());
            ArrayList paramPos = new ArrayList(leaseContractIds.size());
            leaseContractIds.forEach(v -> paramPos.add(new GenInterestDetailParamPo(v.longValue())));
            RentSettleGenerator generator = new RentSettleGenerator(paramPos);
            generator.generate();
            for (DynamicObject dataEntity : e.getDataEntities()) {
                dataEntity.set("rentsettlestatus", (Object)LeaseContractRentSettleStatus.C.name());
            }
            SaveServiceHelper.save((DynamicObject[])e.getDataEntities());
        }
        finally {
            HashSet<Long> ids = new HashSet<Long>(8);
            for (DynamicObject dataEntity : e.getDataEntities()) {
                ids.add(dataEntity.getLong("id"));
            }
            FaMutexRequireUtil.batchRelease((String)"fa_lease_contract", ids, (String)"leaseContractRentSettle", (String)"generateRentSettle");
        }
    }
}

