/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.lease;

import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.BillStatus;
import kd.fi.fa.business.enums.lease.LeaseContractBizStatus;
import kd.fi.fa.business.enums.lease.LeaseContractRentSettleStatus;
import kd.fi.fa.business.utils.FaMutexRequireUtil;

public class FaRentSettleValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        HashSet<Long> ids = new HashSet<Long>(dataEntities.length);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            ids.add((Long)dataEntity.getBillPkId());
        }
        Set mutexIds = FaMutexRequireUtil.requireMutexBatch((String)"fa_lease_contract", ids, (String)"leaseContractRentSettle", (String)"generateRentSettle");
        ids.removeAll(mutexIds);
        HashSet<Long> releaseIds = new HashSet<Long>(dataEntities.length);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            String status;
            DynamicObject leaseContract = dataEntity.getDataEntity();
            long id = leaseContract.getLong("id");
            if (ids.contains(id)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u5408\u540c\u6b63\u5728\u8ba1\u606f\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"FaRentSettleValidator_0", (String)"fi-fa-opplugin", (Object[])new Object[0]));
            }
            if (!(status = leaseContract.getString("status")).equals(BillStatus.C.name())) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5408\u540c\u5ba1\u6838\u72b6\u6001\u4e3a\u672a\u5ba1\u6838\uff0c\u64cd\u4f5c\u5931\u8d25\u3002", (String)"FaRentSettleValidator_1", (String)"fi-fa-opplugin", (Object[])new Object[0]));
                releaseIds.add(id);
            }
            String bizStatus = leaseContract.getString("bizstatus");
            if (LeaseContractBizStatus.B.name().equals(bizStatus)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5df2\u7ec8\u6b62\u7684\u5408\u540c\u4e0d\u80fd\u8ba1\u606f\u3002", (String)"FaRentSettleValidator_2", (String)"fi-fa-opplugin", (Object[])new Object[0]));
                releaseIds.add(id);
            }
            String rentStatus = leaseContract.getString("rentsettlestatus");
            if (LeaseContractRentSettleStatus.B.name().equals(rentStatus)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5408\u540c\u65e0\u9700\u8ba1\u606f\u3002", (String)"FaRentSettleValidator_3", (String)"fi-fa-opplugin", (Object[])new Object[0]));
                releaseIds.add(id);
            } else if (LeaseContractRentSettleStatus.C.name().equals(rentStatus)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5408\u540c\u5df2\u751f\u6210\u644a\u9500\u4e0e\u8ba1\u606f\u6570\u636e\uff0c\u4e0d\u80fd\u91cd\u590d\u751f\u6210\u3002", (String)"FaRentSettleValidator_4", (String)"fi-fa-opplugin", (Object[])new Object[0]));
                releaseIds.add(id);
            }
            if (releaseIds.isEmpty()) continue;
            FaMutexRequireUtil.batchRelease((String)"fa_lease_contract", releaseIds, (String)"leaseContractRentSettle", (String)"generateRentSettle");
        }
    }
}

