/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.lease;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.BillStatus;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.business.enums.lease.LeaseContractBizStatus;
import kd.fi.fa.business.enums.lease.LeaseContractRentSettleStatus;
import kd.fi.fa.business.lease.LeaseFutureBizChecker;

public class FaRentUnSettleValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities;
        for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
            boolean existFutureLeaseChangeBill;
            boolean isGenSettleData;
            DynamicObject leaseContract = dataEntity.getDataEntity();
            Long contractId = (Long)leaseContract.getPkValue();
            String status = leaseContract.getString("status");
            String rentStatus = leaseContract.getString("rentsettlestatus");
            ArrayList<QFilter> settlefilterList = new ArrayList<QFilter>();
            settlefilterList.add(new QFilter("leasecontract", "=", (Object)contractId));
            DynamicObjectCollection rentSettleList = QueryServiceHelper.query((String)"fa_lease_rent_settle", (String)"id", (QFilter[])settlefilterList.toArray(new QFilter[0]));
            List rentSettleIdList = rentSettleList.stream().map(v -> v.getLong("id")).collect(Collectors.toList());
            boolean bl = isGenSettleData = status.equals(BillStatus.C.name()) && LeaseContractRentSettleStatus.C.name().equals(rentStatus);
            if (!isGenSettleData) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5408\u540c\u672a\u5ba1\u6838\u6216\u672a\u8ba1\u606f\u3002", (String)"FaRentUnSettleValidator_0", (String)"fi-fa-opplugin", (Object[])new Object[0]));
            }
            String bizStatus = leaseContract.getString("bizstatus");
            if (LeaseContractBizStatus.B.name().equals(bizStatus)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5df2\u7ec8\u6b62\u7684\u5408\u540c\u4e0d\u5141\u8bb8\u53cd\u8ba1\u606f\u3002", (String)"FaRentUnSettleValidator_1", (String)"fi-fa-opplugin", (Object[])new Object[0]));
            }
            ArrayList<QFilter> voucherfilterList = new ArrayList<QFilter>();
            QFilter rentSettleFilter = new QFilter("sourcebillid", "in", rentSettleIdList);
            voucherfilterList.add(rentSettleFilter);
            QFilter billTypeFilter = new QFilter("billType", "=", (Object)"fa_lease_rent_settle");
            voucherfilterList.add(billTypeFilter);
            boolean isGenVoucher = QueryServiceHelper.exists((String)"ai_daptracker", (QFilter[])voucherfilterList.toArray(new QFilter[0]));
            if (isGenVoucher) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5408\u540c\u5bf9\u5e94\u7684\u644a\u9500\u4e0e\u8ba1\u606f\u8bb0\u5f55\u5df2\u751f\u6210\u51ed\u8bc1\uff0c\u4e0d\u80fd\u53cd\u8ba1\u606f\u3002", (String)"FaRentUnSettleValidator_2", (String)"fi-fa-opplugin", (Object[])new Object[0]));
            }
            if (!(existFutureLeaseChangeBill = LeaseFutureBizChecker.existFutureLeaseChangeBill(null, (Object)contractId, null))) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5b58\u5728\u540e\u7eed\u79df\u8d41\u53d8\u66f4\u5355\uff0c\u4e0d\u5141\u8bb8\u53cd\u8ba1\u606f\u3002", (String)"FaRentUnSettleValidator_3", (String)"fi-fa-opplugin", (Object[])new Object[0]));
        }
    }
}

