/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.merge;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.business.utils.FaDepreUtil;
import kd.fi.fa.business.utils.SystemParamHelper;
import kd.fi.fa.common.util.Fa;

public class FaMergeBillDepreSumValidator
extends AbstractValidator {
    public void validate() {
        String operateKey = this.getOperateKey();
        if ("unaudit".equalsIgnoreCase(operateKey)) {
            for (ExtendedDataEntity dataEntity : this.dataEntities) {
                Object mergeBillId = dataEntity.getDataEntity().getPkValue();
                boolean hasVoucher = FaDepreUtil.hashVouncherV2(Collections.singletonList(mergeBillId), (String)"fa_mergebill");
                if (!hasVoucher) continue;
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8d44\u4ea7\u5408\u5e76\u5355\u5df2\u751f\u6210\u51ed\u8bc1\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"FaMergeBillDepreSumValidator_0", (String)"fi-fa-opplugin", (Object[])new Object[0]));
            }
        }
        HashMap<Long, Long> org2PeriodMap = new HashMap<Long, Long>(this.dataEntities.length);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject mergeBill = dataEntity.getDataEntity();
            long orgId = mergeBill.getLong(Fa.id((String)"org"));
            org2PeriodMap.putIfAbsent(orgId, mergeBill.getLong(Fa.id((String)"mergeperiod")));
        }
        HashMap<Long, String> org2MsgMap = new HashMap<Long, String>(org2PeriodMap.size());
        for (Map.Entry org2Period : org2PeriodMap.entrySet()) {
            Long orgId = (Long)org2Period.getKey();
            Long periodId = (Long)org2Period.getValue();
            QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
            boolean enableSumMutilVoucher = SystemParamHelper.getBooleanParam((String)"enable_sum_mutil_voucher", (long)orgId, (boolean)false);
            QFilter periodFilter = enableSumMutilVoucher ? new QFilter("period", ">", (Object)periodId) : new QFilter("period", ">=", (Object)periodId);
            DynamicObjectCollection depreSumList = QueryServiceHelper.query((String)"fa_depre_sum", (String)"id", (QFilter[])new QFilter[]{orgFilter, periodFilter});
            List depreSumIds = depreSumList.stream().map(v -> v.get("id")).collect(Collectors.toList());
            boolean hasVoucher = FaDepreUtil.hashVouncherV2(depreSumIds, (String)"fa_depre_sum");
            if (!hasVoucher) continue;
            if (enableSumMutilVoucher) {
                org2MsgMap.put(orgId, ResManager.loadKDString((String)"\u540e\u7eed\u671f\u95f4\u6298\u65e7\u6c47\u603b\u5df2\u751f\u6210\u51ed\u8bc1\uff0c\u64cd\u4f5c\u5931\u8d25\u3002", (String)"FaMergeBillDepreSumValidator_1", (String)"fi-fa-opplugin", (Object[])new Object[0]));
                continue;
            }
            org2MsgMap.put(orgId, ResManager.loadKDString((String)"\u5f53\u671f\u6216\u540e\u7eed\u671f\u95f4\u6298\u65e7\u6c47\u603b\u5df2\u751f\u6210\u51ed\u8bc1\uff0c\u64cd\u4f5c\u5931\u8d25\u3002", (String)"FaMergeBillDepreSumValidator_2", (String)"fi-fa-opplugin", (Object[])new Object[0]));
        }
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject mergeBill = dataEntity.getDataEntity();
            long orgId = mergeBill.getLong(Fa.id((String)"org"));
            String msg = (String)org2MsgMap.get(orgId);
            if (msg == null) continue;
            this.addErrorMessage(dataEntity, msg);
        }
    }
}

