/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.merge;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.fi.fa.business.enums.assetpolicy.DevaluePolicy;
import kd.fi.fa.business.utils.AssetPolicyUtil;
import kd.fi.fa.common.util.Fa;

public class FaMergeBillDevaluePolicyValidator
extends AbstractValidator {
    public void validate() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject mergeBill = dataEntity.getDataEntity();
            DynamicObjectCollection inEntryEntity = mergeBill.getDynamicObjectCollection("inentryentity");
            for (DynamicObject inEntry : inEntryEntity) {
                BigDecimal inDecVal = inEntry.getBigDecimal("indecval");
                if (inDecVal.compareTo(BigDecimal.ZERO) == 0) continue;
                DynamicObject inFinCard = inEntry.getDynamicObject("infincard");
                DynamicObject assetBook = inFinCard.getDynamicObject("assetbook");
                DynamicObject realCard = inEntry.getDynamicObject("inrealcard");
                DynamicObject policyEntry = AssetPolicyUtil.getByBookAndCat((Object)assetBook.getPkValue(), (Object)realCard.get(Fa.id((String)"assetcat")));
                String devaluePolicy = policyEntry.getString("decpolicy");
                if (!DevaluePolicy.NOT_DEVALUE.getValue().equals(devaluePolicy)) continue;
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6839\u636e\u51cf\u503c\u653f\u7b56\uff0c\u8f6c\u5165\u65b9\u8be5\u7c7b\u522b\u7684\u5361\u7247\u4e0d\u5141\u8bb8\u51cf\u503c\u3002", (String)"FaMergeBillDevaluePolicyValidator_0", (String)"fi-fa-opplugin", (Object[])new Object[0]));
            }
        }
    }
}

