/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.merge;

import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.opplugin.merge.FaMergeBillUtils;
import kd.fi.fa.opplugin.restartrealbill.utils.CommonCheckUtils;

public class FaMergeBillReStartRealBillValidator
extends AbstractValidator {
    public void validate() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject mergeBill = dataEntity.getDataEntity();
            DynamicObject mergePeriod = mergeBill.getDynamicObject("mergeperiod");
            long orgId = mergeBill.getLong(Fa.id((String)"org"));
            Set<Long> realCardIds = FaMergeBillUtils.getMergeBillRealCardIds(mergeBill);
            Long mergePeriodId = Long.parseLong(mergePeriod.getPkValue().toString());
            Set<Long> realCardIdSet = CommonCheckUtils.existsFaReStartRealBill(mergePeriodId, orgId, realCardIds);
            if (realCardIdSet.isEmpty()) continue;
            String numberFiled = "number";
            DynamicObjectCollection dynObjCollection = QueryServiceHelper.query((String)"fa_card_real", (String)numberFiled, (QFilter[])new QFilter[]{new QFilter("id", "in", realCardIdSet)});
            if (dynObjCollection.isEmpty()) continue;
            HashSet<String> realCardNameSet = new HashSet<String>(16);
            for (DynamicObject dynObj : dynObjCollection) {
                realCardNameSet.add(dynObj.getString(numberFiled));
            }
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u8d44\u4ea7\u7f16\u7801\uff1a%1$s\uff0c\u5408\u5e76\u5f53\u671f\u5b58\u5728\u91cd\u542f\u5355\u3002", (String)"FaMergeBillReStartRealBillValidator_0", (String)"fi-fa-opplugin", (Object[])new Object[0]), String.join((CharSequence)", ", realCardNameSet)));
        }
    }
}

