/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.merge;

import java.util.List;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.fa.business.BizStatusEnum;
import kd.fi.fa.business.utils.FaBizUtils;
import kd.fi.fa.business.utils.FaModiRealStatsUtils;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.opplugin.AbstractBizCtrOperationServicePlugIn;
import kd.fi.fa.opplugin.FaBizBaseValidator;
import kd.fi.fa.opplugin.merge.FaMergeBillSaveValidator;
import kd.fi.fa.opplugin.merge.FaMergeBillUtils;
import kd.fi.fa.opplugin.validator.FaChangeApplyValidator;

public class FaMergeBillSaveOp
extends AbstractBizCtrOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("type");
        fieldKeys.add("voucherflag");
        fieldKeys.add(Fa.dot((String[])new String[]{"mergeperiod", "enddate"}));
        fieldKeys.add(Fa.dot((String[])new String[]{"inentryentity", "inrealcard"}));
        fieldKeys.add(Fa.dot((String[])new String[]{"inentryentity", "infincard"}));
        fieldKeys.add(Fa.dot((String[])new String[]{"inentryentity", "inoriginalval"}));
        fieldKeys.add(Fa.dot((String[])new String[]{"inentryentity", "inpreresidualval"}));
        fieldKeys.add(Fa.dot((String[])new String[]{"inentryentity", "indecval"}));
        fieldKeys.add(Fa.dot((String[])new String[]{"inentryentity", "incompfieldsv"}));
        fieldKeys.add(Fa.dot((String[])new String[]{"inentryentity", "inrealcardmasterid"}));
        fieldKeys.add(Fa.dot((String[])new String[]{"inentryentity", "indepreuse"}));
        fieldKeys.add(Fa.dot((String[])new String[]{"outentryentity", "outrealcard"}));
        fieldKeys.add(Fa.dot((String[])new String[]{"outentryentity", "outfincard"}));
        fieldKeys.add(Fa.dot((String[])new String[]{"outentryentity", "OUTREALCARDMASTERID"}));
        fieldKeys.add(Fa.dot((String[])new String[]{"outentryentity", "outcompfieldsv"}));
        fieldKeys.add("createtime");
        fieldKeys.add("modifytime");
        fieldKeys.add("auditdate");
        fieldKeys.add("realcard");
        fieldKeys.add("org");
        fieldKeys.add("mergedate");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new FaBizBaseValidator());
        e.addValidator(new AbstractValidator(){

            public void validate() {
                for (ExtendedDataEntity dataEntity : this.getDataEntities()) {
                    DynamicObject mergeBill = dataEntity.getDataEntity();
                    long orgId = mergeBill.getLong(Fa.id((String)"org"));
                    String msg = FaBizUtils.checkOrgBookCurPeriodEqual((Long)orgId);
                    if (msg == null) continue;
                    this.addErrorMessage(dataEntity, msg);
                }
            }
        });
        e.addValidator((AbstractValidator)new FaMergeBillSaveValidator());
        e.addValidator((AbstractValidator)new FaChangeApplyValidator());
    }

    @Override
    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] oldBills;
        super.beginOperationTransaction(e);
        DynamicObject[] bills = e.getDataEntities();
        Object[] pkArray = Stream.of(bills).map(DataEntityBase::getPkValue).toArray(Object[]::new);
        for (DynamicObject oldBill : oldBills = BusinessDataServiceHelper.load((Object[])pkArray, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"fa_mergebill"))) {
            FaModiRealStatsUtils.updateMergeBillCardBizStatus((DynamicObject)oldBill, (BizStatusEnum)BizStatusEnum.READY, (BizStatusEnum)BizStatusEnum.MERGING);
        }
        for (DynamicObject bill : bills) {
            FaModiRealStatsUtils.updateMergeBillCardBizStatus((DynamicObject)bill, (BizStatusEnum)BizStatusEnum.MERGING, (BizStatusEnum)BizStatusEnum.READY);
        }
        FaMergeBillUtils.updateMergePeriod(bills);
        for (DynamicObject bill : bills) {
            FaMergeBillUtils.processMergeBillCompField(bill);
        }
    }
}

