/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.merge;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.business.SourceFlagEnum;
import kd.fi.fa.business.enums.BusyTypeDetailEnum;
import kd.fi.fa.business.periodclose.FutureBizChecker;
import kd.fi.fa.business.utils.FaAssetBookDataUpgradeLogUtils;
import kd.fi.fa.business.utils.FaBizUtils;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.opplugin.merge.FaMergeBillUtils;

public class FaMergeBillSaveValidator
extends AbstractValidator {
    public void validate() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            this.checkCardValidator(dataEntity);
            DynamicObject mergeBill = dataEntity.getDataEntity();
            DynamicObjectCollection inEntryEntity = mergeBill.getDynamicObjectCollection("inentryentity");
            for (DynamicObject inEntry : inEntryEntity) {
                BigDecimal inPreResidualVal;
                BigDecimal inOriginalVal = inEntry.getBigDecimal("inoriginalval");
                if (inOriginalVal.compareTo(inPreResidualVal = inEntry.getBigDecimal("inpreresidualval")) >= 0) continue;
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u6298\u65e7\u7528\u9014\u4e3a[%1$s]\u7684\u8f6c\u5165\u5206\u5f55\uff0c\u8f6c\u5165\u51c0\u6b8b\u503c\u5927\u4e8e\u8f6c\u5165\u539f\u503c\u3002", (String)"FaMergeBillSaveValidator_0", (String)"fi-fa-opplugin", (Object[])new Object[0]), inEntry.getString(Fa.dot((String[])new String[]{"indepreuse", "name"}))));
            }
        }
    }

    private void checkCardValidator(ExtendedDataEntity dataEntity) {
        DynamicObject mergeBill = dataEntity.getDataEntity();
        Set<Long> realCardIds = FaMergeBillUtils.getMergeBillRealCardIds(mergeBill);
        String queryField = Fa.comma((String[])new String[]{"id", "number", "bizstatus", "sourceflag", "justrealcard"});
        DynamicObjectCollection realCards = QueryServiceHelper.query((String)"fa_card_real", (String)queryField, (QFilter[])new QFilter[]{new QFilter("id", "in", realCardIds)});
        List<String> leaseContractSourceFlag = Arrays.asList("LEASECONTRACT", "INITLEASECONTRACT");
        for (DynamicObject realCard : realCards) {
            boolean isJustRealCard;
            String sourceFlag = realCard.getString("sourceflag");
            if (leaseContractSourceFlag.contains(sourceFlag)) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u8d44\u4ea7\u7f16\u7801[%s]\u662f\u8d39\u7528\u5316\u8d44\u4ea7\u4e0d\u5141\u8bb8\u505a\u8be5\u4e1a\u52a1\u3002", (String)"FaMergeBillSaveValidator_1", (String)"fi-fa-opplugin", (Object[])new Object[0]), realCard.getString("number")));
            }
            if (isJustRealCard = realCard.getBoolean("justrealcard")) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u8d44\u4ea7\u7f16\u7801[%s]\u662f\u8d39\u7528\u5316\u8d44\u4ea7\u4e0d\u5141\u8bb8\u505a\u8be5\u4e1a\u52a1\u3002", (String)"FaMergeBillSaveValidator_1", (String)"fi-fa-opplugin", (Object[])new Object[0]), realCard.getString("number")));
            }
            if (!SourceFlagEnum.DATAASSET.name().equals(sourceFlag)) continue;
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u8d44\u4ea7\u7f16\u7801[%s]\u5efa\u5361\u65b9\u5f0f\u4e3a\u3010\u6570\u636e\u5361\u7247\u3011\uff0c\u4e0d\u652f\u6301\u505a\u8be5\u4e1a\u52a1\u3002", (String)"FaMergeBillSaveValidator_2", (String)"fi-fa-opplugin", (Object[])new Object[0]), realCard.getString("number")));
        }
        long orgId = mergeBill.getLong(Fa.id((String)"org"));
        Optional optional = new FutureBizChecker(mergeBill.getPkValue(), (Object)orgId, new HashSet<Long>(realCardIds), mergeBill.getDate("mergedate"), BusyTypeDetailEnum.REAL_FIN_CHG).check();
        if (optional.isPresent()) {
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u5361\u7247\u5b58\u5728\u540e\u7eed\u4e1a\u52a1\uff0c\u65e0\u6cd5\u64cd\u4f5c\uff1a%s\u3002", (String)"FaMergeBillSaveValidator_3", (String)"fi-fa-opplugin", (Object[])new Object[0]), optional.get()));
        }
        long realCardId = mergeBill.getLong(Fa.id((String)"realcard"));
        DynamicObjectCollection books = FaBizUtils.getAllBookByOrg((Long)orgId);
        Map<Long, Date> depreUse2CurPeriodBeginDate = books.stream().collect(Collectors.toMap(v -> v.getLong("depreuse"), v -> v.getDate("begindate")));
        DynamicObjectCollection finCards = QueryServiceHelper.query((String)"fa_card_fin", (String)Fa.comma((String[])new String[]{"depreuse", "number", "realcard", "originalval", "finaccountdate", Fa.dot((String[])new String[]{"depreuse", "name"})}), (QFilter[])new QFilter[]{new QFilter("realcardmasterid", "in", realCardIds), new QFilter("endperiod", "=", (Object)99999999999L)});
        for (DynamicObject finCard : finCards) {
            BigDecimal original;
            long finRealCardId;
            Long depreUseId = finCard.getLong("depreuse");
            Date finAccountDate = finCard.getDate("finaccountdate");
            Date curPeriodBeginDate = depreUse2CurPeriodBeginDate.get(depreUseId);
            boolean enableCurPeriodBiz = FaAssetBookDataUpgradeLogUtils.enableCurPeriodSplit((Long)orgId);
            if (!finAccountDate.before(curPeriodBeginDate) && !enableCurPeriodBiz) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u8d44\u4ea7\u7f16\u7801[%1$s]\u5165\u8d26\u65e5\u671f\u4e0d\u5728\u8d26\u7c3f\u5f53\u524d\u671f\u95f4\u4e4b\u524d:[%2$s]\u3002", (String)"FaMergeBillSaveValidator_4", (String)"fi-fa-opplugin", (Object[])new Object[0]), finCard.getString("number"), finCard.getString(Fa.dot((String[])new String[]{"depreuse", "name"}))));
            }
            if ((finRealCardId = finCard.getLong("realcard")) == realCardId || (original = finCard.getBigDecimal("originalval")).compareTo(BigDecimal.ZERO) != 0) continue;
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u8d44\u4ea7\u7f16\u7801[%1$s]\u539f\u503c\u4e3a0:[%2$s]\u3002", (String)"FaMergeBillSaveValidator_5", (String)"fi-fa-opplugin", (Object[])new Object[0]), finCard.getString("number"), finCard.getString(Fa.dot((String[])new String[]{"depreuse", "name"}))));
        }
    }
}

