/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.merge;

import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.opplugin.merge.FaMergeBillUtils;

public class FaMergeBillSplitCardValidator
extends AbstractValidator {
    public void validate() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject mergeBill = dataEntity.getDataEntity();
            DynamicObject mergePeriod = mergeBill.getDynamicObject("mergeperiod");
            if (mergePeriod == null) {
                mergePeriod = mergeBill.getDynamicObject("org").getDynamicObject("curperiod");
            }
            Set<Long> ids = FaMergeBillUtils.getMergeBillRealCardIds(mergeBill);
            DynamicObjectCollection splitBills = QueryServiceHelper.query((String)"fa_assetsplitbill", (String)"split_realcard.number", (QFilter[])new QFilter[]{new QFilter("splitperiod", "=", mergePeriod.getPkValue()), new QFilter("split_realcard", "in", ids)});
            Set numbers = splitBills.stream().map(v -> v.getString("split_realcard.number")).collect(Collectors.toSet());
            if (numbers.isEmpty()) continue;
            String numbersStr = String.join((CharSequence)"\u3001", numbers);
            if (numbers.size() > 1) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4e0b\u5217\u5361\u7247\u7f16\u7801\uff1a%s \u5f53\u671f\u4f5c\u4e3a\u88ab\u62c6\u5206\u5361\u7247\u53c2\u4e0e\u8fc7\u62c6\u5206\uff0c\u4e0d\u5141\u8bb8\u505a\u5408\u5e76\u4e1a\u52a1\uff1b", (String)"FaMergeBillSplitCardValidator_0", (String)"fi-fa-opplugin", (Object[])new Object[0]), numbersStr));
                continue;
            }
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5361\u7247\u7f16\u7801\uff1a%s \u5f53\u671f\u4f5c\u4e3a\u88ab\u62c6\u5206\u5361\u7247\u53c2\u4e0e\u8fc7\u62c6\u5206\uff0c\u4e0d\u5141\u8bb8\u505a\u5408\u5e76\u4e1a\u52a1\uff1b", (String)"FaMergeBillSplitCardValidator_1", (String)"fi-fa-opplugin", (Object[])new Object[0]), numbersStr));
        }
    }
}

