/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.merge;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.opplugin.FaMigrateDateValidator;
import kd.fi.fa.opplugin.merge.FaMergeBillChangeValidator;
import kd.fi.fa.opplugin.merge.FaMergeBillClearValidator;
import kd.fi.fa.opplugin.merge.FaMergeBillDepreAdjustValidator;
import kd.fi.fa.opplugin.merge.FaMergeBillDevaluePolicyValidator;
import kd.fi.fa.opplugin.merge.FaMergeBillDevalueValidator;
import kd.fi.fa.opplugin.merge.FaMergeBillMergeDateValidator;
import kd.fi.fa.opplugin.merge.FaMergeBillReStartRealBillValidator;
import kd.fi.fa.opplugin.merge.FaMergeBillSaveOp;
import kd.fi.fa.opplugin.merge.FaMergeBillSplitCardValidator;

public class FaMergeBillSubmitOp
extends FaMergeBillSaveOp {
    @Override
    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new FaMigrateDateValidator());
        e.addValidator((AbstractValidator)new FaMergeBillMergeDateValidator());
        e.addValidator((AbstractValidator)new FaMergeBillDevalueValidator());
        e.addValidator((AbstractValidator)new FaMergeBillChangeValidator());
        e.addValidator((AbstractValidator)new FaMergeBillDepreAdjustValidator());
        e.addValidator((AbstractValidator)new FaMergeBillSplitCardValidator());
        e.addValidator((AbstractValidator)new FaMergeBillDevaluePolicyValidator());
        e.addValidator((AbstractValidator)new FaMergeBillClearValidator());
        e.addValidator((AbstractValidator)new FaMergeBillReStartRealBillValidator());
    }

    @Override
    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] bills = e.getDataEntities();
        this.updateVoucherFlag(bills);
    }

    private void updateVoucherFlag(DynamicObject[] bills) {
        for (DynamicObject bill : bills) {
            DynamicObject inRealCard = bill.getDynamicObject("realcard");
            long inAssetCatId = inRealCard.getLong(Fa.id((String)"assetcat"));
            DynamicObjectCollection inEntryEntity = bill.getDynamicObjectCollection("inentryentity");
            DynamicObject inEntry = (DynamicObject)inEntryEntity.get(0);
            DynamicObjectCollection outEntryEntity = inEntry.getDynamicObjectCollection("outentryentity");
            String voucherFlag = "A";
            for (DynamicObject outEntry : outEntryEntity) {
                long outAssetCatId = outEntry.getDynamicObject("outrealcard").getLong(Fa.id((String)"assetcat"));
                if (inAssetCatId == outAssetCatId) continue;
                voucherFlag = "B";
                break;
            }
            bill.set("voucherflag", (Object)voucherFlag);
        }
    }
}

