/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.merge;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.DB;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.fa.business.utils.CompFieldsValuesUtils;
import kd.fi.fa.business.utils.FaBizUtils;
import kd.fi.fa.business.utils.FaUtils;
import kd.fi.fa.common.util.Fa;

public class FaMergeBillUtils {
    public static void updateMergePeriod(DynamicObject[] dataEntities) {
        HashSet<Long> orgIds = new HashSet<Long>(4);
        for (DynamicObject dataEntity : dataEntities) {
            orgIds.add(dataEntity.getLong(Fa.id((String)"org")));
        }
        DynamicObjectCollection books = FaUtils.getMainBookByOrgIds(orgIds);
        HashMap<Long, Long> orgIdToCurPeriodId = new HashMap<Long, Long>(4);
        for (DynamicObject book : books) {
            orgIdToCurPeriodId.put(book.getLong("org"), book.getLong("curperiod"));
        }
        for (DynamicObject dataEntity : dataEntities) {
            dataEntity.set(Fa.id((String)"mergeperiod"), orgIdToCurPeriodId.get(dataEntity.getLong(Fa.id((String)"org"))));
        }
    }

    public static Set<Long> getMergeBillRealCardIds(DynamicObject mergeBill) {
        DynamicObjectCollection inEntryEntity = mergeBill.getDynamicObjectCollection("inentryentity");
        DynamicObject inEntry = (DynamicObject)inEntryEntity.get(0);
        DynamicObjectCollection outEntryEntity = inEntry.getDynamicObjectCollection("outentryentity");
        HashSet<Long> realCardIds = new HashSet<Long>(outEntryEntity.size() + 1, 1.0f);
        DynamicObject realCard = mergeBill.getDynamicObject("realcard");
        if (realCard != null) {
            realCardIds.add(realCard.getLong("id"));
        }
        Set outRealCardIds = outEntryEntity.stream().map(v -> v.getLong("OUTREALCARDMASTERID")).collect(Collectors.toSet());
        realCardIds.addAll(outRealCardIds);
        return realCardIds;
    }

    public static Set<Long> getMergeBillFinCardIds(DynamicObject mergeBill) {
        HashSet<Long> finCardIds = new HashSet<Long>(16);
        DynamicObjectCollection inEntryEntity = mergeBill.getDynamicObjectCollection("inentryentity");
        for (DynamicObject inEntry : inEntryEntity) {
            finCardIds.add(inEntry.getLong(Fa.id((String)"infincard")));
            DynamicObjectCollection outEntryEntity = inEntry.getDynamicObjectCollection("outentryentity");
            for (DynamicObject outEntry : outEntryEntity) {
                finCardIds.add(outEntry.getLong(Fa.id((String)"outfincard")));
            }
        }
        return finCardIds;
    }

    public static DynamicObject getMergeBillNextPeriod(DynamicObject mergeBill) {
        DynamicObject mergePeriod = mergeBill.getDynamicObject("mergeperiod");
        long mergePeriodId = mergePeriod == null ? mergeBill.getDynamicObject("org").getLong(Fa.id((String)"curperiod")) : mergePeriod.getLong("id");
        DynamicObject period = BusinessDataServiceHelper.loadSingleFromCache((Object)mergePeriodId, (String)"bd_period");
        return FaBizUtils.queryNeighborPeriodByDo((DynamicObject)period, (int)1);
    }

    public static Map<Long, DynamicObject> genFinCardSnapshot4MergeBill(DynamicObject bill, boolean isBefore) {
        long orgId = bill.getLong(Fa.id((String)"org"));
        DynamicObject mainBook = FaUtils.getMainBookByOrg((Long)orgId);
        Set<Long> finCardIds = FaMergeBillUtils.getMergeBillFinCardIds(bill);
        HashMap<Long, DynamicObject> result = new HashMap<Long, DynamicObject>(finCardIds.size());
        if (finCardIds.isEmpty()) {
            return result;
        }
        MainEntityType changeBakFinType = MetadataServiceHelper.getDataEntityType((String)"fa_changebak_fin");
        DynamicObject[] finCards = BusinessDataServiceHelper.load((Object[])finCardIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"fa_card_fin"));
        int length = finCards.length;
        if (length > 0) {
            long curPeriodId = mainBook.getLong("curperiod");
            String tableName = changeBakFinType.getAlias();
            long[] snapshotIds = DB.genLongIds((String)tableName, (int)length);
            for (int i = 0; i < length; ++i) {
                DynamicObject finCard = finCards[i];
                DynamicObject fCardSnapshot = new DynamicObject((DynamicObjectType)changeBakFinType);
                DataEntityPropertyCollection properties = fCardSnapshot.getDynamicObjectType().getProperties();
                fCardSnapshot.set("id", (Object)snapshotIds[i]);
                for (IDataEntityProperty property : properties) {
                    String propertyName = property.getName();
                    if ("id".equalsIgnoreCase(propertyName)) {
                        fCardSnapshot.set(propertyName, (Object)snapshotIds[i]);
                        continue;
                    }
                    if ("changebillid".equalsIgnoreCase(propertyName)) {
                        fCardSnapshot.set(propertyName, bill.getPkValue());
                        continue;
                    }
                    if ("cardid".equalsIgnoreCase(propertyName)) {
                        fCardSnapshot.set(propertyName, finCard.getPkValue());
                        continue;
                    }
                    if ("accumdepre".equalsIgnoreCase(propertyName)) {
                        DynamicObject bizPeriod = finCard.getDynamicObject("bizperiod");
                        if (bizPeriod != null && curPeriodId == bizPeriod.getLong("id")) {
                            BigDecimal monthDepre = finCard.getBigDecimal("monthdepre");
                            BigDecimal newAccumDepre = finCard.getBigDecimal(propertyName).subtract(monthDepre);
                            fCardSnapshot.set(propertyName, (Object)newAccumDepre);
                            fCardSnapshot.set("monthdepre", (Object)0);
                        } else {
                            fCardSnapshot.set(propertyName, finCard.get(propertyName));
                            fCardSnapshot.set("monthdepre", (Object)finCard.getBigDecimal("monthdepre"));
                        }
                    }
                    if ("depredamount".equalsIgnoreCase(propertyName)) continue;
                    fCardSnapshot.set(propertyName, finCard.get(propertyName));
                }
                result.put(finCard.getLong("id"), fCardSnapshot);
            }
            DynamicObjectCollection inEntryEntity = bill.getDynamicObjectCollection("inentryentity");
            for (DynamicObject inEntry : inEntryEntity) {
                Long inFinCardId = inEntry.getLong(Fa.id((String)"infincard"));
                DynamicObject inSnapshot = (DynamicObject)result.get(inFinCardId);
                if (isBefore) {
                    inEntry.set("beforeinfin", (Object)inSnapshot);
                } else {
                    inEntry.set("afterinfin", (Object)inSnapshot);
                }
                DynamicObjectCollection outEntryEntity = inEntry.getDynamicObjectCollection("outentryentity");
                for (DynamicObject outEntry : outEntryEntity) {
                    Long outFinCardId = outEntry.getLong(Fa.id((String)"outfincard"));
                    DynamicObject outSnapshot = (DynamicObject)result.get(outFinCardId);
                    if (isBefore) {
                        outEntry.set("afteroutfin", (Object)outSnapshot);
                        continue;
                    }
                    outEntry.set("beforeoutfin", (Object)outSnapshot);
                }
            }
        }
        return result;
    }

    public static Object[] getInRealCardIds(DynamicObject dataEntities, long depreUseId) {
        HashSet<Object> realCardPKs = new HashSet<Object>();
        DynamicObjectCollection inEntryEntity = dataEntities.getDynamicObjectCollection("inentryentity");
        for (DynamicObject inEntry : inEntryEntity) {
            DynamicObject inDepreUse = inEntry.getDynamicObject("indepreuse");
            if (inDepreUse != null && inDepreUse.getLong("id") != depreUseId) continue;
            realCardPKs.add(inEntry.get("inrealcardmasterid"));
        }
        return realCardPKs.toArray();
    }

    public static Object[] getOutRealCardIds(DynamicObject dataEntities, long depreUseId) {
        HashSet realCardPKs = new HashSet();
        DynamicObjectCollection inEntryEntity = dataEntities.getDynamicObjectCollection("inentryentity");
        for (DynamicObject inEntry : inEntryEntity) {
            DynamicObject inDepreUse = inEntry.getDynamicObject("indepreuse");
            if (inDepreUse != null && inDepreUse.getLong("id") != depreUseId) continue;
            DynamicObjectCollection outEntryEntity = inEntry.getDynamicObjectCollection("outentryentity");
            Set outRealCards = outEntryEntity.stream().map(v -> v.get("OUTREALCARDMASTERID")).collect(Collectors.toSet());
            realCardPKs.addAll(outRealCards);
        }
        return realCardPKs.toArray();
    }

    public static void processMergeBillCompField(DynamicObject bill) {
        HashSet<Long> finCardIds = new HashSet<Long>(16);
        DynamicObjectCollection inEntryEntity = bill.getDynamicObjectCollection("inentryentity");
        for (DynamicObject inEntry : inEntryEntity) {
            DynamicObject inFinCard = inEntry.getDynamicObject("infincard");
            if (inFinCard != null) {
                finCardIds.add(inFinCard.getLong("id"));
            }
            DynamicObjectCollection outEntryEntity = inEntry.getDynamicObjectCollection("outentryentity");
            for (DynamicObject outEntry : outEntryEntity) {
                DynamicObject outFinCard = outEntry.getDynamicObject("outfincard");
                if (outFinCard == null) continue;
                finCardIds.add(outFinCard.getLong("id"));
            }
        }
        HashMap finCardMap = new HashMap(finCardIds.size());
        if (CollectionUtils.isNotEmpty(finCardIds)) {
            DynamicObject[] finCardRecords = BusinessDataServiceHelper.load((Object[])finCardIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"fa_card_fin"));
            Arrays.stream(finCardRecords).forEach(t -> finCardMap.put(t.getLong("id"), t));
        }
        for (DynamicObject inEntry : inEntryEntity) {
            DynamicObject inFinCard = inEntry.getDynamicObject("infincard");
            if (inFinCard != null) {
                DynamicObject actualInFinCard = (DynamicObject)finCardMap.get(inFinCard.getLong("id"));
                inEntry.set("incompfieldsv", (Object)CompFieldsValuesUtils.genCompfieldsvStyleS1((DynamicObject)actualInFinCard));
            }
            DynamicObjectCollection outEntryEntity = inEntry.getDynamicObjectCollection("outentryentity");
            for (DynamicObject outEntry : outEntryEntity) {
                DynamicObject outFinCard = outEntry.getDynamicObject("outfincard");
                if (outFinCard == null) continue;
                DynamicObject actualOutFinCard = (DynamicObject)finCardMap.get(outFinCard.getLong("id"));
                outEntry.set("outcompfieldsv", (Object)CompFieldsValuesUtils.genCompfieldsvStyleS1((DynamicObject)actualOutFinCard));
            }
        }
    }
}

