/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.myasset;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.BillStatus;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.model.OrgRelationParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.fi.fa.business.BizStatusEnum;
import kd.fi.fa.business.constants.FaAssetDrawback;
import kd.fi.fa.business.dao.factory.FaChangeBillDaoFactory;
import kd.fi.fa.business.dao.factory.FaRealCardDaoFactory;
import kd.fi.fa.business.service.api.AssetChangeBillGenService;
import kd.fi.fa.business.utils.FaModiRealStatsUtils;
import kd.fi.fa.business.utils.FaUserUtils;
import kd.fi.fa.opplugin.changebill.AssetChangeDTO;
import kd.fi.fa.opplugin.myasset.FaAssetDrawbackSignValidator;
import kd.fi.fa.opplugin.myasset.FaAssetGenChangeBill;

public class FaAssetDrawbackSignOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(FaAssetDrawbackSignOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("assetorg");
        fieldKeys.add("assetorg");
        fieldKeys.add("applydate");
        fieldKeys.add("assetdrawbackentry.realcard");
        fieldKeys.add("assetdrawbackentry.realcard.masterid");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new FaAssetDrawbackSignValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] assetDrawbackBills = e.getDataEntities();
        AssetChangeBillGenService service = FaChangeBillDaoFactory.getGenerateService();
        for (DynamicObject bill : assetDrawbackBills) {
            this.updateEntity(bill);
            FaModiRealStatsUtils.update_oneBill_bizStatus((DynamicObject)bill, (String)"assetdrawbackentry", (String)"realcard", (BizStatusEnum)BizStatusEnum.READY, (BizStatusEnum)BizStatusEnum.DRAWBACKING);
            FaAssetGenChangeBill.genChangeBill("fa_asset_drawback", bill, service, this::createChangeDeptBill);
        }
    }

    private void updateEntity(DynamicObject assetDrawback) {
        assetDrawback = BusinessDataServiceHelper.loadSingle((Object)assetDrawback.getPkValue(), (String)"fa_asset_drawback");
        assetDrawback.set("signingdate", (Object)new Date());
        assetDrawback.set("bizstatus", (Object)FaAssetDrawback.BizStatusEnum.SIGNED.getValue());
        assetDrawback.set("billstatus", (Object)BillStatus.C.name());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{assetDrawback});
        logger.info("\u6267\u884c\u5b8c\u7b7e\u6536\u64cd\u4f5c");
        DynamicObjectCollection requiEntries = assetDrawback.getDynamicObjectCollection("assetdrawbackentry");
        Object[] realCardIds = requiEntries.stream().map(v -> v.get("realcard.id")).toArray();
        FaRealCardDaoFactory.getInstance().update(realCardIds, "isstoraged", (Object)true);
        logger.info("\u6267\u884c\u5b8c\u66f4\u65b0\u5b9e\u7269\u5361\u7247\u64cd\u4f5c");
    }

    private DynamicObject createChangeDeptBill(DynamicObject assetDrawback) {
        assetDrawback = BusinessDataServiceHelper.loadSingle((Object)assetDrawback.getPkValue(), (String)"fa_asset_drawback");
        AssetChangeDTO assetChangeDTO = this.transferAssetDrawbackToAssetChangeDTO(assetDrawback);
        DynamicObject changeDeptBill = assetChangeDTO.toChangeBill(new Date());
        return changeDeptBill;
    }

    private AssetChangeDTO transferAssetDrawbackToAssetChangeDTO(DynamicObject assetDrawback) {
        AssetChangeDTO assetChangeDTO = new AssetChangeDTO();
        assetChangeDTO.setSrcNumber(assetDrawback.getString("billno"));
        assetChangeDTO.setAlias(ResManager.loadKDString((String)"\u8d44\u4ea7\u9000\u5e93\u5355", (String)"FaAssetDrawbackSignOp_0", (String)"fi-fa-opplugin", (Object[])new Object[0]));
        assetChangeDTO.setReason(assetDrawback.getString("reason"));
        DynamicObject assetOrg = assetDrawback.getDynamicObject("assetorg");
        long assetOrgId = assetOrg.getLong("id");
        OrgRelationParam param = new OrgRelationParam();
        param.setToViewType("09");
        param.setFromViewType("10");
        param.setOrgId(assetOrgId);
        param.setDirectViewType("fromorg");
        param.setIncludeSelf(true);
        List fromOrgList = OrgUnitServiceHelper.getBizRelationOrgIds((OrgRelationParam)param);
        DynamicObject org = BusinessDataServiceHelper.loadSingleFromCache(fromOrgList.get(0), (String)"bos_org");
        assetChangeDTO.setOrg(org);
        DynamicObjectCollection dynamicObject = assetDrawback.getDynamicObjectCollection("assetdrawbackentry");
        HashSet<Object> storekeeperIds = new HashSet<Object>(dynamicObject.size() + 1);
        for (DynamicObject drawbackEntry : dynamicObject) {
            DynamicObject storeDy = drawbackEntry.getDynamicObject("storekeeper");
            if (storeDy == null) continue;
            storekeeperIds.add(storeDy.getPkValue());
        }
        DynamicObject signer = assetDrawback.getDynamicObject("signer");
        if (signer == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5e93\u7ba1\u5458\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8bbe\u7f6e\u3002", (String)"FaAssetDrawbackSignOp_1", (String)"fi-fa-opplugin", (Object[])new Object[0]));
        }
        storekeeperIds.add(signer.getPkValue());
        assetChangeDTO.setReceiver(signer);
        Map useId2MainOrg = FaUserUtils.getAdminOrgByUseIds(storekeeperIds);
        assetChangeDTO.setSourceId(assetDrawback.getLong("id"));
        assetChangeDTO.setCreator(assetDrawback.getDynamicObject("applier"));
        assetChangeDTO.setAuditor(assetDrawback.getDynamicObject("signer"));
        assetChangeDTO.setFromsource("fa_asset_drawback");
        assetChangeDTO.setSourcetype(assetDrawback.getString("sourcetype"));
        DynamicObjectCollection entries = assetDrawback.getDynamicObjectCollection("assetdrawbackentry");
        LinkedList realCardIds = new LinkedList();
        HashMap<Long, DynamicObject> map = new HashMap<Long, DynamicObject>(entries.size());
        HashMap<Long, DynamicObject> deptMap = new HashMap<Long, DynamicObject>(entries.size());
        entries.stream().forEach(transferEntry -> {
            DynamicObject realCard = transferEntry.getDynamicObject("realcard");
            realCard = BusinessDataServiceHelper.loadSingle((Object)realCard.getPkValue(), (String)"fa_card_real_base");
            Long pkValue = (Long)realCard.getPkValue();
            realCardIds.add(pkValue);
            assetChangeDTO.addRealEntry(realCard);
            map.put(pkValue, transferEntry.getDynamicObject("store_place"));
            DynamicObject storekeeper = transferEntry.getDynamicObject("storekeeper");
            DynamicObject dept = storekeeper != null ? (DynamicObject)useId2MainOrg.get(storekeeper.getPkValue()) : (DynamicObject)useId2MainOrg.get(signer.getPkValue());
            deptMap.put(pkValue, dept);
        });
        assetChangeDTO.setStoreplaceMap(map);
        assetChangeDTO.setDeptMap(deptMap);
        Map finCardMap = BusinessDataServiceHelper.loadFromCache((String)"fa_card_fin", (QFilter[])new QFilter[]{new QFilter("realcard.id", "in", realCardIds)});
        Collection<Object> finCards = Collections.EMPTY_LIST;
        if (finCardMap != null && !finCardMap.isEmpty()) {
            finCards = finCardMap.values();
        }
        for (DynamicObject finCard : finCards) {
            DynamicObject realCard = finCard.getDynamicObject("realcard");
            assetChangeDTO.addFinEntry(realCard, finCard);
            if (!finCard.getDynamicObject("assetbook").getBoolean("ismainbook") || finCard.getLong("endperiod_id") != 99999999999L) continue;
            assetChangeDTO.addEntry(realCard, finCard);
        }
        if (realCardIds.size() != assetChangeDTO.getEntries().size()) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5b9e\u7269\u5361\u7247\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u8d22\u52a1\u5361\u7247\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u505a\u4e86\u672a\u6765\u4e1a\u52a1\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"FaAssetDrawbackSignOp_2", (String)"fi-fa-opplugin", (Object[])new Object[0]), new Object[0]));
        }
        return assetChangeDTO;
    }
}

