/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.myasset;

import java.util.function.Function;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.fa.business.service.api.AssetChangeBillGenService;
import kd.fi.fa.business.utils.FaBillParamUtils;
import kd.fi.fa.business.utils.FaBizUtils;

public class FaAssetGenChangeBill {
    private static final String OPERATION_KEY = "pushandsave";

    public static void genChangeBill(String entryName, DynamicObject fromBill, AssetChangeBillGenService service, Function<DynamicObject, DynamicObject> toChangeFunction) {
        DynamicObject changeBill;
        OperateOption option = OperateOption.create();
        option.setVariableValue("IGNORE_CHANGE", "true");
        boolean isPushAndSave = FaBillParamUtils.getBooleanValue(null, null, null, (String)"genChangeBillForBOTP");
        if (isPushAndSave) {
            OperationResult pushResult = OperationServiceHelper.executeOperate((String)OPERATION_KEY, (String)entryName, (DynamicObject[])new DynamicObject[]{fromBill}, (OperateOption)option);
            if (!pushResult.isSuccess()) {
                String msg = FaBizUtils.getOpResErrorMsg((OperationResult)pushResult);
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u751f\u6210\u8d44\u4ea7\u53d8\u66f4\u5355\u5931\u8d25:%s", (String)"FaAssetGenChangeBill_0", (String)"fi-fa-opplugin", (Object[])new Object[0]), msg));
            }
            changeBill = BusinessDataServiceHelper.loadSingle((String)"fa_change_dept", (String)"id", (QFilter[])new QFilter[]{new QFilter("sourceid", "=", fromBill.getPkValue())});
            option.setVariableValue("IGNORE_SAVE", "true");
        } else {
            changeBill = toChangeFunction.apply(fromBill);
        }
        service.doGenerateWithSave(option, changeBill);
    }
}

