/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.myasset;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.BillStatus;
import kd.bos.exception.KDBizException;
import kd.bos.org.model.OrgRelationParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.fi.fa.business.BizStatusEnum;
import kd.fi.fa.business.dao.factory.FaChangeBillDaoFactory;
import kd.fi.fa.business.dao.factory.FaRealCardDaoFactory;
import kd.fi.fa.business.service.api.AssetChangeBillGenService;
import kd.fi.fa.business.utils.FaModiRealStatsUtils;
import kd.fi.fa.business.validator.SourceFlagDataAssetValidator;
import kd.fi.fa.common.util.ContextUtil;
import kd.fi.fa.opplugin.changebill.AssetChangeDTO;
import kd.fi.fa.opplugin.myasset.FaAssetGenChangeBill;
import kd.fi.fa.opplugin.validator.FaChangeApplyValidator;

public class FaAssetRequistionOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("entryentity");
        e.getFieldKeys().add("entryentity.real_card");
        e.getFieldKeys().add("entryentity.store_place");
        e.getFieldKeys().add("entryentity.real_card.masterid");
        e.getFieldKeys().add("entryentity.real_card.storeplace");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] requisitionBills = e.getDataEntities();
        if (StringUtils.equals((CharSequence)e.getOperationKey(), (CharSequence)"audit")) {
            List<DynamicObject> bills = Arrays.asList(e.getDataEntities());
            AssetChangeBillGenService service = FaChangeBillDaoFactory.getGenerateService();
            for (DynamicObject requisitionBill : requisitionBills) {
                requisitionBill = BusinessDataServiceHelper.loadSingle((Object)requisitionBill.getPkValue(), (String)"fa_asset_requisition");
                requisitionBill.set("sign_user", (Object)ContextUtil.getUserId());
                requisitionBill.set("sign_date", (Object)new Date());
                requisitionBill.set("billstatus", (Object)BillStatus.C.name());
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{requisitionBill});
                DynamicObjectCollection requiEntries = requisitionBill.getDynamicObjectCollection("entryentity");
                Object[] realCardIds = requiEntries.stream().map(v -> v.get("real_card.id")).toArray();
                FaRealCardDaoFactory.getInstance().update(realCardIds, "isstoraged", (Object)false);
                FaModiRealStatsUtils.update_oneBill_bizStatus((DynamicObject)requisitionBill, (String)"entryentity", (String)"real_card", (BizStatusEnum)BizStatusEnum.READY, (BizStatusEnum)BizStatusEnum.COLLECTING);
                FaAssetGenChangeBill.genChangeBill("fa_asset_requisition", requisitionBill, service, this::convertToChangeBill);
            }
            e.setDataEntities(bills.toArray(new DynamicObject[0]));
        } else if ("submit".equals(e.getOperationKey()) || "save".equals(e.getOperationKey())) {
            for (DynamicObject requisitionBill : requisitionBills) {
                DynamicObjectCollection entryEntityList = requisitionBill.getDynamicObjectCollection("entryentity");
                for (DynamicObject entryEntity : entryEntityList) {
                    DynamicObject storeplace;
                    DynamicObject realCard;
                    DynamicObject store_place = entryEntity.getDynamicObject("store_place");
                    if (store_place != null || (realCard = entryEntity.getDynamicObject("real_card")) == null || (storeplace = realCard.getDynamicObject("storeplace")) == null) continue;
                    entryEntity.set("store_place", storeplace.getPkValue());
                }
            }
            FaModiRealStatsUtils.saveUpdate_allBill_bizStatus((BeginOperationTransactionArgs)e, (String)"entryentity", (String)"real_card", (BizStatusEnum)BizStatusEnum.COLLECTING, (BizStatusEnum)BizStatusEnum.READY);
        }
    }

    private DynamicObject convertToChangeBill(DynamicObject reqBill) {
        reqBill = BusinessDataServiceHelper.loadSingle((Object)reqBill.getPkValue(), (String)"fa_asset_requisition");
        AssetChangeDTO changeInfo = new AssetChangeDTO();
        changeInfo.setSrcNumber(reqBill.getString("billno"));
        changeInfo.setAlias(ResManager.loadKDString((String)"\u8d44\u4ea7\u9886\u7528\u5355", (String)"FaAssetRequistionOp_0", (String)"fi-fa-opplugin", (Object[])new Object[0]));
        changeInfo.setRemark(reqBill.getString("remark"));
        changeInfo.setReason(reqBill.getString("apply_reason"));
        DynamicObject assetOrg = reqBill.getDynamicObject("assetorg");
        OrgRelationParam param = new OrgRelationParam();
        param.setToViewType("09");
        param.setFromViewType("10");
        param.setOrgId(assetOrg.getLong("id"));
        param.setDirectViewType("fromorg");
        param.setIncludeSelf(true);
        List fromOrgList = OrgUnitServiceHelper.getBizRelationOrgIds((OrgRelationParam)param);
        DynamicObject org = BusinessDataServiceHelper.loadSingleFromCache(fromOrgList.get(0), (String)"bos_org");
        changeInfo.setOrg(org);
        changeInfo.setReceiver(reqBill.getDynamicObject("req_user"));
        changeInfo.setDept(reqBill.getDynamicObject("req_department"));
        changeInfo.setSourceId(reqBill.getLong("id"));
        changeInfo.setCreator(reqBill.getDynamicObject("req_user"));
        changeInfo.setAuditor(reqBill.getDynamicObject("req_user"));
        changeInfo.setFromsource("fa_asset_requisition");
        changeInfo.setSourcetype(reqBill.getString("sourcetype"));
        DynamicObjectCollection reqBillEntries = reqBill.getDynamicObjectCollection("entryentity");
        LinkedList realCardIds = new LinkedList();
        HashMap<Long, DynamicObject> map = new HashMap<Long, DynamicObject>(reqBillEntries.size());
        reqBillEntries.stream().forEach(reqBillEntry -> {
            DynamicObject realCard = reqBillEntry.getDynamicObject("real_card");
            realCard = BusinessDataServiceHelper.loadSingle((Object)realCard.getPkValue(), (String)"fa_card_real_base");
            Long pkValue = (Long)realCard.getPkValue();
            realCardIds.add(pkValue);
            changeInfo.addRealEntry(realCard);
            map.put(pkValue, reqBillEntry.getDynamicObject("store_place"));
        });
        changeInfo.setStoreplaceMap(map);
        Map finCardMap = BusinessDataServiceHelper.loadFromCache((String)"fa_card_fin", (QFilter[])new QFilter[]{new QFilter("realcard.id", "in", realCardIds)});
        Collection<Object> finCards = Collections.EMPTY_LIST;
        if (finCardMap != null && !finCardMap.isEmpty()) {
            finCards = finCardMap.values();
        }
        for (DynamicObject finCard : finCards) {
            DynamicObject realCard = finCard.getDynamicObject("realcard");
            changeInfo.addFinEntry(realCard, finCard);
            DynamicObject assetbook = finCard.getDynamicObject("assetbook");
            boolean isMainBook = assetbook.getBoolean("ismainbook");
            if (!isMainBook || finCard.getLong("endperiod_id") != 99999999999L) continue;
            changeInfo.addEntry(realCard, finCard);
        }
        if (realCardIds.size() != changeInfo.getEntries().size()) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5b9e\u7269\u5361\u7247\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u8d22\u52a1\u5361\u7247\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u505a\u4e86\u672a\u6765\u4e1a\u52a1\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"FaAssetRequistionOp_1", (String)"fi-fa-opplugin", (Object[])new Object[0]), new Object[0]));
        }
        return changeInfo.toChangeBill(new Date());
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new SourceFlagDataAssetValidator("entryentity", null, "real_card"));
        e.addValidator((AbstractValidator)new FaChangeApplyValidator());
    }
}

