/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.realcard;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.fa.business.BizStatusEnum;

public class AdditionDeviceSaveOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("realcard.bizstatus");
        e.getFieldKeys().add("realcard.billstatus");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator(new AbstractValidator(){

            public void validate() {
                for (ExtendedDataEntity dataEntity : this.getDataEntities()) {
                    BizStatusEnum bizStatusEnum;
                    DynamicObject realcard = dataEntity.getDataEntity().getDynamicObject("realcard");
                    String bizStatus = realcard.getString("bizstatus");
                    String billStatus = realcard.getString("billstatus");
                    if (!"C".equals(billStatus)) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5361\u7247\u4e0d\u662f\u5ba1\u6838\u72b6\u6001\uff0c\u4e0d\u53ef\u8fdb\u884c\u8be5\u64cd\u4f5c\u3002", (String)"AdditionDeviceSaveOp_0", (String)"fi-fa-opplugin", (Object[])new Object[0]));
                    }
                    if (BizStatusEnum.ADD == (bizStatusEnum = BizStatusEnum.getBizStatusEnum((String)bizStatus)) || BizStatusEnum.READY == bizStatusEnum) continue;
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5361\u7247\u6b63\u5728\u505a\u5176\u5b83\u4e1a\u52a1\uff0c\u4e0d\u53ef\u8fdb\u884c\u8be5\u64cd\u4f5c\u3002", (String)"AdditionDeviceSaveOp_1", (String)"fi-fa-opplugin", (Object[])new Object[0]));
                }
            }
        });
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        HashSet<Long> cardIds = new HashSet<Long>(e.getDataEntities().length);
        ArrayList<Object[]> needUpFlagCards = new ArrayList<Object[]>(e.getDataEntities().length);
        for (DynamicObject dataEntity : e.getDataEntities()) {
            DynamicObject realcard = dataEntity.getDynamicObject("realcard");
            long cardId = realcard.getLong("masterid");
            cardIds.add(cardId);
            boolean isFacility = realcard.getBoolean("isfacility");
            DynamicObject[] entryentity = dataEntity.getDynamicObjectCollection("entryentity");
            if (isFacility && entryentity.size() == 0) {
                needUpFlagCards.add(new Object[]{false, cardId});
                continue;
            }
            if (isFacility || entryentity.size() <= 0) continue;
            needUpFlagCards.add(new Object[]{true, cardId});
        }
        if (needUpFlagCards.size() > 0) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"fa"), (String)"update t_fa_card_real set fisfacility = ? where fid = ?", needUpFlagCards);
        }
        DynamicObject[] existsRecordIds = BusinessDataServiceHelper.load((String)"fa_additiondevrecord", (String)"id,realcard", (QFilter[])new QFilter[]{new QFilter("realcard", "in", cardIds), QFilter.of((String)"id = realcard", (Object[])new Object[0])});
        HashSet<Long> rids = new HashSet<Long>(existsRecordIds.length);
        for (DynamicObject existsRecordCard : existsRecordIds) {
            long rid = existsRecordCard.getLong("id");
            rids.add(rid);
        }
        MainEntityType recordEntityType = MetadataServiceHelper.getDataEntityType((String)"fa_additiondevrecord");
        DynamicObject[] existsRecordCards = BusinessDataServiceHelper.load((Object[])rids.toArray(new Object[0]), (DynamicObjectType)recordEntityType);
        Map<Long, DynamicObject> existsRecordCardMap = Arrays.stream(existsRecordCards).collect(Collectors.toMap(r -> r.getLong("realcard.masterid"), r -> r));
        this.handleFirstModifyCard(e, recordEntityType, existsRecordCardMap);
        if (existsRecordCardMap.size() == 0) {
            return;
        }
        ArrayList<Object[]> upIdParamList = new ArrayList<Object[]>(existsRecordCardMap.size());
        ArrayList<DynamicObject> upRecords = new ArrayList<DynamicObject>(existsRecordCardMap.size());
        HashSet<Long> upCardIds = new HashSet<Long>();
        for (DynamicObject dataEntity : e.getDataEntities()) {
            DynamicObject realcard = dataEntity.getDynamicObject("realcard");
            long cardId = realcard.getLong("masterid");
            if (!existsRecordCardMap.containsKey(cardId)) continue;
            upCardIds.add(cardId);
            long id = DBServiceHelper.genGlobalLongId();
            dataEntity.set("id", (Object)id);
            upIdParamList.add(new Object[]{id, cardId});
            DynamicObject preRecord = existsRecordCardMap.get(cardId);
            Date preCreateTime = preRecord.getDate("createtime");
            Object preCreater = preRecord.get("creater");
            Date createTime = dataEntity.getDate("createtime");
            Object creater = dataEntity.get("creater");
            dataEntity.set("createtime", (Object)preCreateTime);
            dataEntity.set("creater", preCreater);
            preRecord.set("createtime", (Object)createTime);
            preRecord.set("creater", creater);
            upRecords.add(preRecord);
        }
        if (upIdParamList.size() > 0) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"fa"), (String)"update t_fa_facility set fid = ? where fid = ?", upIdParamList);
            SaveServiceHelper.save((DynamicObject[])upRecords.toArray(new DynamicObject[0]));
        }
        DynamicObject[] loadCards = BusinessDataServiceHelper.load((Object[])upCardIds.toArray(new Object[0]), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"fa_card_real"));
        Map<Long, DynamicObject> cardMap = Arrays.stream(loadCards).collect(Collectors.toMap(card -> card.getLong("masterid"), card -> card));
        ArrayList<DynamicObject> upCards = new ArrayList<DynamicObject>(existsRecordCardMap.size());
        for (DynamicObject dataEntity : e.getDataEntities()) {
            DynamicObject card2;
            DynamicObject realcard = dataEntity.getDynamicObject("realcard");
            long cardId = realcard.getLong("masterid");
            if (!existsRecordCardMap.containsKey(cardId) || (card2 = cardMap.get(cardId)) == null) continue;
            DynamicObjectCollection cardEntry = card2.getDynamicObjectCollection("facility_entry");
            cardEntry.clear();
            DynamicObjectCollection copyEntry = dataEntity.getDynamicObjectCollection("entryentity");
            DataEntityPropertyCollection properties = cardEntry.getDynamicObjectType().getProperties();
            for (DynamicObject srcRow : copyEntry) {
                DynamicObject destRow = cardEntry.addNew();
                for (IDataEntityProperty property : properties) {
                    if ("id".equals(property.getName())) continue;
                    destRow.set(property.getName(), srcRow.get(property.getName()));
                }
            }
            copyEntry.clear();
            upCards.add(card2);
        }
        if (upCards.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])upCards.toArray(new DynamicObject[0]));
        }
    }

    private void handleFirstModifyCard(BeginOperationTransactionArgs e, MainEntityType recordEntityType, Map<Long, DynamicObject> existsRecordCardMap) {
        int totalCnt = e.getDataEntities().length;
        ArrayList<DynamicObject> needSaveFirstRecords = new ArrayList<DynamicObject>(totalCnt - existsRecordCardMap.size());
        ArrayList<Object[]> firstUpParamList = new ArrayList<Object[]>(totalCnt - existsRecordCardMap.size());
        for (DynamicObject dataEntity : e.getDataEntities()) {
            DynamicObject realcard = dataEntity.getDynamicObject("realcard");
            long cardId = realcard.getLong("masterid");
            if (existsRecordCardMap.containsKey(cardId)) continue;
            long id = DBServiceHelper.genGlobalLongId();
            dataEntity.set("id", (Object)cardId);
            DynamicObject originRecord = new DynamicObject((DynamicObjectType)recordEntityType);
            originRecord.set("id", (Object)id);
            originRecord.set("realcard", (Object)cardId);
            originRecord.set("creater", realcard.get("creater_id"));
            originRecord.set("createtime", realcard.get("createtime"));
            needSaveFirstRecords.add(originRecord);
            firstUpParamList.add(new Object[]{id, cardId});
        }
        if (needSaveFirstRecords.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])needSaveFirstRecords.toArray(new DynamicObject[0]));
            DB.executeBatch((DBRoute)DBRoute.of((String)"fa"), (String)"update t_fa_facility set fid = ? where fid = ?", firstUpParamList);
        }
    }
}

